/*
  Copyright (c) 2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "loginfile.h"
#include "pimsettingexportconsole_debug.h"

#include <QFile>

LogInFile::LogInFile(QObject *parent)
    : QObject(parent)
{

}

LogInFile::~LogInFile()
{

}

QString LogInFile::fileName() const
{
    return mFileName;
}

void LogInFile::setFileName(const QString &fileName)
{
    if (mFileName.isEmpty()) {
        mFileName = fileName;
        QFile file(mFileName);
        mTextStream.setDevice(&file);
    }
}

void LogInFile::addEndLine()
{
    addLogLine(QString(), AddEndLine);
}

void LogInFile::addError(const QString &message)
{
    addLogLine(message, AddError);
}

void LogInFile::addInfo(const QString &message)
{
    addLogLine(message, AddInfo);
}

void LogInFile::addTitle(const QString &message)
{
    addLogLine(message, AddTitle);
}

void LogInFile::addLogLine(const QString &message, LogType type)
{
    QString newMessage;
    switch (type) {
    case AddEndLine:
        newMessage = QLatin1Char('\n');
        break;
    case AddInfo:
        newMessage = QStringLiteral("INFO: %1").arg(message);
        break;
    case AddError:
        newMessage = QStringLiteral("ERROR: %1").arg(message);
        break;
    case AddTitle:
        newMessage = message;
        break;
    }
    mTextStream << newMessage;
}
