//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Model model.h Soprano/Model
    ///  \brief A Model is the central class in %Soprano. It is a queryable
    ///  collection of RDF quadruples, i.e statements.
    ///  Model itself is just an interface for numerous implementations. There are basically
    ///  two types of Models in %Soprano:
    ///  <li>StorageModel</li> is the base class for Model implementations that actually store RDF quadruples.
    ///      StorageModels are created transparently by %Soprano backend plugins: Backend.CreateModel()
    ///  <li>FilterModel</li> is the base class for all filter models. FilterModels can be stacked on top of
    ///      a StorageModel to perform arbitrary tasks like inference or actual content filtering. An
    ///      important FilterModel is Inference.InferenceModel.
    ///  The simplest way to create a memory Model is to use the default Backend:
    ///  <pre>
    ///  Model memModel = Soprano.CreateModel();
    ///  </pre>
    ///  <b>%Error handling:</b>
    ///  Model is based on %Soprano's own error handling system which tries to emulate exceptions to a certain extend.
    ///  Most methods in Model have a means of reporting if an operation was successful or not. For additional error
    ///  information Model inherits ErrorCache which provides the method lastError().
    ///  Thus, advanced error handling would look as follows:
    ///  <pre>
    ///  Soprano.Model model = Soprano.CreateModel();
    ///  Soprano.Statement invalidStatement;
    ///  if( model.AddStatement( invalidStatement ) != Error.ErrorNone ) {
    ///     showErrorMessage( model.LastError().message() );
    ///  }
    ///  </pre>
    ///  For this to work properly Model implementations have to reset the error in each method
    ///  by either calling clearError() or setError().
    ///  \sa \ref soprano_error_handling
    ///  Model is thread-safe when used with a thread-safe backend (all "official" %Soprano backends are thread-safe).
    ///  However, it is recommended to create Model instances in the main thread.
    ///  \author Daniele Galdi <daniele.galdi@gmail.com><br>Sebastian Trueg <trueg@kde.org>
    ///       See <see cref="IModelSignals"></see> for signals emitted by Model
    /// </remarks>        <short>    \class Model model.</short>
    [SmokeClass("Soprano::Model")]
    public abstract class Model : QObject, Soprano.Error.IErrorCache {
        protected Model(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Model), this);
        }
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Add the Statement to the Model.
        ///  \param statement The Statement to add.
        ///          </remarks>        <short>    Add the Statement to the Model.</short>
        [SmokeMethod("addStatement(const Soprano::Statement&)")]
        public abstract Soprano.Error.ErrorCode AddStatement(Soprano.Statement statement);
        /// <remarks>
        ///  \overload
        ///          </remarks>        <short>    \overload          </short>
        public Soprano.Error.ErrorCode AddStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("addStatement####", "addStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Error.ErrorCode AddStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("addStatement###", "addStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  \overload
        ///          </remarks>        <short>    \overload          </short>
        public Soprano.Error.ErrorCode AddStatements(List<Soprano.Statement> statements) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("addStatements?", "addStatements(const QList<Soprano::Statement>&)", typeof(Soprano.Error.ErrorCode), typeof(List<Soprano.Statement>), statements);
        }
        /// <remarks>
        ///  Remove one statement. For removing statements with wildward matching see removeAllStatements().
        ///  \param statement The statement that should be removed. This has to be a valid statement.
        ///  \return Error.ErrorNone on success and an error code if statement was invalid or an error
        ///  occured.
        ///          </remarks>        <short>    Remove one statement.</short>
        [SmokeMethod("removeStatement(const Soprano::Statement&)")]
        public abstract Soprano.Error.ErrorCode RemoveStatement(Soprano.Statement statement);
        /// <remarks>
        ///  \overload
        ///          </remarks>        <short>    \overload          </short>
        public Soprano.Error.ErrorCode RemoveStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeStatement####", "removeStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Error.ErrorCode RemoveStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeStatement###", "removeStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Remove all statements that match the partial statement. For removing
        ///  one specific statement see removeStatement().
        ///  \param statement A possible partially defined statement that serves as
        ///  a filter for all statements that should be removed.
        ///          </remarks>        <short>    Remove all statements that match the partial statement.</short>
        [SmokeMethod("removeAllStatements(const Soprano::Statement&)")]
        public abstract Soprano.Error.ErrorCode RemoveAllStatements(Soprano.Statement statement);
        /// <remarks>
        ///  \overload
        ///  \param subject The subject node to match. Can be empty as a wildcard.
        ///  \param predicate The predicate node to match. Can be empty as a wildcard.
        ///  \param object The object node to match. Can be empty as a wildcard.
        ///  \param context The context node to match. Can be empty as a wildcard.
        ///          </remarks>        <short>    \overload </short>
        public Soprano.Error.ErrorCode RemoveAllStatements(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeAllStatements####", "removeAllStatements(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Error.ErrorCode RemoveAllStatements(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeAllStatements###", "removeAllStatements(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Convenience method which removes all %statements in statements.
        ///          </remarks>        <short>    Convenience method which removes all %statements in statements.</short>
        public Soprano.Error.ErrorCode RemoveStatements(List<Soprano.Statement> statements) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeStatements?", "removeStatements(const QList<Soprano::Statement>&)", typeof(Soprano.Error.ErrorCode), typeof(List<Soprano.Statement>), statements);
        }
        /// <remarks>
        ///  Convenience method that removes all statements in the context.
        ///          </remarks>        <short>    Convenience method that removes all statements in the context.</short>
        public Soprano.Error.ErrorCode RemoveContext(Soprano.Node arg1) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeContext#", "removeContext(const Soprano::Node&)", typeof(Soprano.Error.ErrorCode), typeof(Soprano.Node), arg1);
        }
        /// <remarks>
        ///  Convenience method that clear the Model of all statements
        ///          </remarks>        <short>    Convenience method that clear the Model of all statements          </short>
        public Soprano.Error.ErrorCode RemoveAllStatements() {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("removeAllStatements", "removeAllStatements()", typeof(Soprano.Error.ErrorCode));
        }
        /// <remarks>
        ///  Return an iterator over Model Statements that "partial"
        ///  match the input Statement.
        ///  \param partial The partial Statement to match.
        ///  \return An iterator for all the matched Statements, on error an invalid iterator is returned.
        ///          </remarks>        <short>    Return an iterator over Model Statements that "partial"  match the input Statement.</short>
        [SmokeMethod("listStatements(const Soprano::Statement&) const")]
        public abstract Soprano.StatementIterator ListStatements(Soprano.Statement partial);
        /// <remarks>
        ///  \overload
        ///  \param subject The subject node to match. Can be empty as a wildcard.
        ///  \param predicate The predicate node to match. Can be empty as a wildcard.
        ///  \param object The object node to match. Can be empty as a wildcard.
        ///  \param context The context node to match. Can be empty as a wildcard.
        ///  \return An iterator for all the matched Statements, on error an invalid iterator is returned.
        ///          </remarks>        <short>    \overload </short>
        public Soprano.StatementIterator ListStatements(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.StatementIterator) interceptor.Invoke("listStatements####", "listStatements(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.StatementIterator), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.StatementIterator ListStatements(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.StatementIterator) interceptor.Invoke("listStatements###", "listStatements(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.StatementIterator), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  \overload
        ///  \return An iterator for all statements in the model, on error an invalid iterator is returned.
        ///          </remarks>        <short>    \overload </short>
        public Soprano.StatementIterator ListStatements() {
            return (Soprano.StatementIterator) interceptor.Invoke("listStatements", "listStatements() const", typeof(Soprano.StatementIterator));
        }
        /// <remarks>
        ///  Convenience method which lists all statements in context.
        ///  \return An iterator for all the matched Statements, on error an invalid iterator is returned.
        ///          </remarks>        <short>    Convenience method which lists all statements in context.</short>
        public Soprano.StatementIterator ListStatementsInContext(Soprano.Node context) {
            return (Soprano.StatementIterator) interceptor.Invoke("listStatementsInContext#", "listStatementsInContext(const Soprano::Node&) const", typeof(Soprano.StatementIterator), typeof(Soprano.Node), context);
        }
        /// <remarks>
        ///  List all contexts in the model, i.e. all named graphs.
        ///  \return An iterator over context Nodes, on error an invalid iterator is returned.
        ///          </remarks>        <short>    List all contexts in the model, i.</short>
        [SmokeMethod("listContexts() const")]
        public abstract Soprano.NodeIterator ListContexts();
        /// <remarks>
        ///  Execute the given query over the Model.
        ///  This is a const read-only method. As such Model implementations should not
        ///  support SPARQL extensions such as INSERT or UPDATE through this method.
        ///  A future version of %Soprano will provide an additional API for queries
        ///  that change the Model.
        ///  \param query The query to evaluate.
        ///  \param language The %query language used to encode <pre>query</pre>.
        ///  \param userQueryLanguage If <pre>language</pre> equals Query.QueryLanguageUser
        ///  userQueryLanguage defines the language to use.
        ///  \return An iterator over all results matching the query, 
        ///  on error an invalid iterator is returned.
        ///          </remarks>        <short>    Execute the given query over the Model.</short>
        [SmokeMethod("executeQuery(const QString&, Soprano::Query::QueryLanguage, const QString&) const")]
        public abstract Soprano.QueryResultIterator ExecuteQuery(string query, Soprano.Query.QueryLanguage language, string userQueryLanguage);
        /// <remarks>
        ///  Check if the model contains certain statements.
        ///  \param statement A partially defined statement that serves as
        ///  a pattern.
        ///  \return true if the Model contains a Statement matching the given statement
        ///  pattern.
        ///          </remarks>        <short>    Check if the model contains certain statements.</short>
        [SmokeMethod("containsAnyStatement(const Soprano::Statement&) const")]
        public abstract bool ContainsAnyStatement(Soprano.Statement statement);
        /// <remarks>
        ///  \overload
        ///  \param subject The subject node to match. Can be empty as a wildcard.
        ///  \param predicate The predicate node to match. Can be empty as a wildcard.
        ///  \param object The object node to match. Can be empty as a wildcard.
        ///  \param context The context node to match. Can be empty as a wildcard.
        ///          </remarks>        <short>    \overload </short>
        public bool ContainsAnyStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (bool) interceptor.Invoke("containsAnyStatement####", "containsAnyStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public bool ContainsAnyStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (bool) interceptor.Invoke("containsAnyStatement###", "containsAnyStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Check if the model contains a statements.
        ///  \param statement The statement in question. This has to be a valid statement,
        ///  i.e. subject, predicate, and object need to be defined. If the context node
        ///  is empty the default graph is searched.
        ///  \return <pre>true</pre> if the Model contains the Statement, <pre>false</pre> otherwise or
        ///  is statement is invalid.
        ///          </remarks>        <short>    Check if the model contains a statements.</short>
        [SmokeMethod("containsStatement(const Soprano::Statement&) const")]
        public abstract bool ContainsStatement(Soprano.Statement statement);
        /// <remarks>
        ///  \overload
        ///          </remarks>        <short>    \overload          </short>
        public bool ContainsStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (bool) interceptor.Invoke("containsStatement####", "containsStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public bool ContainsStatement(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (bool) interceptor.Invoke("containsStatement###", "containsStatement(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Convenience method which is based on containsAnyStatement
        ///          </remarks>        <short>    Convenience method which is based on containsAnyStatement          </short>
        public bool ContainsContext(Soprano.Node context) {
            return (bool) interceptor.Invoke("containsContext#", "containsContext(const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), context);
        }
        /// <remarks>
        ///  \return true if the Model doesn't contains any Statement.
        ///          </remarks>        <short>    \return true if the Model doesn't contains any Statement.</short>
        [SmokeMethod("isEmpty() const")]
        public abstract bool IsEmpty();
        /// <remarks>
        ///  The number of statements stored in this Model.
        ///  \return The size of the Model, or -1 on error.
        ///          </remarks>        <short>    The number of statements stored in this Model.</short>
        [SmokeMethod("statementCount() const")]
        public abstract int StatementCount();
        /// <remarks>
        ///  Write all statements in this Model to os.
        ///  Default implementation is based on Model.ListStatements
        ///          </remarks>        <short>    Write all statements in this Model to os.</short>
        [SmokeMethod("write(QTextStream&) const")]
        public virtual Soprano.Error.ErrorCode Write(QTextStream os) {
            return (Soprano.Error.ErrorCode) interceptor.Invoke("write#", "write(QTextStream&) const", typeof(Soprano.Error.ErrorCode), typeof(QTextStream), os);
        }
        /// <remarks>
        ///  Creates a new blank node with a unique identifier.
        ///  \return A blank node that can be used to create new statements.
        ///          </remarks>        <short>    Creates a new blank node with a unique identifier.</short>
        [SmokeMethod("createBlankNode()")]
        public abstract Soprano.Node CreateBlankNode();
        public Model() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Model", "Model()", typeof(void));
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
        protected new IModelSignals Emit {
            get { return (IModelSignals) Q_EMIT; }
        }
    }

    public interface IModelSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when new statements have been added to the model.
        ///  Implementations of this interface have to emit this signal.
        ///          </remarks>        <short>    Emitted when new statements have been added to the model.</short>
        [Q_SIGNAL("void statementsAdded()")]
        void StatementsAdded();
        /// <remarks>
        ///  Emitted when statements have been removed from the model.
        ///  Implementations of this interface have to emit this signal.
        ///          </remarks>        <short>    Emitted when statements have been removed from the model.</short>
        [Q_SIGNAL("void statementsRemoved()")]
        void StatementsRemoved();
        /// <remarks>
        ///  Notification signal for new statements. Model implementations
        ///  should emit this signal for each newly added statement.
        ///          </remarks>        <short>    Notification signal for new statements.</short>
        [Q_SIGNAL("void statementAdded(Soprano::Statement)")]
        void StatementAdded(Soprano.Statement statement);
        /// <remarks>
        ///  Notification signal for removed statements. Model implementations
        ///  should emit this signal for each removed statement.
        ///  \warning Backends may choose not to emit this signal for each
        ///  removed statement but only for a statement pattern (i.e. an
        ///  invalid statement as used in removeAllStatements()) to
        ///  prevent massive performance loss.
        ///          </remarks>        <short>    Notification signal for removed statements.</short>
        [Q_SIGNAL("void statementRemoved(Soprano::Statement)")]
        void StatementRemoved(Soprano.Statement statement);
    }
}
