//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  There is one cache policy per collection, it can either define to
    ///  inherit all properties of the policy of the parent collection (the default)
    ///  or specify the following values:
    ///  - The item parts that should be permanently kept locally and are downloaded
    ///    during a collection sync (eg. full mail vs. just the headers).
    ///  - A time up to which non-permantly cached item parts have to be kept at
    ///    least (0 - infinity).
    ///  - Whether or not a collection sync is triggered on demand, ie. as soon
    ///    as it is accessed by a client.
    ///  - An optional time interval for regular collection sync (aka interval
    ///    mail check).
    ///  @code
    ///  Akonadi.CachePolicy policy;
    ///  policy.setCacheTimeout( 30 );
    ///  policy.setIntervalCheckTime( 20 );
    ///  Akonadi.Collection collection = ...
    ///  collection.setCachePolicy( policy );
    ///  @endcode
    ///  @todo Do we also need a size limit for the cache as well?
    ///  @todo on a POP3 account, is should not be possible to change locally cached parts, find a solution for that
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Represents the caching policy for a collection. </short>
    [SmokeClass("Akonadi::CachePolicy")]
    public class CachePolicy : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected CachePolicy(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CachePolicy), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static CachePolicy() {
            staticInterceptor = new SmokeInvocation(typeof(CachePolicy), null);
        }
        /// <remarks>
        ///  Creates an empty cache policy.
        ///      </remarks>        <short>    Creates an empty cache policy.</short>
        public CachePolicy() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CachePolicy", "CachePolicy()", typeof(void));
        }
        /// <remarks>
        ///  Creates a cache policy from an <code>other</code> cache policy.
        ///      </remarks>        <short>    Creates a cache policy from an <code>other</code> cache policy.</short>
        public CachePolicy(Akonadi.CachePolicy other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CachePolicy#", "CachePolicy(const Akonadi::CachePolicy&)", typeof(void), typeof(Akonadi.CachePolicy), other);
        }
        /// <remarks>
        ///  Returns whether it inherits cache policy from parent collection.
        ///      </remarks>        <short>    Returns whether it inherits cache policy from parent collection.</short>
        public bool InheritFromParent() {
            return (bool) interceptor.Invoke("inheritFromParent", "inheritFromParent() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether the cache policy should be inherited from the parent collection.
        ///      </remarks>        <short>    Sets whether the cache policy should be inherited from the parent collection.</short>
        public void SetInheritFromParent(bool inherit) {
            interceptor.Invoke("setInheritFromParent$", "setInheritFromParent(bool)", typeof(void), typeof(bool), inherit);
        }
        /// <remarks>
        ///  Returns the parts to permanently cache locally.
        ///      </remarks>        <short>    Returns the parts to permanently cache locally.</short>
        public List<string> LocalParts() {
            return (List<string>) interceptor.Invoke("localParts", "localParts() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Specifies the parts to permanently cache locally.
        ///      </remarks>        <short>    Specifies the parts to permanently cache locally.</short>
        public void SetLocalParts(List<string> parts) {
            interceptor.Invoke("setLocalParts?", "setLocalParts(const QStringList&)", typeof(void), typeof(List<string>), parts);
        }
        /// <remarks>
        ///  Returns the cache timeout for non-permanently cached parts in minutes,
        ///  -1 means indefinitely.
        ///      </remarks>        <short>    Returns the cache timeout for non-permanently cached parts in minutes,  -1 means indefinitely.</short>
        public int CacheTimeout() {
            return (int) interceptor.Invoke("cacheTimeout", "cacheTimeout() const", typeof(int));
        }
        /// <remarks>
        ///  Sets cache timeout for non-permanently cached parts.
        /// <param> name="timeout" Timeout in minutes, -1 for indefinitely.
        ///      </param></remarks>        <short>    Sets cache timeout for non-permanently cached parts.</short>
        public void SetCacheTimeout(int timeout) {
            interceptor.Invoke("setCacheTimeout$", "setCacheTimeout(int)", typeof(void), typeof(int), timeout);
        }
        /// <remarks>
        ///  Returns the interval check time in minutes, -1 for never.
        ///      </remarks>        <short>    Returns the interval check time in minutes, -1 for never.</short>
        public int IntervalCheckTime() {
            return (int) interceptor.Invoke("intervalCheckTime", "intervalCheckTime() const", typeof(int));
        }
        /// <remarks>
        ///  Sets interval check time.
        /// <param> name="time" Check time interval in minutes, -1 for never.
        ///      </param></remarks>        <short>    Sets interval check time.</short>
        public void SetIntervalCheckTime(int time) {
            interceptor.Invoke("setIntervalCheckTime$", "setIntervalCheckTime(int)", typeof(void), typeof(int), time);
        }
        /// <remarks>
        ///  Returns whether the collection shall be synced automatically when necessary.
        ///      </remarks>        <short>    Returns whether the collection shall be synced automatically when necessary.</short>
        public bool SyncOnDemand() {
            return (bool) interceptor.Invoke("syncOnDemand", "syncOnDemand() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether the collection shall be synced automatically when necessary.
        /// <param> name="enable" If <code>true</code> the collection is synced.
        ///      </param></remarks>        <short>    Sets whether the collection shall be synced automatically when necessary.</short>
        public void SetSyncOnDemand(bool enable) {
            interceptor.Invoke("setSyncOnDemand$", "setSyncOnDemand(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        public override bool Equals(object o) {
            if (!(o is CachePolicy)) { return false; }
            return this == (CachePolicy) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        ~CachePolicy() {
            interceptor.Invoke("~CachePolicy", "~CachePolicy()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~CachePolicy", "~CachePolicy()", typeof(void));
        }
        public static bool operator==(CachePolicy lhs, Akonadi.CachePolicy other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Akonadi::CachePolicy&) const", typeof(bool), typeof(CachePolicy), lhs, typeof(Akonadi.CachePolicy), other);
        }
        public static bool operator!=(CachePolicy lhs, Akonadi.CachePolicy other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Akonadi::CachePolicy&) const", typeof(bool), typeof(CachePolicy), lhs, typeof(Akonadi.CachePolicy), other);
        }
    }
}
