/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2008 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NFO_H_
#define _SOPRANO_NFO_H_

#include <QtCore/QUrl>

namespace Nepomuk {
    namespace Vocabulary {
        /**
         * This is an excerpt of the NFO ontology as used in the Nepomuk core library.
         *
         * The complete ontology can be found in kdebase/runtime/nepomuk/ontologies
         */
        namespace NFO {
            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#
             */
            QUrl nfoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject
             *
             * A resource containing a finite sequence of bytes with arbitrary
             * information, that is available to a computer program and is
             * usually based on some kind of durable storage. A file is durable
             * in the sense that it remains available for programs to use after
             * the current program has finished.
             */
            QUrl FileDataObject();

            /**
             * http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#fileName
             *
             * Name of the file, together with the extension
             */
            QUrl fileName();
        }
    }
}

#endif
