//Auto-generated by kalyptus. DO NOT EDIT.
namespace Nepomuk {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Thing thing.h Nepomuk/Thing
    ///  \brief A Nepomuk PIMO Thing resource.
    ///  A Thing represents a unique abstract concept/idea or real-world
    ///  entity which can have multiple representations or occurrences.
    ///  A typical example for a Thing is a unique person resource
    ///  which identifies the person itself, not any representation
    ///  such as an addressbook entry.
    ///  Things are typically grounded via application resources,
    ///  i.e. those resources that are created or handled by applications.
    ///  Again the typical example is the addressbook entry.
    ///  In general it is recommended to alway use the Thing instead of the
    ///  grounding resource to annotate, i.e. to add tags, or relate to other
    ///  resources. The advantage is its uniqueness. While there can be many
    ///  occurrences of one concept there is only one Thing, identifying
    ///  uniquely.
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///  \since 4.2
    ///      </remarks>        <short>    \class Thing thing.</short>
    [SmokeClass("Nepomuk::Thing")]
    public class Thing : Nepomuk.Resource, IDisposable {
        protected Thing(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Thing), this);
        }
        /// <remarks>
        ///  Create a Thing object with URI <pre>uri</pre>. If the Thing does not
        ///  exist in the Nepomuk storage yet, it will be created once
        ///  a writing method is called (such as Resource.SetProperty).
        ///  \param uri The URI of the Thing. If empty, a new random one
        ///  will be created.
        ///  \param pimoType The type of this Thing. Needs to be a subtype
        ///  of pimo:Thing. If empty defaults to pimo:Thing.
        ///          </remarks>        <short>    Create a Thing object with URI \p uri.</short>
        public Thing(QUrl uri, QUrl pimoType) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing##", "Thing(const QUrl&, const QUrl&)", typeof(void), typeof(QUrl), uri, typeof(QUrl), pimoType);
        }
        public Thing(QUrl uri) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing#", "Thing(const QUrl&)", typeof(void), typeof(QUrl), uri);
        }
        public Thing() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing", "Thing()", typeof(void));
        }
        /// <remarks>
        ///  Create a new Thing with label or URI <pre>uriOrName</pre>
        ///  \param uriOrName The URI or the label of the Thing. The constructor
        ///  tries hard to find the Thing associated. If it is not found, a new
        ///  Thing will be created.
        ///  \param pimoType The type of this Thing. Needs to be a subtype
        ///  of pimo:Thing. If empty defaults to pimo:Thing.
        ///  Be aware that using the other constructor is always faster in case
        ///  the URI of the Thing is known.
        ///          </remarks>        <short>    Create a new Thing with label or URI \p uriOrName </short>
        public Thing(string uriOrName, QUrl pimoType) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing$#", "Thing(const QString&, const QUrl&)", typeof(void), typeof(string), uriOrName, typeof(QUrl), pimoType);
        }
        public Thing(string uriOrName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing$", "Thing(const QString&)", typeof(void), typeof(string), uriOrName);
        }
        /// <remarks>
        ///  Copy constructor.
        ///          </remarks>        <short>    Copy constructor.</short>
        public Thing(Nepomuk.Thing other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing#", "Thing(const Nepomuk::Thing&)", typeof(void), typeof(Nepomuk.Thing), other);
        }
        /// <remarks>
        ///  Copy constructor.
        ///  \param other the resoruce to construct the Thing from.
        ///          </remarks>        <short>    Copy constructor.</short>
        public Thing(Nepomuk.Resource other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Thing#", "Thing(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), other);
        }
        /// <remarks>
        ///  Get the grounding occurrences for this Thing.
        ///  Grounding resources are physical representations
        ///  of the Thing.
        ///  An example is an mp3 file which represents an audio track
        ///  or a website which represents a company or a person. Or the
        ///  addressbook entry for an abstract person thing.
        ///  \sa pimo:groundingResource
        ///          </remarks>        <short>    Get the grounding occurrences for this Thing.</short>
        public List<Nepomuk.Resource> GroundingOccurrences() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("groundingOccurrences", "groundingOccurrences() const", typeof(List<Nepomuk.Resource>));
        }
        public List<Nepomuk.Resource> ReferencingOccurrences() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("referencingOccurrences", "referencingOccurrences() const", typeof(List<Nepomuk.Resource>));
        }
        public List<Nepomuk.Resource> Occurrences() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("occurrences", "occurrences() const", typeof(List<Nepomuk.Resource>));
        }
        ~Thing() {
            interceptor.Invoke("~Thing", "~Thing()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Thing", "~Thing()", typeof(void));
        }
    }
}
