//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class contains information such as total number of items,
    ///  number of new and unread items, etc.
    ///  These information might be expensive to obtain and are thus
    ///  not included when fetching collection with a CollectionFetchJob.
    ///  They can be retrieved spearately using CollectionStatisticsJob.
    ///  Example:
    ///  @code
    ///  Akonadi.Collection collection = ...
    ///  Akonadi.CollectionStatisticsJob job = new Akonadi.CollectionStatisticsJob( collection );
    ///  if ( job.Exec() ) {
    ///    Akonadi.CollectionStatistics statistics = job.Statistics();
    ///    qDebug() << "Unread items:" << statistics.unreadCount();
    ///  }
    ///  @endcode
    ///  This class is implicitely shared.
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Provides statistics information of a Collection. </short>
    [SmokeClass("Akonadi::CollectionStatistics")]
    public class CollectionStatistics : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected CollectionStatistics(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(CollectionStatistics), this);
        }
        /// <remarks>
        ///  Creates a new collection statistics object.
        ///      </remarks>        <short>    Creates a new collection statistics object.</short>
        public CollectionStatistics() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionStatistics", "CollectionStatistics()", typeof(void));
        }
        /// <remarks>
        ///  Creates a collection statistics object from an <code>other</code> one.
        ///      </remarks>        <short>    Creates a collection statistics object from an <code>other</code> one.</short>
        public CollectionStatistics(Akonadi.CollectionStatistics other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("CollectionStatistics#", "CollectionStatistics(const Akonadi::CollectionStatistics&)", typeof(void), typeof(Akonadi.CollectionStatistics), other);
        }
        /// <remarks>
        ///  Returns the number of items in this collection or @c -1 if
        ///  this information is not available.
        /// </remarks>        <short>    Returns the number of items in this collection or @c -1 if  this information is not available.</short>
        ///         <see> setCount</see>
        ///         <see> unreadCount</see>
        public long Count() {
            return (long) interceptor.Invoke("count", "count() const", typeof(long));
        }
        /// <remarks>
        ///  Sets the number of items in this collection.
        /// <param> name="count" The number of items.
        /// </param></remarks>        <short>    Sets the number of items in this collection.</short>
        ///         <see> count</see>
        public void SetCount(long count) {
            interceptor.Invoke("setCount$", "setCount(qint64)", typeof(void), typeof(long), count);
        }
        /// <remarks>
        ///  Returns the number of unread items in this collection or @c -1 if
        ///  this information is not available.
        /// </remarks>        <short>    Returns the number of unread items in this collection or @c -1 if  this information is not available.</short>
        ///         <see> setUnreadCount</see>
        ///         <see> count</see>
        public long UnreadCount() {
            return (long) interceptor.Invoke("unreadCount", "unreadCount() const", typeof(long));
        }
        /// <remarks>
        ///  Sets the number of unread items in this collection.
        /// <param> name="count" The number of unread messages.
        /// </param></remarks>        <short>    Sets the number of unread items in this collection.</short>
        ///         <see> unreadCount</see>
        public void SetUnreadCount(long count) {
            interceptor.Invoke("setUnreadCount$", "setUnreadCount(qint64)", typeof(void), typeof(long), count);
        }
        ~CollectionStatistics() {
            interceptor.Invoke("~CollectionStatistics", "~CollectionStatistics()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~CollectionStatistics", "~CollectionStatistics()", typeof(void));
        }
    }
}
