/*  -*- mode: C++; c-file-style: "gnu" -*-
    dictionarycombobox.h

    This file is part of KMail, the KDE mail client.
    Copyright (c) 2003 Ingo Kloecker <kloecker@kde.org>

    KMail is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the Qt library by Trolltech AS, Norway (or with modified versions
    of Qt that use the same license as Qt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    Qt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef KDEPIM_DICTIONARYCOMBOBOX_H
#define KDEPIM_DICTIONARYCOMBOBOX_H

#include "kdepim_export.h"
#include <QComboBox>

class QStringList;
class QString;
namespace Sonnet {
  class Speller;
}

namespace KPIM {

  /**
   * @short A combo box for selecting the dictionary used for spell checking.
   * @author Ingo Kloecker <kloecker@kde.org>
   **/

  class KDEPIM_EXPORT DictionaryComboBox : public QComboBox {
    Q_OBJECT
  public:
    DictionaryComboBox( QWidget * parent=0 );
    ~DictionaryComboBox();

    QString currentDictionaryName() const;
    QString currentDictionary() const;

    QString realDictionaryName() const;

    void setCurrentByDictionaryName( const QString & dictionaryName );
    void setCurrentByDictionary( const QString & dictionary );
    void setCurrentByDictionaryCode( const QString &dictionaryCode );

  signals:
    /** @em Emitted whenever the current dictionary changes. Either
     *  by user intervention or on setCurrentByDictionaryName() or on
     *  setCurrentByDictionary().
     **/
    void dictionaryChanged( const QString & dictionary );
    void dictionaryChanged( int );

  protected slots:
    void slotDictionaryChanged( int );

  protected:
    void reloadCombo();

  protected:
    QStringList mDictionaries;
    int mDefaultDictionary;
    Sonnet::Speller *mspeller;
  };

} // namespace KPIM

#endif // _KPIM_DICTIONARYCOMBOBOX_H_
