// Illustrates basic usage of custom signals.
// Also see the t7 tutorial.

namespace QtSamples {
	using System;
	using Qt;

	[DeclareQtSignal ("MySignal()")]
	public class EmitSample: QVBox {
		public EmitSample (): this (null, "") {}

		public EmitSample (QWidget parent, string name): base ()
		{
			QPushButton pb = new QPushButton ("Papa Smurf", this);

			Connect (pb, SIGNAL ("clicked ()"), SLOT ("DoEmit ()"));
			Connect (this, SIGNAL ("MySignal ()"), SLOT ("PrintStuff ()"));
		}

		public void DoEmit ()
		{
			Emit ("MySignal()");
		}

		public void PrintStuff ()
		{
			Console.WriteLine ("Emitted MySignal");
		}

		public static int Main (string[] args)
		{
			QApplication app = new QApplication (args);
			EmitSample es = new EmitSample ();
			app.SetMainWidget (es);
			es.Show ();
			int ret = app.Exec ();
			es.Dispose();
			return ret;
		}
	}
}
