#!/usr/bin/env python
"""

"""
import sys
from kdecore import KApplication, KCmdLineArgs
from kdeui import KMainWindow
from qt import QVBoxLayout

## relative import -- cry me a river!
import about


class SamplerRunnerWindow(KMainWindow):
    def __init__(self, ctor):
        KMainWindow.__init__(self)
        layout = QVBoxLayout(self)
        layout.setAutoAdd(True)
        self.widget = ctor(self)


def importItem(name):
    """ importItem(name) -> import an item from a module by dotted name

    """
    def importName(name):
        """ importName(name) -> import and return a module by name in dotted form
    
            Copied from the Python lib docs.
        """
        mod = __import__(name)
        for comp in name.split('.')[1:]:
            mod = getattr(mod, comp)
        return mod

    names = name.split('.')
    modname, itemname = names[0:-1], names[-1]
    mod = importName(str.join('.', modname))
    return getattr(mod, itemname)



if __name__ == '__main__':
    options = [('+item', 'An item in the sys.path')]
    KCmdLineArgs.init(sys.argv, about.about)
    KCmdLineArgs.addCmdLineOptions(options)
 
    args = KCmdLineArgs.parsedArgs()
    if not args.count():
        args.usage()
    else:
        pathitem = args.arg(0)
        widget = importItem(pathitem)

    app = KApplication()
    mainWindow = SamplerRunnerWindow(widget)
    mainWindow.show()
    app.exec_loop()
