


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvaspixmaparray_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasPixmapArrayImp::QCanvasPixmapArrayImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasPixmapArrayImp::~QCanvasPixmapArrayImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasPixmapArrayImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPixmapArrayImp *meth = new QCanvasPixmapArrayImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasPixmapArrayImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_readPixmaps_6, "readPixmaps" },
        { Method_readCollisionMasks_7, "readCollisionMasks" },
        { Method_isValid_9, "isValid" },
        { Method_image_10, "image" },
        { Method_setImage_11, "setImage" },
        { Method_count_12, "count" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPixmapArrayImp *meth = new QCanvasPixmapArrayImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasPixmapArray pointer from an Object.
 */
QCanvasPixmapArray *QCanvasPixmapArrayImp::toQCanvasPixmapArray( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasPixmapArray *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasPixmapArray" )
        return 0;

    return op->toNative<QCanvasPixmapArray>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasPixmapArrayImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPixmapArray_1:
             return QCanvasPixmapArray_1( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_2:
             return QCanvasPixmapArray_2( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_3:
             return QCanvasPixmapArray_3( exec, args );
             break;

         case Constructor_QCanvasPixmapArray_4:
             return QCanvasPixmapArray_4( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasPixmapArrayCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object QCanvasPixmapArrayImp::QCanvasPixmapArray_1( KJS::ExecState *exec, const KJS::List &args )
{


    // We should now create an instance of the QCanvasPixmapArray object

    QCanvasPixmapArray *ret = new QCanvasPixmapArray(
        );

	return KJS::Object();
}

KJS::Object QCanvasPixmapArrayImp::QCanvasPixmapArray_2( KJS::ExecState *exec, const KJS::List &args )
{

    QString arg0 = extractQString(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);


    // We should now create an instance of the QCanvasPixmapArray object

    QCanvasPixmapArray *ret = new QCanvasPixmapArray(

          arg0,
          arg1 );
	return KJS::Object();

}

KJS::Object QCanvasPixmapArrayImp::QCanvasPixmapArray_3( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QPtrList< QPixmap >
    return KJS::Object();

    QPtrList< QPixmap > arg0; // Dummy

    // Unsupported parameter QPtrList< QPoint >
    return KJS::Object();

    QPtrList< QPoint > arg1; // Dummy


    // We should now create an instance of the QCanvasPixmapArray object

    QCanvasPixmapArray *ret = new QCanvasPixmapArray(

          arg0,
          arg1 );


}

KJS::Object QCanvasPixmapArrayImp::QCanvasPixmapArray_4( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QValueList< QPixmap >
    return KJS::Object();

    QValueList< QPixmap > arg0; // Dummy

    // Unsupported parameter QPointArray
    return KJS::Object();

    QPointArray arg1; // Dummy


    // We should now create an instance of the QCanvasPixmapArray object

    QCanvasPixmapArray *ret = new QCanvasPixmapArray(

          arg0,
          arg1 );


}

KJS::Value QCanvasPixmapArrayImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasPixmapArrayImp::toQCanvasPixmapArray( self );

    switch( id ) {

    case Method_readPixmaps_6:
        return readPixmaps_6( exec, self, args );
        break;

    case Method_readCollisionMasks_7:
        return readCollisionMasks_7( exec, self, args );
        break;

    case Method_isValid_9:
        return isValid_9( exec, self, args );
        break;

    case Method_image_10:
        return image_10( exec, self, args );
        break;

    case Method_setImage_11:
        return setImage_11( exec, self, args );
        break;

    case Method_count_12:
        return count_12( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasPixmapArrayImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasPixmapArrayImp::readPixmaps_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QString arg0 = extractQString(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->readPixmaps(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasPixmapArrayImp::readCollisionMasks_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QString arg0 = extractQString(exec, args, 0);

      bool ret;
      ret = instance->readCollisionMasks(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasPixmapArrayImp::isValid_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isValid(  );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasPixmapArrayImp::image_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->image(
       arg0 );
      return KJS::Value(); // Returns 'QCanvasPixmap *'

}

KJS::Value QCanvasPixmapArrayImp::setImage_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    // Unsupported parameter QCanvasPixmap *
    return KJS::Value();

    QCanvasPixmap * arg1; // Dummy

      instance->setImage(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasPixmapArrayImp::count_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      uint ret;
      ret = instance->count(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


