//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import java.util.ArrayList;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 The dir lister deals with the kiojob used to list and update a directory
 and has signals for the user of this class (e.g. konqueror view or
 kdesktop) to create/destroy its items when asked.
 This class is independent from the graphical representation of the dir
 (icon container, tree view, ...) and it stores the items (as KFileItems).
 Typical usage :

	<li>
	Create an instance.
	</li>
	
	<li>
	Connect to at least update, clear, newItem, and deleteItem.
	</li>
	
	<li>
	Call openURL - the signals will be called.
	</li>
	
	<li>
	Reuse the instance when opening a new url (openURL).
	</li>
	
	<li>
	Destroy the instance when not needed anymore (usually destructor).
	</li>
	 Advanced usage : call openURL with _keep = true to list directories
 without forgetting the ones previously read (e.g. for a tree view)
 See {@link KDirListerSignals} for signals emitted by KDirLister
		@author Michael Brade <brade@kde.org>
 
		@short Helper class for the kiojob used to list and update a directory.

*/
public class KDirLister extends QObject  {
	protected KDirLister(Class dummy){super((Class) null);}
	/**	
		 Used by items() and itemsForDir() to specify whether you want
		 all items for a directory or just the filtered ones.
		   		@short    Used by items() and itemsForDir() to specify whether you want  all items for a directory or just the filtered ones.
	*/
	public static final int AllItems = 0;
	public static final int FilteredItems = 1;

	public static final int NONE = 0;
	public static final int NAME_FILTER = 1;
	public static final int MIME_FILTER = 2;
	public static final int DOT_FILES = 4;
	public static final int DIR_ONLY_MODE = 8;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Create a directory lister.
			@param _delayedMimeTypes if true, mime types will be fetched on demand. If false,
		                          they will always be fetched immediately
		   		@short    Create a directory lister.
	*/
	public KDirLister(boolean _delayedMimeTypes) {
		super((Class) null);
		newKDirLister(_delayedMimeTypes);
	}
	private native void newKDirLister(boolean _delayedMimeTypes);
	public KDirLister() {
		super((Class) null);
		newKDirLister();
	}
	private native void newKDirLister();
	/**	
		 Run the directory lister on the given url.
			 This method causes KDirLister to emit _all_ the items of <code>_url</code>, in any case.
		 Depending on <code>_keep</code> either clear() or clear(KURL) will be
		 emitted first.
			 The newItems() signal may be emitted more than once to supply you
		 with KFileItems, up until the signal completed() is emitted
		 (and isFinished() returns true).
			@param _url the directory URL.
			@param _keep if true the previous directories aren't forgotten
		                 (they are still watched by kdirwatch and their items
		                 are kept for this KDirLister). This is useful for e.g.
		                 a treeview.
			@param _reload indicates wether to use the cache (false) or to reread the
		                 directory from the disk.
		                 Use only when opening a dir not yet listed by this lister
		                 without using the cache. Otherwise use updateDirectory.
				@return true    if successful, 
         false   otherwise (e.g. invalid <code>_url</code>)
   
		@short    Run the directory lister on the given url.
	*/
	public native boolean openURL(KURL _url, boolean _keep, boolean _reload);
	public native boolean openURL(KURL _url, boolean _keep);
	public native boolean openURL(KURL _url);
	/**	
		 Stop listing all directories currently being listed.
			 Emits canceled() if there was at least one job running.
		 Emits canceled( KURL ) for each stopped job if
		 there are at least two dirctories being watched by KDirLister.
		   		@short    Stop listing all directories currently being listed.
	*/
	public native void stop();
	/**	
		 Stop listing the given directory.
			 Emits canceled() if the killed job was the last running one.
		 Emits canceled( KURL ) for the killed job if
		 there are at least two directories being watched by KDirLister.
		 No signal is emitted if there was no job running for <code>_url.</code>
			@param _url the directory URL
		   		@short    Stop listing the given directory.
	*/
	public native void stop(KURL _url);
	/**	
		 Checks whether KDirWatch will automatically update directories. This is
		 enabled by default.
				@return true if KDirWatch is used to automatically update directories.
   
		@short    Checks whether KDirWatch will automatically update directories.
	*/
	public native boolean autoUpdate();
	/**	
		 Enable/disable automatic directory updating, when a directory changes
		 (using KDirWatch).
			@param enable true to enable, false to disable
		   		@short    Enable/disable automatic directory updating, when a directory changes  (using KDirWatch).
	*/
	public native void setAutoUpdate(boolean enable);
	/**	
		 Check whether auto error handling is enabled.
		 If enabled, it will show an error dialog to the user when an
		 error occurs. It is turned on by default.
				@return true if auto error handling is enabled, false otherwise

		@short    Check whether auto error handling is enabled.
		@see #setAutoErrorHandlingEnabled
	*/
	public native boolean autoErrorHandlingEnabled();
	/**	
		 Enable or disable auto error handling is enabled.
		 If enabled, it will show an error dialog to the user when an
		 error occurs. It is turned on by default.
			@param enable true to enable auto error handling, false to disable
			@param parent the parent widget for the error dialogs, can be 0 for
		               top-level
				@short    Enable or disable auto error handling is enabled.
		@see #autoErrorHandlingEnabled
	*/
	public native void setAutoErrorHandlingEnabled(boolean enable, QWidget parent);
	/**	
		 Checks whether hidden files (files beginning with a dot) will be
		 shown.
		 By default this option is disabled (hidden files will be not shown).
				@return true if dot files are shown, false otherwise

		@short    Checks whether hidden files (files beginning with a dot) will be  shown.
		@see #setShowingDotFiles
	*/
	public native boolean showingDotFiles();
	/**	
		 Changes the "is viewing dot files" setting.
		 Calls updateDirectory() if setting changed.
		 By default this option is disabled (hidden files will not be shown).
			@param _showDotFiles true to enable showing hidden files, false to
		        disable
				@short    Changes the "is viewing dot files" setting.
		@see #showingDotFiles
	*/
	public native void setShowingDotFiles(boolean _showDotFiles);
	/**	
		 Checks whether the KDirLister only lists directories or all
		 files.
		 By default this option is disabled (all files will be shown).
				@return true if setDirOnlyMode(true) was called
   
		@short    Checks whether the KDirLister only lists directories or all  files.
	*/
	public native boolean dirOnlyMode();
	/**	
		 Call this to list only directories.
		 By default this option is disabled (all files will be shown).
			@param dirsOnly true to list only directories
		   		@short    Call this to list only directories.
	*/
	public native void setDirOnlyMode(boolean dirsOnly);
	/**	
		 Returns the top level URL that is listed by this KDirLister.
		 It might be different from the one given with openURL() if there was a 
		 redirection. If you called openURL() with <code>_keep</code> == true this is the
		 first url opened (e.g. in a treeview this is the root).
				@return the url used by this instance to list the files.
   
		@short    Returns the top level URL that is listed by this KDirLister.
	*/
	public native KURL url();
	/**	
		 Returns all URLs that are listed by this KDirLister. This is only
		 useful if you called openURL() with <code>_keep</code> == true, as it happens in a
		 treeview, for example. (Note that the base url is included in the list
		 as well, of course.)
				@return the list of all listed URLs

		@short    Returns all URLs that are listed by this KDirLister.
	*/
	public native ArrayList directories();
	/**	
		 Actually emit the changes made with setShowingDotFiles, setDirOnlyMode,
		 setNameFilter and setMimeFilter.
		   		@short    Actually emit the changes made with setShowingDotFiles, setDirOnlyMode,  setNameFilter and setMimeFilter.
	*/
	public native void emitChanges();
	/**	
		 Update the directory <code>_dir.</code> This method causes KDirLister to _only_ emit
		 the items of <code>_dir</code> that actually changed compared to the current state in the
		 cache and updates the cache.
			 The current implementation calls updateDirectory automatically for
		 local files, using KDirWatch (if autoUpdate() is true), but it might be
		 useful to force an update manually.
			@param _dir the directory URL
		   		@short    Update the directory <code>_dir.</code>
	*/
	public native void updateDirectory(KURL _dir);
	/**	
		 Returns true if no io operation is currently in progress.
				@return true if finished, false otherwise
   
		@short    Returns true if no io operation is currently in progress.
	*/
	public native boolean isFinished();
	/**	
		 Returns the file item of the URL.
				@return the file item for url() itself (".")
   
		@short    Returns the file item of the URL.
	*/
	public native KFileItem rootItem();
	/**	
		 Find an item by its URL.
			@param _url the item URL
				@return the pointer to the KFileItem
   
		@short    Find an item by its URL.
	*/
	public native KFileItem findByURL(KURL _url);
	public native KFileItem find(KURL _url);
	/**	
		 Find an item by its name.
			@param name the item name
				@return the pointer to the KFileItem
   
		@short    Find an item by its name.
	*/
	public native KFileItem findByName(String name);
	/**	
		 Set a name filter to only list items matching this name, e.g. "*.cpp".
			 You can set more than one filter by separating them with whitespace, e.g
		 "*.cpp .h".
		 Note: the direcory is not automatically reloaded.
			@param filter the new filter, null to disable filtering
				@short    Set a name filter to only list items matching this name, e.
		@see #matchesFilter
	*/
	public native void setNameFilter(String filter);
	/**	
		 Returns the current name filter, as set via setNameFilter()
				@return the current name filter, can be null if filtering
         is turned off
   
		@short    Returns the current name filter, as set via setNameFilter()
	*/
	public native String nameFilter();
	/**	
		 Set mime-based filter to only list items matching the given mimetypes.
			 NOTE: setting the filter does not automatically reload direcory.
		 Also calling this function will not affect any named filter already set.
			@param mimeList a list of mime-types.
				@short    Set mime-based filter to only list items matching the given mimetypes.
		@see #clearMimeFilter
		@see #matchesMimeFilter
	*/
	public native void setMimeFilter(String[] mimeList);
	/**	
		 Filtering should be done with KFileFilter. This will be implemented in a later
		 revision of KDirLister. This method may be removed then.
			 Set mime-based exclude filter to only list items not matching the given mimetypes
			 NOTE: setting the filter does not automatically reload direcory.
		 Also calling this function will not affect any named filter already set.
			@param mimeList a list of mime-types.
			   		@short    Filtering should be done with KFileFilter.
		@see #clearMimeFilter
		@see #matchesMimeFilter
	*/
	public native void setMimeExcludeFilter(String[] mimeList);
	/**	
		 Clears the mime based filter.
				@short    Clears the mime based filter.
		@see #setMimeFilter
	*/
	public native void clearMimeFilter();
	/**	
		 Returns the list of mime based filters, as set via setMimeFilter().
				@return the list of mime based filters. Empty, when no mime filter is set.
   
		@short    Returns the list of mime based filters, as set via setMimeFilter().
	*/
	public native ArrayList mimeFilters();
	/**	
		 Checks whether <code>name</code> matches a filter in the list of name filters.
				@return true if <code>name</code> matches a filter in the list,
 otherwise false.

		@short    Checks whether <code>name</code> matches a filter in the list of name filters.
		@see #setNameFilter
	*/
	public native boolean matchesFilter(String name);
	/**	
		 Checks whether <code>mime</code> matches a filter in the list of mime types
			@param mime the mimetype to find in the filter list.
				@return true if <code>name</code> matches a filter in the list,
 otherwise false.

		@short    Checks whether <code>mime</code> matches a filter in the list of mime types 
		@see #setMimeFilter#
	*/
	public native boolean matchesMimeFilter(String mime);
	/**	
		 Pass the main window this object is associated with
		 this is used for caching authentication data
			@param window the window to associate with, 0 to disassociate
				@short    Pass the main window this object is associated with  this is used for caching authentication data
	*/
	public native void setMainWindow(QWidget window);
	/**	
		 Returns the main window associated with this object.
				@return the associated main window, or 0 if there is none

		@short    Returns the main window associated with this object.
	*/
	public native QWidget mainWindow();
	/**	
		 Returns the items listed for the current url().
		 This method will NOT start listing a directory, you should only call
		 this when receiving the finished() signal.
			 The items in the KFileItemList are references to the items used
		 by KDirLister, so e.g. an item gets destroyed when the deleteItem()
		 signal is emitted.
			@param which specifies whether the returned list will contain all entries
		              or only the ones that passed the nameFilter(), mimeFilter(),
		              etc. Note that the latter causes iteration over all the 
		              items, filtering them. If this is too slow for you, use the
		              newItems() signal, sending out filtered items in chunks.
				@return the items listed for the current url().

		@short    Returns the items listed for the current url().
	*/
	public native ArrayList items(int which);
	public native ArrayList items();
	/**	
		 Returns the items listed for the given <code>dir.</code>
		 This method will NOT start listing <code>dir</code>, you should only call
		 this when receiving the finished() signal.
			 The items in the KFileItemList are references to the items used
		 by KDirLister, so e.g. an item gets destroyed when the deleteItem()
		 signal is emitted.
			@param dir specifies the url for which the items should be returned. This
		            is only useful if you use KDirLister with multiple URLs
		            i.e. using boolean keep = true in openURL().
			@param which specifies whether the returned list will contain all entries
		              or only the ones that passed the nameFilter, mimeFilter, etc.
		              Note that the latter causes iteration over all the items,
		              filtering them. If this is too slow for you, use the
		 newItems() signal, sending out filtered items in chunks.
				@return the items listed for <code>dir.</code>

		@short    Returns the items listed for the given <code>dir.</code>
	*/
	public native ArrayList itemsForDir(KURL dir, int which);
	public native ArrayList itemsForDir(KURL dir);
	/**	
		 Called for every new item before emitting newItems().
		 You may reimplement this method in a subclass to implement your own
		 filtering.
		 The default implementation filters out ".." and everything not matching
		 the name filter(s)
				@return true if the item is "ok".
         false if the item shall not be shown in a view, e.g.
 files not matching a pattern *.cpp ( KFileItem.isHidden())

		@short    Called for every new item before emitting newItems().
		@see #matchesFilter
		@see #setNameFilter
	*/
	protected native boolean matchesFilter(KFileItem arg1);
	/**	
		 Called for every new item before emitting newItems().
		 You may reimplement this method in a subclass to implement your own
		 filtering.
		 The default implementation filters out ".." and everything not matching
		 the name filter(s)
				@return true if the item is "ok".
         false if the item shall not be shown in a view, e.g.
 files not matching a pattern *.cpp ( KFileItem.isHidden())

		@short    Called for every new item before emitting newItems().
		@see #matchesMimeFilter
		@see #setMimeFilter
	*/
	protected native boolean matchesMimeFilter(KFileItem arg1);
	/**	
		 Called by the public matchesFilter() to do the
		 actual filtering. Those methods may be reimplemented to customize
		 filtering.
			@param name the name to filter
			@param filters a list of regular expressions for filtering
		   		@short    Called by the public matchesFilter() to do the  actual filtering.
	*/
	// bool doNameFilter(const QString& arg1,const QPtrList<QRegExp>& arg2); >>>> NOT CONVERTED
	/**	
		 Called by the public matchesMimeFilter() to do the
		 actual filtering. Those methods may be reimplemented to customize
		 filtering.
			@param mime the mime type to filter
			@param filters the list of mime types to filter
		   		@short    Called by the public matchesMimeFilter() to do the  actual filtering.
	*/
	protected native boolean doMimeFilter(String mime, String[] filters);
	/**	
			   		@short
	*/
	protected native boolean doMimeExcludeFilter(String mimeExclude, String[] filters);
	/**	
		 Checks if an url is malformed or not and displays an error message
		 if it is and autoErrorHandling is set to true.
				@return true if url is valid, otherwise false.
   
		@short    Checks if an url is malformed or not and displays an error message  if it is and autoErrorHandling is set to true.
	*/
	protected native boolean validURL(KURL arg1);
	/**	 Reimplement to customize error handling 		@short   Reimplement to customize error handling
	*/
	protected native void handleError(Job arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
