/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey (kde@jrockey.com)                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "importedmodules.h"

#include <kdebug.h>

namespace PythonDCOP {

  ImportedModules *ImportedModules::m_instance = NULL;

  ImportedModules::ImportedModules() : m_dcop_module(NULL)
  {
    m_dcop_module = PyImport_ImportModule( (char*)"pydcop" );
    if ( !m_dcop_module )
      kdDebug(70001) << "Could not import pydcop module" << endl;
  }

  ImportedModules::~ImportedModules()
  {
  }

  PyObject* ImportedModules::createDCOPObject( const char* appname, const char* objname )
  {
    if ( !m_dcop_module )
      return 0;

    PyObject* dict = PyModule_GetDict( m_dcop_module );
    if ( !dict )
      return 0;

    PyObject* cl = PyDict_GetItemString( dict, (char*)"DCOPObject" );
    if ( !cl )
      return 0;

    PyObject* args = PyTuple_New( 2 );
    PyTuple_SetItem( args, 0, PyString_FromString( appname ) );
    PyTuple_SetItem( args, 1, PyString_FromString( objname ) );

    return PyObject_CallObject( cl, args );
  }

}
