import org.kde.qt.*;

public class Tut5 extends QVBox {
	public Tut5() {
		QPushButton quit = new QPushButton("Quit", this, "quit");
		quit.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), qApp(), SLOT("quit()"));

		QLCDNumber lcd = new QLCDNumber(2, this, "lcd");

		QSlider slider = new QSlider(Horizontal, this, "slider");
		slider.setRange(0, 99);
		slider.setValue(0);

		connect(slider, SIGNAL("valueChanged(int)"), lcd, SLOT("display(int)"));
	}
	
	public static void main(String[] args) {
		QApplication a = new QApplication(args);

		Tut5 w = new Tut5();
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.kde.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
