#!/usr/bin/env python

"""**************************************************************************
** $Id: tabdialog.py 322023 2004-06-19 20:33:37Z sedwards $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

class TabDialog( QTabDialog ):
    def __init__( self, parent=None, name=None, filename=None ):
        QTabDialog.__init__( self, parent, name )
        self.filename = QString( filename )
        self.fileinfo = QFileInfo( filename )
        self.setupTab1()
        self.setupTab2()
        self.setupTab3()
        self.connect( self, SIGNAL("applyButtonPressed()"), qApp, SLOT("quit()" ) )

    def setupTab1( self ):
        tab1 = QVBox( self )
        tab1.setMargin( 5 )

        QLabel( "Filename:", tab1 )
        fname = QLineEdit( self.filename, tab1 )
        fname.setFocus()

        QLabel( "Path:", tab1 )
        path = QLabel( self.fileinfo.dirPath( True ), tab1 )
        path.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        QLabel( "Size:", tab1 )
        size = QLabel( QString( "%1 KB" ).arg( self.fileinfo.size() ), tab1 )
        size.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        QLabel( "Last Read:", tab1 )
        lread = QLabel( self.fileinfo.lastRead().toString(), tab1 )
        lread.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        QLabel( "Last Modified:", tab1 )
        lmodif = QLabel( self.fileinfo.lastModified().toString(), tab1 )
        lmodif.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        self.addTab( tab1, "General" )
   
    def setupTab2( self ):
        tab2 = QVBox( self )
        tab2.setMargin( 5 )

        bg = QButtonGroup( 1, QGroupBox.Horizontal, "Permissions", tab2 )

        readable = QCheckBox( "Readable", bg )
        if self.fileinfo.isReadable() :
            readable.setChecked( True )

        writable = QCheckBox( "Writeable", bg )
        if self.fileinfo.isWritable() :
            writable.setChecked( True )

        executable = QCheckBox( "Executable", bg )
        if self.fileinfo.isExecutable() :
            executable.setChecked( True )

        bg2 = QButtonGroup( 2, QGroupBox.Horizontal, "Owner", tab2 )

        QLabel( "Owner", bg2 )
        owner = QLabel( self.fileinfo.owner(), bg2 )
        owner.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        QLabel( "Group", bg2 )
        group = QLabel( self.fileinfo.group(), bg2 )
        group.setFrameStyle( QFrame.Panel | QFrame.Sunken )

        self.addTab( tab2, "Permissions" )
    
    def setupTab3( self ):
        tab3 = QVBox( self )
        tab3.setMargin( 5 )
        tab3.setSpacing( 5 )
    
        QLabel( QString( "Open %1 with:" ).arg( self.filename ), tab3 )

        prgs = QListBox( tab3 )
        for i in range( 0, 30, 1 ) :
            prg = QString( "Application %1" ).arg( i )
            prgs.insertItem( prg )
        prgs.setCurrentItem( 3 )

        QCheckBox( QString( "Open files with the extension '%1' always with this application" ).arg( self.fileinfo.extension() ), tab3 )

        self.addTab( tab3, "Applications" )
    
def main( args ):
    a = QApplication(sys.argv)
    #sys.argv.append("tabdialog.py") # to test uncomment this line
    if len(sys.argv) < 2:
        filename = QString(".")
    else:
        filename = QString(sys.argv[1])
            
    tabdialog = TabDialog( None, "tabdialog", filename )
    tabdialog.resize( 450, 350 );
    tabdialog.setCaption( "Qt Example - Tabbed Dialog" )
    a.setMainWidget( tabdialog )
    tabdialog.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
