import java.util.*;

 import org.kde.qt.*;
 import org.kde.koala.*;

 /**
 *  Class to text KComboBox widgets.
 *
 *  This is a translation to java from kcomboboxtest.cpp in the tests library
 *  of kdeui source.
 *
 *    Combo boxes tested
 *      - Editable ComboBox
 *      - Select Only ComboBox
   * @see KComboBox
   * @see KApplication
   * @see KConfig
   *
   * @author original author unknown, java translation Kenneth J. Pouncey,
 kjpou@hotmail.com
   * @version 0.1
   */
 public class KComboBoxTest {

    static String description = "Java KComboBox test program.";
    static String[][] options = {   };
    static String VERSION = "0.1";

    public static void main(String[] cmdLineArgs) {

       KAboutData aboutData = new KAboutData( "kcomboboxtest", "KComboBoxTest",
          VERSION, description, KAboutData.License_GPL,
          "(c) 2002, Kenneth J. Pouncey");
       aboutData.addAuthor("Kenneth J. Pouncey",null, "kjpou@hotmail.com");
       KCmdLineArgs.init( cmdLineArgs, aboutData );
       KCmdLineArgs.addCmdLineOptions( options ); // Add our own options.

       KApplication app = new KApplication();

       // parse the args
       KCmdLineArgs args = KCmdLineArgs.parsedArgs();

       // Make a central widget to contain the other widgets
       QWidget w = new QWidget();
       // Insert the widget container (parent widget) into
       // a layout manager (VERTICAL).
       QVBoxLayout vbox = new QVBoxLayout( w, KDialog.marginHint(),
 KDialog.spacingHint() );
       // Resize the widget
       w.resize( 500, 100 );

       String[] list = {"Stone" , "Tree" , "Pebbles" , "Ocean" , "Sand" , "Chips"
 , "Computer" , "Mankind"};

       // Create and modify read-write widget
       KComboBox rwc = new KComboBox( true, w, "rwcombobox" );
       QLabel lblrw = new QLabel( rwc, "&Editable ComboBox", w, "rwcombolabel",0
 );
       rwc.setDuplicatesEnabled( true );
       rwc.completionObject().setItems( list );
       rwc.setInsertionPolicy( QComboBox.NoInsertion );
       rwc.insertStringList( list );
       rwc.setEditText( "KDE Java Bindings" );

       // Create a read-write combobox and reproduce konqueror's code
       KComboBox konqc = new KComboBox( true, w, "konqc" );
       konqc.setMaxCount( 10 );
       KSimpleConfig historyConfig = new KSimpleConfig("konq_history");
       historyConfig.setGroup( "Location Bar" );
       KCompletion s_pCompletion = new KCompletion();
       s_pCompletion.setOrder( KCompletion.Weighted );

       String[] rle = null;
 //      historyConfig.readListEntry( "ComboContents" ,rle);
       s_pCompletion.setItems( rle );
       s_pCompletion.setCompletionMode( KGlobalSettings.completionMode() );
       konqc.setCompletionObject( s_pCompletion );

       QLabel lblkonq = new QLabel( konqc, "&Konqueror's ComboBox", w );
 //      konqc.insertItem( KIconLoader.SmallIcon("www"),
 //                         "http://www.kde.org" );
       konqc.insertItem( app.iconLoader().loadIcon("www",0 ),
                          "http://www.kde.org" );
       konqc.setCurrentItem( konqc.count()-1 );

       // Create a read-only widget
       KComboBox soc = new KComboBox( w, "socombobox" );
       QLabel lblso = new QLabel( soc, "&Select-Only ComboBox", w, "socombolabel",0 );
       soc.setCompletionMode( KGlobalSettings.CompletionAuto );
       soc.completionObject().setItems( list );
       soc.insertStringList( list );

       // Create an exit button
       QPushButton push = new QPushButton( "E&xit", w );

       QObject.connect( push, Qt.SIGNAL("clicked()"), app, Qt.SLOT("closeAllWindows()" ) );

       // Insert the widgets into the layout manager.
       vbox.addWidget( lblrw );
       vbox.addWidget( rwc );
       vbox.addWidget( lblso );
       vbox.addWidget( soc );
       vbox.addWidget( lblkonq );
       vbox.addWidget( konqc );
       vbox.addWidget( push );

       app.setMainWidget(w);
       rwc.setFocus();
       w.show();

       app.exec();
       return;
    }

         static {
			qtjava.initialize();
			kdejava.initialize();
         }

 }


