#!/usr/bin/env python

# This is an example of a DCOP serving application written in Python, using
# the dcoppython KDE bindings.

# something goes wrong if you don't import pcop first.
# Have to do this till I find out why...
import pcop
import pydcop

class ParrotObject(pydcop.DCOPServerObject):
    """DCOP server object"""
    
    def __init__(self, id='parrot'):
        pydcop.DCOPServerObject.__init__(self, id)

        # DCOP needs types, so we need to initialise the object with the methods that
        # it's going to provide.
        self.setMethods( [
            ('int age()', self.get_age),
            ('void setAge(int)', self.set_age),
            ('QString squawk(QString)', self.squawk),
            ])

        # set up object variables
        self.parrot_age = 7

    def get_age(self):
        return self.parrot_age

    def set_age(self,age):
        self.parrot_age = age

    def squawk(self, what_to_squawk):
        return "This parrot, %i months old, squawks: %s" % (self.parrot_age, what_to_squawk)
        

appid = pydcop.registerAs('petshop')
print "Server: %s starting" % appid

parrot = ParrotObject()
another_parrot = ParrotObject('polly')

# Enter event loop
while 1:
    pydcop.processEvents()


