/*
 * Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	IN NO EVENT SHALL THE
 * AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef __PIXMAP_H__ 
#define __PIXMAP_H__ 

static const char * const px_close[] = {
"16 16 4 1",
"o c black",
"x c Gray50",
". c white",
"  c None",
"                ",
"  oo        oo  ",
" o.xo      ox.o ",
" ox.xo    ox.xo ",
"  ox.xo  ox.xo  ",
"   ox.xoox.xo   ",
"    ox.xx.xo    ",
"     ox..xo     ",
"     ox..xo     ",
"    ox.xx.xo    ",
"   ox.xoox.xo   ",
"  ox.xo  ox.xo  ",
" ox.xo    ox.xo ",
" o.xo      ox.o ",
"  oo        oo  ",
"                "
};

static const char * const px_playlist[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"     ooo        ",
"    o . o       ",
"   o . . o      ",
"  o . . . o     ",
"  o. . . .o     ",
"  o . . . o     ",
"   o . . o      ",
"    o . ooo     ",
"     ooo ooo    ",
"          ooo   ",
"           ooo  ",
"            o   ",
"                ",
"                "
}; 

static const char * const px_album[] = {
"16 16 4 1",
"o c black",
"x c Gray50",
". c White",
"  c None",
"                ",
"                ",
"                ",
"     oooooo     ",
"   oo......oo   ",
"  o..x....xxxo  ",
" o....xooxx...o ",
"o.....o  o.....o",
"o.....o  o.....o",
" o...xxoox....o ",
"  oxxx....x..o  ",
"   oo......oo   ",
"     oooooo     ",
"                ",
"                ",
"                "
};

static const char * const px_artist[] = {
"16 16 4 1",
"o c black",
"x c Gray50",
". c White",
"  c None",
"          oxxo  ",
"          oxxo  ",
"         oxxo   ",
"         oxxo   ",
"        oxxo    ",
"        oxxo    ",
"       oxxo     ",
"       oxxo     ",
"      oooo      ",
"     oxxoo      ",
"    o..xoo      ",
"    o.xxoo      ",
"   o.xxoo       ",
"   oxxoo        ",
"  o.xoo         ",
" oooo           "
};

static const char * const px_track[] = {
"16 16 4 1",
"o c black",
"x c Gray50",
". c white",
"  c None",
"                ",
"      oo        ",
"     ooxoo      ",
"     oo..xoo    ",
"     oox...xoo  ",
"     oooox...oo ",
"     oo  oox.oo ",
"  ooooo    oooo ",
" oo.xoo      oo ",
" oxoooo      oo ",
" ooooo    ooooo ",
"  ooo    oo.xoo ",
"         oxoooo ",
"         ooooo  ",
"          ooo   ",
"                "
};

static const char * const px_next[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"   o        o   ",
"  o.o      o o  ",
"  o .o     o.o  ",
"  o. .o    o o  ",
"  o . .o   o.o  ",
"  o. . .o  o o  ",
"  o . . o  o.o  ",
"  o. . o   o o  ",
"  o . o    o.o  ",
"  o. o     o o  ",
"  o o      o.o  ",
"   o        o   ",
"                ",
"                "
};

static const char * const px_pause[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"    oo    oo    ",
"   o. o  o. o   ",
"   o .o  o .o   ",
"   o. o  o. o   ",
"   o .o  o .o   ",
"   o. o  o. o   ",
"   o .o  o .o   ",
"   o. o  o. o   ",
"   o .o  o .o   ",
"   o. o  o. o   ",
"   o .o  o .o   ",
"    oo    oo    ",
"                ",
"                "
};

static const char * const px_play1[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"   oo           ",
"  o .oo         ",
"  o. . oo       ",
"  o . . .oo     ",
"  o. . . . oo   ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"  o . . . .oo   ",
"  o. . . oo     ",
"  o . .oo       ",
"  o. oo         ",
"   oo           ",
"                ",
"                "
};

static const char * const px_play2[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"                ",
"    oo          ",
"   o .oo        ",
"   o. . oo      ",
"   o . . .oo    ",
"   o. . . . o   ",
"   o . . . .o   ",
"   o. . . oo    ",
"   o . .oo      ",
"   o. oo        ",
"    oo          ",
"                ",
"                ",
"                "
};

static const char * const px_play3[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"                ",
"                ",
"     oo         ",
"    o .oo       ",
"    o. . oo     ",
"    o . . .o    ",
"    o. . . o    ",
"    o . .oo     ",
"    o. oo       ",
"     oo         ",
"                ",
"                ",
"                ",
"                "
};

static const char * const px_restart[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"       o    o   ",
"      o.o  o.o  ",
"     o. o o. o  ",
"    o. .oo. .o  ",
"   o. . o. . o  ",
"  o. . o. . .o  ",
"  o . .o . . o  ",
"   o . .o . .o  ",
"    o . oo . o  ",
"     o .o o .o  ",
"      o o  o o  ",
"       o    o   ",
"                ",
"                "
};

static const char * const px_previous[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"   o        o   ",
"  o o      o.o  ",
"  o.o     o. o  ",
"  o o    o. .o  ",
"  o.o   o. . o  ",
"  o o  o. . .o  ",
"  o.o  o . . o  ",
"  o o   o . .o  ",
"  o.o    o . o  ",
"  o o     o .o  ",
"  o.o      o o  ",
"   o        o   ",
"                ",
"                "
};

static const char * const px_stop[] = {
"16 16 3 1",
"o c black",
". c white",
"  c None",
"                ",
"                ",
"   oooooooooo   ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"  o . . . . .o  ",
"  o. . . . . o  ",
"   oooooooooo   ",
"                ",
"                "
};

static const char * const px_config[] = {
"16 16 3 1",
"o	c black",
".	c white",
" 	c None",
"                ",
"    ooo         ",
"    o. o        ",
"     o. o       ",
" oo  o .o       ",
" o.oo . o       ",
" o . . . o      ",
"  o . . . ooo   ",
"   ooo . . . o  ",
"      o . . . o ",
"       o . oo.o ",
"       o. o  oo ",
"       o .o     ",
"        o .o    ",
"         ooo    ",
"                "
};

static const char * const px_x[] = {
"12 12 2 1",
"o	c black",
" 	c None",
"            ",
"        o   ",
"       ooo  ",
"      ooooo ",
"     ooooo  ",
"    ooooo   ",
"   ooooo    ",
"  ooooo     ",
" o  oo      ",
" oo o       ",
" ooo        ",
"            "
};

static const char * const px_plus[] = {
"12 12 2 1",
"o	c black",
" 	c None",
"            ",
"     oo     ",
"     oo     ",
"     oo     ",
"     oo     ",
" oooooooooo ",
" oooooooooo ",
"     oo     ",
"     oo     ",
"     oo     ",
"     oo     ",
"            "
};

static const char * const px_minus[] = {
"12 12 2 1",
"o	c black",
" 	c None",
"            ",
"            ",
"            ",
"            ",
"            ",
" oooooooooo ",
" oooooooooo ",
"            ",
"            ",
"            ",
"            ",
"            "
};

static const char * const px_none[] = {
"16 16 1 1",
"  c None",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "
};

static const char * const px_squelch[] = {
"16 16 3 1",
"o	c black",
".	c white",
" 	c None",
"      oo        ",
"     o. o       ",
"    o. .o       ",
"   o. .o        ",
"  o. .o   o     ",
" o. .o   o.o    ",
"o. .o   o. .o   ",
" o. .o   o. .o  ",
"  o. .o   o. .o ",
"   o. .o   o. .o",
"    o .o  o. .o ",
"     oo  o. .o  ",
"        o. .o   ",
"       o. .o    ",
"       o .o     ",
"        oo      "
};


static const char * const px_squelch_large[] = {
"32 32 124 2",
"  	c None",
". 	c #090D11",
"+ 	c #000000",
"@ 	c #151B21",
"# 	c #9AB9DD",
"$ 	c #688BB5",
"% 	c #0D1319",
"& 	c #9DBCDE",
"* 	c #CDE4FF",
"= 	c #739CCA",
"- 	c #06080B",
"; 	c #20262B",
"> 	c #A5C1E1",
", 	c #AED3FF",
"' 	c #789FCC",
") 	c #181E23",
"! 	c #C8D9EC",
"~ 	c #C7E0FF",
"{ 	c #6D98C8",
"] 	c #10161C",
"^ 	c #A3C0E0",
"/ 	c #C7E1FF",
"( 	c #6F99C8",
"_ 	c #171D22",
": 	c #95B6DB",
"< 	c #A1CDFF",
"[ 	c #6A96C7",
"} 	c #191F24",
"| 	c #B4CBE6",
"1 	c #BBDAFF",
"2 	c #B3CBE5",
"3 	c #719AC9",
"4 	c #C4DFFF",
"5 	c #79A0CC",
"6 	c #0F151B",
"7 	c #98B8DC",
"8 	c #759DCB",
"9 	c #111821",
"0 	c #05080A",
"a 	c #0E1216",
"b 	c #A6C2E1",
"c 	c #D7E9FF",
"d 	c #9AB9DC",
"e 	c #131A23",
"f 	c #BBD3EF",
"g 	c #9AB6D5",
"h 	c #06090C",
"i 	c #111315",
"j 	c #ACC3DD",
"k 	c #C2DEFF",
"l 	c #82ABDA",
"m 	c #10171E",
"n 	c #0E141A",
"o 	c #B9CFE9",
"p 	c #B5D7FF",
"q 	c #6B94C2",
"r 	c #0D1013",
"s 	c #7DA1CA",
"t 	c #9DCAFF",
"u 	c #75A1D4",
"v 	c #192026",
"w 	c #92B5DD",
"x 	c #81A4CB",
"y 	c #9AC9FF",
"z 	c #7BA5D5",
"A 	c #8FB3DC",
"B 	c #A5CEFF",
"C 	c #6690C0",
"D 	c #111417",
"E 	c #80A4CB",
"F 	c #77A2D4",
"G 	c #7FA8D7",
"H 	c #92C4FF",
"I 	c #6590C0",
"J 	c #101316",
"K 	c #7EA2CA",
"L 	c #9FCBFF",
"M 	c #6F9DD2",
"N 	c #161D24",
"O 	c #A3C0E2",
"P 	c #070A0D",
"Q 	c #7299C5",
"R 	c #86BEFF",
"S 	c #040608",
"T 	c #5F6469",
"U 	c #A5CAF3",
"V 	c #5E85B2",
"W 	c #010202",
"X 	c #27384B",
"Y 	c #171717",
"Z 	c #90A8C4",
"` 	c #90C3FF",
" .	c #7DB1ED",
"..	c #1E2A39",
"+.	c #020203",
"@.	c #101010",
"#.	c #9EB3CC",
"$.	c #C0DDFF",
"%.	c #7FB2ED",
"&.	c #111111",
"*.	c #9FB3CC",
"=.	c #C3DFFF",
"-.	c #8DBAEF",
";.	c #262626",
">.	c #A3B7CE",
",.	c #A8D0FF",
"'.	c #81B3ED",
").	c #1E1E1E",
"!.	c #A6B9D0",
"~.	c #A7D0FF",
"{.	c #010101",
"].	c #96ACC7",
"^.	c #8BA4C1",
"/.	c #ABD1FF",
"(.	c #80B3ED",
"_.	c #070707",
":.	c #829DBD",
"<.	c #ADD3FF",
"[.	c #141414",
"}.	c #A5B9D0",
"|.	c #ABD2FF",
"1.	c #7EB1ED",
"2.	c #63788F",
"3.	c #5679A2",
"                                  . +                           ",
"                                @ # $ +                         ",
"                              % & * = -                         ",
"                            ; > , ' .                           ",
"                          ) ! ~ { .                             ",
"                        ] ^ / ( .                               ",
"                      _ : < [ .                                 ",
"                    } | 1 ( .                                   ",
"                  ] 2 * 3 .                                     ",
"                ] > 4 5 .                                       ",
"              6 7 1 8 .           9 0                           ",
"            a b c d .           e f g h                         ",
"            i j k l m           n o p q h                       ",
"              r s t u m           v w , q h                     ",
"                r x y z m           m A B C h                   ",
"                  D E t F m           m G H I h                 ",
"                    J K L M m           N O H I h               ",
"                      P Q R M S         + T U R V W             ",
"                        h I X +         Y Z `  ...+             ",
"                          +.+         @.#.$.%...+               ",
"                                    &.*.=.-...+                 ",
"                                  ;.>.,.'...+                   ",
"                                ).!.~. ...+                     ",
"                              {.].p  ...+                       ",
"                            + ^./.(...+                         ",
"                          _.:.<.'...+                           ",
"                        [.}.|.1...+                             ",
"                      + 2.|. ...+                               ",
"                        + 3...+                                 ",
"                          + +                                   ",
"                                                                ",
"                                                                "
};

#endif

