// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
using System.IO;

namespace QtCSharp {

	public class Generator {

		void Usage ()
		{
			Console.Write (
				"generator -f file.cs -d directory\n\n" +
				"   -f || --file  file.xml        The csharp source file to parse.\n\n" +
				"   -d || --directory             Specifies the output directory.\n\n");
		}

		public static void Main (string[] args)
		{
			Generator gen = new Generator (args);
		}

		public Generator (string[] args)
		{
			string xmlfile = null;
			string directory = null;

			int argc = args.Length;
			for (int i = 0; i < argc; i++) {
				string arg = args[i];
				if (arg.StartsWith("-") || arg.StartsWith("/")) {
					switch (arg) {
						case "-f": case "--file":
							if ((i + 1) >= argc) {
								Usage();
								return;
							}
							xmlfile = args[++i];
							continue;
						case "-d": case "--directory":
							if ((i + 1) >= argc) {
								Usage ();
								return;
							}
							directory = args[++i];
							continue;
						default:
							Usage ();
							return;
					}
				}
			}
			
			if (xmlfile == null) {
				Usage();
				return;
			} else if (directory == null) {
				Usage ();
				return;
			}
			
			if (!File.Exists (xmlfile)) {
				Console.WriteLine ("\n   No Xml file at {0}\n", args[0]);
				return;
			}
			//if (!Directory.Exists( directory) && directory != null) {

                	//Directory.CreateDirectory (directory);
            		//}

			ParseAPI parseapi = new ParseAPI (xmlfile);
			QTypeMap qmap = new QTypeMap ();
			Console.WriteLine ("Parsing "+parseapi.QTypes.Count+" Qt classes...");

			foreach (QType qtype in parseapi.QTypes) {
				Converter converter = new Converter (parseapi.QTypes, qtype, qmap);
				Printer printer = new Printer (converter.GetQType (), directory);
			}
		}
	}
}
