# Copyright (C) 2001-2002 Trolltech AS.  All rights reserved.
# Copyright (C) 2004 Riverbank Computing Ltd.  All rights reserved.
#
# This file is part of an example program for the ActiveQt integration.
# This example program may be used, distributed and modified without 
# limitation.


import sys
import qt
import qtaxcontainer

import mainwindow


class MainWindowImpl(mainwindow.MainWindow):
    def init(self):
        self.pb = qt.QProgressBar(self.statusBar())
        self.pb.setPercentageVisible(False)
        self.pb.hide()
        self.statusBar().addWidget(self.pb, 0, True)

        self.connect(self.WebBrowser, qt.SIGNAL("ProgressChange(int,int)"), self.setProgress)
        self.connect(self.WebBrowser, qt.SIGNAL("StatusTextChange(const QString&)"), self.statusBar(), qt.SLOT("message(const QString&)"))

        self.WebBrowser.dynamicCall("GoHome()");

        self.subwindows = []

    def go(self):
        self.actionStop.setEnabled(True)
        self.WebBrowser.dynamicCall("Navigate(const QString&)", qt.QVariant(self.addressEdit.text()))

    def setTitle(self, title):
        self.setCaption("Qt WebBrowser - " + title.latin1())

    def setProgress(self, a, b):
        if a <= 0 or b <= 0:
            self.pb.hide()
            return

        self.pb.show()
        self.pb.setTotalSteps(b)
        self.pb.setProgress(a)

    def setCommandState(self, cmd, on):
        if cmd == 1:
            self.actionForward.setEnabled(on)
        elif cmd == 2:
            self.actionBack.setEnabled(on)

    def navigateBegin(self):
        self.actionStop.setEnabled(True)

    def navigateComplete(self):
        self.actionStop.setEnabled(False)

    def newWindow(self):
        window = MainWindowImpl()
        window.show()

        if self.addressEdit.text().isEmpty():
            return

        window.addressEdit.setText(self.addressEdit.text())
        window.actionStop.setEnabled(True)
        window.go()

        self.subwindows += window

    def aboutSlot(self):
        qt.QMessageBox.about(self, self.tr("About WebBrowser"), self.tr(
"""This Example has been created using the ActiveQt integration into Qt Designer.
It demonstrates the use of QAxWidget to embed the Internet Explorer ActiveX
control into a Qt application."""))

    def aboutQtSlot(self):
        qt.QMessageBox.aboutQt(self, self.tr("About Qt"))


def main(args):
    a = qt.QApplication(args)
    w = MainWindowImpl()
    a.setMainWidget(w)
    w.show()

    return a.exec_loop()


if __name__ == "__main__":
    sys.exit(main(sys.argv))
