


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvaspixmap_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasPixmapImp::QCanvasPixmapImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasPixmapImp::~QCanvasPixmapImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasPixmapImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPixmapImp *meth = new QCanvasPixmapImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasPixmapImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_offsetX_5, "offsetX" },
        { Method_offsetY_6, "offsetY" },
        { Method_setOffset_7, "setOffset" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPixmapImp *meth = new QCanvasPixmapImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasPixmap pointer from an Object.
 */
QCanvasPixmap *QCanvasPixmapImp::toQCanvasPixmap( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasPixmap *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasPixmap" )
        return 0;

    return op->toNative<QCanvasPixmap>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasPixmapImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPixmap_1:
             return QCanvasPixmap_1( exec, args );
             break;

         case Constructor_QCanvasPixmap_2:
             return QCanvasPixmap_2( exec, args );
             break;

         case Constructor_QCanvasPixmap_3:
             return QCanvasPixmap_3( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasPixmapCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object QCanvasPixmapImp::QCanvasPixmap_1( KJS::ExecState *exec, const KJS::List &args )
{

    QString arg0 = extractQString(exec, args, 0);


    // We should now create an instance of the QCanvasPixmap object

    QCanvasPixmap *ret = new QCanvasPixmap(

          arg0 );

	return KJS::Object();
}

KJS::Object QCanvasPixmapImp::QCanvasPixmap_2( KJS::ExecState *exec, const KJS::List &args )
{

    QImage arg0 = extractQImage(exec, args, 0);


    // We should now create an instance of the QCanvasPixmap object

    QCanvasPixmap *ret = new QCanvasPixmap(

          arg0 );

	return KJS::Object();

}

KJS::Object QCanvasPixmapImp::QCanvasPixmap_3( KJS::ExecState *exec, const KJS::List &args )
{

    QPixmap arg0 = extractQPixmap(exec, args, 0);

    QPoint arg1 = extractQPoint(exec, args, 1);


    // We should now create an instance of the QCanvasPixmap object

    QCanvasPixmap *ret = new QCanvasPixmap(

          arg0,
          arg1 );

	return KJS::Object();

}

KJS::Value QCanvasPixmapImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasPixmapImp::toQCanvasPixmap( self );

    switch( id ) {

    case Method_offsetX_5:
        return offsetX_5( exec, self, args );
        break;

    case Method_offsetY_6:
        return offsetY_6( exec, self, args );
        break;

    case Method_setOffset_7:
        return setOffset_7( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasPixmapImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasPixmapImp::offsetX_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->offsetX(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasPixmapImp::offsetY_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->offsetY(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasPixmapImp::setOffset_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setOffset(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


