//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import java.util.ArrayList;
import org.kde.qt.QKeyEvent;
import org.kde.qt.QWidget;

/**

 Provides a user (and developer) friendly way to
 select files and directories.
 The widget can be used as a drop in replacement for the
 QFileDialog widget, but has greater functionality and a nicer GUI.
 You will usually want to use one of the static methods
 getOpenFileName(), getSaveFileName(), getOpenURL()
 or for multiple files getOpenFileNames() or getOpenURLs().
 The dialog has been designed to allow applications to customise it
 by subclassing. It uses geometry management to ensure that subclasses
 can easily add children that will be incorporated into the layout.
 \image html kfiledialog.png "KDE File Dialog"
 See {@link KFileDialogSignals} for signals emitted by KFileDialog
		@author Richard J. Moore <rich@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
		@short A file selection dialog.

*/
public class KFileDialog extends KDialogBase  {
	protected KFileDialog(Class dummy){super((Class) null);}
	/**	
		 Defines some default behavior of the filedialog.
		 E.g. in mode <code>Opening</code> and <code>Saving</code>, the selected files/urls will
		 be added to the "recent documents" list. The Saving mode also implies
		 setKeepLocation() being set.
			 <code>Other</code> means that no default actions are performed.
				@short    Defines some default behavior of the filedialog.
		@see #setOperationMode
		@see #operationMode
	*/
	public static final int Other = 0;
	public static final int Opening = 1;
	public static final int Saving = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a file dialog.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter A shell glob or a mime-type-filter that specifies
		               which files to display.
			@param parent The parent widget of this dialog
			@param name The name of this object
			@param modal Whether to create a modal dialog or not
		 See setFilter() for details on how to use this argument.
			      		@short    Constructs a file dialog.
	*/
	public KFileDialog(String startDir, String filter, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKFileDialog(startDir,filter,parent,name,modal);
	}
	private native void newKFileDialog(String startDir, String filter, QWidget parent, String name, boolean modal);
	/**	
		 Constructs a file dialog.
			 The parameters here are identical to the first constructor except
		 for the addition of a QWidget parameter.
			 Historical note: The original version of KFileDialog did not have this extra
		 parameter. It was added later, and, in order to maintain binary compatibility,
		 it was placed in a new constructor instead of added to the original one.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
			             directory, or the last directory where a file has been
			             selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter A shell glob or a mime-type-filter that specifies
		               which files to display.
		 See setFilter() for details on how to use this argument.
			@param widget A widget, or a widget of widgets, for displaying custom
		               data in the dialog. This can be used, for example, to
		               display a check box with the caption "Open as read-only".
		               When creating this widget, you don't need to specify a parent,
		               since the widget's parent will be set automatically by KFileDialog.
			@param parent The parent widget of this dialog
			@param name The name of this object
			@param modal Whether to create a modal dialog or not
				@short    Constructs a file dialog.
	*/
	public KFileDialog(String startDir, String filter, QWidget parent, String name, boolean modal, QWidget widget) {
		super((Class) null);
		newKFileDialog(startDir,filter,parent,name,modal,widget);
	}
	private native void newKFileDialog(String startDir, String filter, QWidget parent, String name, boolean modal, QWidget widget);
	/**	
				@return The selected fully qualified filename.
     
		@short
	*/
	public native KURL selectedURL();
	/**	
				@return The list of selected URLs.
     
		@short
	*/
	public native ArrayList selectedURLs();
	/**	
				@return the currently shown directory.
     
		@short
	*/
	public native KURL baseURL();
	/**	
		 Returns the full path of the selected file in the local filesystem.
		 (Local files only)
		     		@short    Returns the full path of the selected file in the local filesystem.
	*/
	public native String selectedFile();
	/**	
		 Returns a list of all selected local files.
		     		@short    Returns a list of all selected local files.
	*/
	public native ArrayList selectedFiles();
	/**	
		 Sets the directory to view.
			@param url URL to show.
			@param clearforward Indicates whether the forward queue
		 should be cleared.
		     		@short    Sets the directory to view.
	*/
	public native void setURL(KURL url, boolean clearforward);
	public native void setURL(KURL url);
	/**	
		 Sets the file name to preselect to <code>name</code>
			 This takes absolute URLs and relative file names.
		     		@short    Sets the file name to preselect to <code>name</code>
	*/
	public native void setSelection(String name);
	/**	
		 Sets the operational mode of the filedialog to <code>Saving</code>, <code>Opening</code>
		 or <code>Other.</code> This will set some flags that are specific to loading
		 or saving files. E.g. setKeepLocation() makes mostly sense for
		 a save-as dialog. So setOperationMode( KFileDialog.Saving ); sets
		 setKeepLocation for example.
			 The mode <code>Saving</code>, together with a default filter set via
		 setMimeFilter() will make the filter combobox read-only.
			 The default mode is <code>Opening.</code>
			 Call this method right after instantiating KFileDialog.
				@short    Sets the operational mode of the filedialog to <code>Saving</code>, <code>Opening</code>  or <code>Other.</code>
		@see #operationMode
		@see KFileDialog#OperationMode
	*/
	public native void setOperationMode(int arg1);
	/**	
				@return the current operation mode, Opening, Saving or Other. Default
 is Other.

		@short   
		@see #operationMode
		@see KFileDialog#OperationMode
	*/
	public native int operationMode();
	/**	
		 Sets whether the filename/url should be kept when changing directories.
		 This is for example useful when having a predefined filename where
		 the full path for that file is searched.
			 This is implicitly set when operationMode() is KFileDialog.Saving
			 getSaveFileName() and getSaveURL() set this to true by default, so that
		 you can type in the filename and change the directory without having
		 to type the name again.
		     		@short    Sets whether the filename/url should be kept when changing directories.
	*/
	public native void setKeepLocation(boolean keep);
	/**	
				@return whether the contents of the location edit are kept when
 changing directories.
     
		@short
	*/
	public native boolean keepsLocation();
	/**	
		 Sets the filter to be used to <code>filter.</code>
			 You can set more
		 filters for the user to select separated by '\n'. Every
		 filter entry is defined through namefilter|text to diplay.
		 If no | is found in the expression, just the namefilter is
		 shown. Examples:
			 <pre>
		 kfile.setFilter("*.cpp|C++ Source Files\n.h|Header files");
		 kfile.setFilter("*.cpp");
		 kfile.setFilter("*.cpp|Sources (.cpp)");
		 kfile.setFilter("*.cpp|" + i18n("Sources (.cpp)"));
		 kfile.setFilter("*.cpp .cc .C|C++ Source Files\n.h .H|Header files");
		 </pre>
			 Note: The text to display is not parsed in any way. So, if you
		 want to show the suffix to select by a specific filter, you must
		 repeat it.
			 If the filter contains an unescaped '/', a mimetype-filter is assumed.
		 If you would like a '/' visible in your filter it can be escaped with
		 a '\'. You can specify multiple mimetypes like this (separated with
		 space):
			 <pre>
		 kfile.setFilter( "image/png text/html text/plain" );
		 kfile.setFilter( "*.cue|CUE\\/BIN Files (.cue)" );
		 </pre>
				@short    Sets the filter to be used to <code>filter.</code>
		@see #filterChanged
		@see #setMimeFilter
	*/
	public native void setFilter(String filter);
	/**	
		 Returns the current filter as entered by the user or one of the
		 predefined set via setFilter().
				@short    Returns the current filter as entered by the user or one of the  predefined set via setFilter().
		@see #setFilter
		@see #filterChanged
	*/
	public native String currentFilter();
	/**	
		 Returns the mimetype for the desired output format.
			 This is only valid if setFilterMimeType() has been called
		 previously.
				@short    Returns the mimetype for the desired output format.
		@see #setFilterMimeType
	*/
	// KMimeType::Ptr currentFilterMimeType(); >>>> NOT CONVERTED
	/**	
		 Sets the filter up to specify the output type.
			@param types a list of mimetypes that can be used as output format
			@param defaultType the default mimetype to use as output format, if any.
		 If <code>defaultType</code> is set, it will be set as the current item.
		 Otherwise, a first item showing all the mimetypes will be created.
		 Typically, <code>defaultType</code> should be empty for loading and set for saving.
			 Do not use in conjunction with setFilter()
		     		@short    Sets the filter up to specify the output type.
	*/
	public native void setMimeFilter(String[] types, String defaultType);
	public native void setMimeFilter(String[] types);
	/**	
		 The mimetype for the desired output format.
			 This is only valid if setMimeFilter() has been called
		 previously.
				@short    The mimetype for the desired output format.
		@see #setMimeFilter
	*/
	public native String currentMimeFilter();
	/**	
		  Clears any mime- or namefilter. Does not reload the directory.
		     		@short     Clears any mime- or namefilter.
	*/
	public native void clearFilter();
	/**	
		 Adds a preview widget and enters the preview mode.
			 In this mode the dialog is split and the right part contains your
		 preview widget.
			 Ownership is transferred to KFileDialog. You need to create the
		 preview-widget with "new", i.e. on the heap.
			@param w The widget to be used for the preview.
		     		@short    Adds a preview widget and enters the preview mode.
	*/
	public native void setPreviewWidget(KPreviewWidgetBase w);
	public native void show();
	/**	
		 Convenient overload of the other setMode(unsigned int) method.
		     		@short    Convenient overload of the other setMode(unsigned int) method.
	*/
	public native void setMode(int m);
	/**	
		 Returns the mode of the filedialog.
				@short    Returns the mode of the filedialog.
		@see #setMode
	*/
	public native int mode();
	/**	
		 Sets the text to be displayed in front of the selection.
			 The default is "Location".
		 Most useful if you want to make clear what
		 the location is used for.
		     		@short    Sets the text to be displayed in front of the selection.
	*/
	public native void setLocationLabel(String text);
	/**	
		 Returns a pointer to the toolbar.
			 You can use this to insert custom
		 items into it, e.g.:
		 <pre>
		      yourAction = new KAction( i18n("Your Action"), 0,
		                                this, SLOT("yourSlot()"),
		                                this, "action name" );
		      yourAction.plug( kfileDialog.toolBar() );
		 </pre>
		     		@short    Returns a pointer to the toolbar.
	*/
	public native KToolBar toolBar();
	/**	
				@return a pointer to the OK-Button in the filedialog. You may use it
 e.g. to set a custom text to it.
     
		@short
	*/
	public native KPushButton okButton();
	/**	
				@return a pointer to the Cancel-Button in the filedialog. You may use
 it e.g. to set a custom text to it.
     
		@short
	*/
	public native KPushButton cancelButton();
	/**	
			 Note that this method may return a null-pointer if the user configured
		 to not use the speed-bar.
				@return the KURLBar object used as the "speed bar". You can add custom
 entries to it like that:
 <pre>
 KURLBar *urlBar = fileDialog.speedBar();
 if ( urlBar )
     urlBar.insertDynamicItem( someURL, i18n("The URL's description") );
 </pre>

		@short   
		@see KURLBar
		@see KURLBar#insertDynamicItem
	*/
	public native KURLBar speedBar();
	/**	
				@return a pointer to the action collection, holding all the used
 KActions.
     
		@short
	*/
	public native KActionCollection actionCollection();
	/**	
				@return the index of the path combobox so when inserting widgets into
 the dialog (e.g. subclasses) they can do so without hardcoding in an index
     
		@short
	*/
	public native int pathComboIndex();
	/**	
		 Creates a modal file dialog and return the selected
		 filename or an empty string if none was chosen.
			 Note that with
		 this method the user must select an existing filename.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and return the selected  filename or an empty string if none was chosen.
	*/
	public static native String getOpenFileName(String startDir, String filter, QWidget parent, String caption);
	public static native String getOpenFileName(String startDir, String filter, QWidget parent);
	public static native String getOpenFileName(String startDir, String filter);
	public static native String getOpenFileName(String startDir);
	public static native String getOpenFileName();
	/**	
		 Use this version only if you have no QWidget available as
		 parent widget. This can be the case if the parent widget is
		 a widget in another process or if the parent widget is a
		 non-Qt widget. For example, in a GTK program.
				@short    Use this version only if you have no QWidget available as  parent widget.
	*/
	public static native String getOpenFileNameWId(String startDir, String filter, long parent_id, String caption);
	/**	
		 Creates a modal file dialog and returns the selected
		 filenames or an empty list if none was chosen.
			 Note that with
		 this method the user must select an existing filename.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  filenames or an empty list if none was chosen.
	*/
	public static native ArrayList getOpenFileNames(String startDir, String filter, QWidget parent, String caption);
	public static native ArrayList getOpenFileNames(String startDir, String filter, QWidget parent);
	public static native ArrayList getOpenFileNames(String startDir, String filter);
	public static native ArrayList getOpenFileNames(String startDir);
	public static native ArrayList getOpenFileNames();
	/**	
		 Creates a modal file dialog and returns the selected
		 URL or an empty string if none was chosen.
			 Note that with
		 this method the user must select an existing URL.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  URL or an empty string if none was chosen.
	*/
	public static native KURL getOpenURL(String startDir, String filter, QWidget parent, String caption);
	public static native KURL getOpenURL(String startDir, String filter, QWidget parent);
	public static native KURL getOpenURL(String startDir, String filter);
	public static native KURL getOpenURL(String startDir);
	public static native KURL getOpenURL();
	/**	
		 Creates a modal file dialog and returns the selected
		 URLs or an empty list if none was chosen.
			 Note that with
		 this method the user must select an existing filename.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  URLs or an empty list if none was chosen.
	*/
	public static native ArrayList getOpenURLs(String startDir, String filter, QWidget parent, String caption);
	public static native ArrayList getOpenURLs(String startDir, String filter, QWidget parent);
	public static native ArrayList getOpenURLs(String startDir, String filter);
	public static native ArrayList getOpenURLs(String startDir);
	public static native ArrayList getOpenURLs();
	/**	
		 Creates a modal file dialog and returns the selected
		 filename or an empty string if none was chosen.
			 Note that with this
		 method the user need not select an existing filename.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			a relative path or a filename determining the
			             directory to start in and the file to be selected.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  filename or an empty string if none was chosen.
	*/
	public static native String getSaveFileName(String startDir, String filter, QWidget parent, String caption);
	public static native String getSaveFileName(String startDir, String filter, QWidget parent);
	public static native String getSaveFileName(String startDir, String filter);
	public static native String getSaveFileName(String startDir);
	public static native String getSaveFileName();
	/**	
		 This function accepts the window id of the parent window, instead
		 of QWidget. It should be used only when necessary.
				@short    This function accepts the window id of the parent window, instead  of QWidget .
	*/
	public static native String getSaveFileNameWId(String dir, String filter, long parent_id, String caption);
	/**	
		 Creates a modal file dialog and returns the selected
		 filename or an empty string if none was chosen.
			 Note that with this
		 method the user need not select an existing filename.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			a relative path or a filename determining the
			             directory to start in and the file to be selected.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param filter This is a space separated list of shell globs.
		 You can set the text to be displayed for the glob, and
		 provide multiple globs.  See setFilter() for details on
		 how to do this...
			@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  filename or an empty string if none was chosen.
	*/
	public static native KURL getSaveURL(String startDir, String filter, QWidget parent, String caption);
	public static native KURL getSaveURL(String startDir, String filter, QWidget parent);
	public static native KURL getSaveURL(String startDir, String filter);
	public static native KURL getSaveURL(String startDir);
	public static native KURL getSaveURL();
	/**	
		 Creates a modal file dialog and returns the selected
		 directory or an empty string if none was chosen.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog and returns the selected  directory or an empty string if none was chosen.
	*/
	public static native String getExistingDirectory(String startDir, QWidget parent, String caption);
	public static native String getExistingDirectory(String startDir, QWidget parent);
	public static native String getExistingDirectory(String startDir);
	public static native String getExistingDirectory();
	/**	
		 Creates a modal file dialog and returns the selected
		 directory or an empty string if none was chosen.
			 Contrary to getExistingDirectory(), this method allows the
		 selection of a remote directory.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
				@short    Creates a modal file dialog and returns the selected  directory or an empty string if none was chosen.
	*/
	public static native KURL getExistingURL(String startDir, QWidget parent, String caption);
	public static native KURL getExistingURL(String startDir, QWidget parent);
	public static native KURL getExistingURL(String startDir);
	public static native KURL getExistingURL();
	/**	
		 Creates a modal file dialog with an image previewer and returns the
		 selected url or an empty string if none was chosen.
			@param startDir This can either be
		
			<li>
			The URL of the directory to start in.
			</li>
			
			<li>
			null to start in the current working
					    directory, or the last directory where a file has been
					    selected.
			</li>
			
			<li>
			':&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in the same application that specified
			             the same keyword.
			</li>
			
			<li>
			'.&lt;keyword&gt;' to start in the directory last used
			             by a filedialog in any application that specified the
			             same keyword.
			</li>
				@param parent The widget the dialog will be centered on initially.
			@param caption The name of the dialog widget.
		     		@short    Creates a modal file dialog with an image previewer and returns the  selected url or an empty string if none was chosen.
	*/
	public static native KURL getImageOpenURL(String startDir, QWidget parent, String caption);
	public static native KURL getImageOpenURL(String startDir, QWidget parent);
	public static native KURL getImageOpenURL(String startDir);
	public static native KURL getImageOpenURL();
	/**	
		 This method implements the logic to determine the user's default directory
		 to be listed. E.g. the documents direcory, home directory or a recently
		 used directory.
			@param startDir A url/directory, to be used. May use the ':' and '.' syntax
		        as documented in the KFileDialog() constructor.
			@param recentDirClass If the ':' or '.' syntax is used, recentDirClass
		        will contain the string to be used later for KRecentDir.dir()
				@return The URL that should be listed by default (e.g. by KFileDialog or
         KDirSelectDialog).

		@short    This method implements the logic to determine the user's default directory  to be listed.
	*/
	public static native KURL getStartURL(String startDir, StringBuffer recentDirClass);
	/**	
			 Used by KDirSelectDialog to share the dialog's start directory.
		     		@short
	*/
	public static native void setStartDir(KURL directory);
	/**	
		 Reimplemented to animate the cancel button.
		     		@short    Reimplemented to animate the cancel button.
	*/
	protected native void keyPressEvent(QKeyEvent e);
	/**	
		 Perform basic initialization tasks. Called by constructors.
				@short    Perform basic initialization tasks.
	*/
	protected native void init(String startDir, String filter, QWidget widget);
	/**	
		 rebuild geometry management.
			      		@short    rebuild geometry management.
	*/
	protected native void initGUI();
	/**	
		 called when an item is highlighted/selected in multiselection mode.
		 handles setting the locationEdit.
		     		@short    called when an item is highlighted/selected in multiselection mode.
	*/
	protected native void multiSelectionChanged();
	/**	
		 Reads configuration and applies it (size, recent directories, ...)
		     		@short    Reads configuration and applies it (size, recent directories, .
	*/
	protected native void readConfig(KConfig arg1, String group);
	protected native void readConfig(KConfig arg1);
	/**	
		 Saves the current configuration
		     		@short    Saves the current configuration
	*/
	protected native void writeConfig(KConfig arg1, String group);
	protected native void writeConfig(KConfig arg1);
	/**	
		 Reads the recent used files and inserts them into the location combobox
		     		@short    Reads the recent used files and inserts them into the location combobox
	*/
	protected native void readRecentFiles(KConfig arg1);
	/**	
		 Saves the entries from the location combobox.
		     		@short    Saves the entries from the location combobox.
	*/
	protected native void saveRecentFiles(KConfig arg1);
	/**	
		 Parses the string "line" for files. If line doesn't contain any ", the
		 whole line will be interpreted as one file. If the number of " is odd,
		 an empty list will be returned. Otherwise, all items enclosed in " "
		 will be returned as correct urls.
		     		@short    Parses the string "line" for files.
	*/
	protected native ArrayList tokenize(String line);
	/**	
		 Returns the absolute version of the URL specified in locationEdit.
				@short    Returns the absolute version of the URL specified in locationEdit.
	*/
	protected native KURL getCompleteURL(String arg1);
	/**	
		 Returns the filename extension associated with the currentFilter().
		 null is returned if an extension is not available or if
		 operationMode() != Saving.
				@short    Returns the filename extension associated with the currentFilter().
	*/
	protected native String currentFilterExtension();
	/**	
		 Updates the currentFilterExtension and the availability of the
		 Automatically Select Extension Checkbox (visible if operationMode()
		 == Saving and enabled if an extension _will_ be associated with the
		 currentFilter(), _after_ this call).  You should call this after
		 filterWidget.setCurrentItem().
				@short    Updates the currentFilterExtension and the availability of the  Automatically Select Extension Checkbox (visible if operationMode()  == Saving and enabled if an extension _will_ be associated with the  currentFilter(), _after_ this call).
	*/
	protected native void updateAutoSelectExtension();
	protected native ArrayList parseSelectedURLs();
	protected native void urlEntered(KURL arg1);
	protected native void enterURL(KURL url);
	protected native void enterURL(String url);
	protected native void locationActivated(String url);
	protected native void slotFilterChanged();
	protected native void fileHighlighted(KFileItem i);
	protected native void fileSelected(KFileItem i);
	protected native void slotStatResult(Job job);
	protected native void slotLoadingFinished();
	protected native void fileCompletion(String arg1);
	/**	
				@short
	*/
	protected native void toggleSpeedbar(boolean arg1);
	/**	
				@short
	*/
	protected native void toggleBookmarks(boolean show);
	protected native void slotOk();
	protected native void accept();
	protected native void slotCancel();
	protected native void slotAutoSelectExtClicked();
	protected native void addToRecentDocuments();
	protected native void initSpeedbar();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
