//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QIconSet;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 The KAction class (and derived and super classes) provides a way to
 easily encapsulate a "real" user-selected action or event in your
 program.
 For instance, a user may want to <code>paste</code> the contents of
 the clipboard or <code>scroll</code> <code>down</code> a document or <code>quit</code> the
 application.  These are all <code>actions</code> -- events that the
 user causes to happen.  The KAction class allows the developer to
 deal with these actions in an easy and intuitive manner.
 Specifically, the KAction class encapsulated the various attributes
 to an event/action.  For instance, an action might have an icon
 that goes along with it (a clipboard for a "paste" action or
 scissors for a "cut" action).  The action might have some text to
 describe the action.  It will certainly have a method or function
 that actually <code>executes</code> the action!  All these attributes
 are contained within the KAction object.
 The advantage of dealing with Actions is that you can manipulate
 the Action without regard to the GUI representation of it.  For
 instance, in the "normal" way of dealing with actions like "cut",
 you would manually insert a item for Cut into a menu and a button
 into a toolbar.  If you want to disable the cut action for a moment
 (maybe nothing is selected), you would have to hunt down the pointer
 to the menu item and the toolbar button and disable both
 individually.  Setting the menu item and toolbar item up uses very
 similar code - but has to be done twice!
 With the Action concept, you simply "plug" the Action into whatever
 GUI element you want.  The KAction class will then take care of
 correctly defining the menu item (with icons, accelerators, text,
 etc) or toolbar button.. or whatever.  From then on, if you
 manipulate the Action at all, the effect will propogate through all
 GUI representations of it.  Back to the "cut" example: if you want
 to disable the Cut Action, you would simply do
 'cutAction.setEnabled(false)' and the menuitem and button would
 instantly be disabled!
 This is the biggest advantage to the Action concept -- there is a
 one-to-one relationship between the "real" action and <code>all</code>
 GUI representations of it.
 KAction emits the activated() signal if the user activated the
 corresponding GUI element ( menu item, toolbar button, etc. )
 If you are in the situation of wanting to map the activated()
 signal of multiple action objects to one slot, with a special
 argument bound to each action, then you might consider using
 QSignalMapper . A tiny example:
 <pre>
 QSignalMapper desktopNumberMapper = new QSignalMapper( this );
 connect( desktopNumberMapper, SIGNAL("mapped( int )"),
          this, SLOT("moveWindowToDesktop( int )") );
 for ( uint i = 0; i < numberOfDesktops; ++i ) {
     KAction desktopAction = new KAction( i18n( "Move Window to Desktop %i" ).arg( i ), ... );
     connect( desktopAction, SIGNAL("activated()"), desktopNumberMapper, SLOT("map()") );
     desktopNumberMapper.setMapping( desktopAction, i );
 }
 </pre>
 <li><b>General Usage:</b></li>
 The steps to using actions are roughly as follows

	<li>
	Decide which attributes you want to associate with a given
	     action (icons, text, keyboard shortcut, etc)
	</li>
	
	<li>
	Create the action using KAction (or derived or super class).
	</li>
	
	<li>
	"Plug" the Action into whatever GUI element you want.  Typically,
	      this will be a menu or toolbar.
	</li>
	 <li><b>Detailed Example:</b></li>
 Here is an example of enabling a "New [document]" action
 <pre>
 KAction newAct = new KAction(i18n("&New"), "filenew",
                               KStdAccel.shortcut(KStdAccel.New),
                               this, SLOT("fileNew()"),
                               actionCollection(), "new");
 </pre>
 This line creates our action.  It says that wherever this action is
 displayed, it will use "&New" as the text, the standard icon, and
 the standard shortcut.  It further says that whenever this action
 is invoked, it will use the fileNew() slot to execute it.
 <pre>
 QPopupMenu file = new QPopupMenu;
 newAct.plug(file);
 </pre>
 That just inserted the action into the File menu.  The point is, it's not
 important in which menu it is: all manipulation of the item is
 done through the newAct object.
 <pre>
 newAct.plug(toolBar());
 </pre>
 And this inserted the Action into the main toolbar as a button.
 That's it!
 If you want to disable that action sometime later, you can do so
 with
 <pre>
 newAct.setEnabled(false)
 </pre>
 and both the menuitem in File and the toolbar button will instantly
 be disabled.
 Do not delete a KAction object without unplugging it from all its
 containers. The simplest way to do that is to use the unplugAll()
 as in the following example:
 <pre>
 newAct.unplugAll();
 delete newAct;
 </pre>
 Normally you will not need to do this as KActionCollection manages
 everything for you.
 Note: if you are using a "standard" action like "new", "paste",
 "quit", or any other action described in the KDE UI Standards,
 please use the methods in the KStdAction class rather than
 defining your own.
 <li><b>Usage Within the XML Framework:</b></li>
 If you are using KAction within the context of the XML menu and
 toolbar building framework, then there are a few tiny changes.  The
 first is that you must insert your new action into an action
 collection.  The action collection (a KActionCollection) is,
 logically enough, a central collection of all of the actions
 defined in your application.  The XML UI framework code in KXMLGUI
 classes needs access to this collection in order to build up the
 GUI (it's how the builder code knows which actions are valid and
 which aren't).
 Also, if you use the XML builder framework, then you do not ever
 have to plug your actions into containers manually.  The framework
 does that for you.
 See {@link KActionSignals} for signals emitted by KAction
		@short Class to encapsulate user-driven action or event.
		@see KStdAction

*/
public class KAction extends QObject  {
	protected KAction(Class dummy){super((Class) null);}
	/**	
				@short
	*/
	public static final int UnknownActivation = 0;
	public static final int EmulatedActivation = 1;
	public static final int AccelActivation = 2;
	public static final int PopupMenuActivation = 3;
	public static final int ToolBarActivation = 4;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs an action with text, potential keyboard
		 shortcut, and a SLOT to call when this action is invoked by
		 the user.
			 If you do not want or have a keyboard shortcut,
		 set the <code>cut</code> param to 0.
			 This is the most common KAction used when you do not have a
		 corresponding icon (note that it won't appear in the current version
		 of the "Edit ToolBar" dialog, because an action needs an icon to be
		 plugged in a toolbar...).
			@param text The text that will be displayed.
			@param cut The corresponding keyboard shortcut.
			@param receiver The SLOT's parent.
			@param slot The SLOT to invoke to execute this action.
			@param parent This action's parent.
			@param name An internal name for this action.
		     		@short    Constructs an action with text, potential keyboard  shortcut, and a SLOT to call when this action is invoked by  the user.
	*/
	public KAction(String text, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name) {
		super((Class) null);
		newKAction(text,cut,receiver,slot,parent,name);
	}
	private native void newKAction(String text, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name);
	/**	
		 Constructs an action with text, icon, potential keyboard
		 shortcut, and a SLOT to call when this action is invoked by
		 the user.
			 If you do not want or have a keyboard shortcut, set the
		 <code>cut</code> param to 0.
			 This is the other common KAction used.  Use it when you
		 <code>do</code> have a corresponding icon.
			@param text The text that will be displayed.
			@param pix The icon to display.
			@param cut The corresponding keyboard shortcut.
			@param receiver The SLOT's parent.
			@param slot The SLOT to invoke to execute this action.
			@param parent This action's parent.
			@param name An internal name for this action.
		     		@short    Constructs an action with text, icon, potential keyboard  shortcut, and a SLOT to call when this action is invoked by  the user.
	*/
	public KAction(String text, QIconSet pix, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name) {
		super((Class) null);
		newKAction(text,pix,cut,receiver,slot,parent,name);
	}
	private native void newKAction(String text, QIconSet pix, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name);
	/**	
		 Constructs an action with text, icon, potential keyboard
		 shortcut, and a SLOT to call when this action is invoked by
		 the user.  The icon is loaded on demand later based on where it
		 is plugged in.
			 If you do not want or have a keyboard shortcut, set the
		 <code>cut</code> param to 0.
			 This is the other common KAction used.  Use it when you
		 <code>do</code> have a corresponding icon.
			@param text The text that will be displayed.
			@param pix The icon to display.
			@param cut The corresponding keyboard shortcut (shortcut).
			@param receiver The SLOT's parent.
			@param slot The SLOT to invoke to execute this action.
			@param parent This action's parent.
			@param name An internal name for this action.
		     		@short    Constructs an action with text, icon, potential keyboard  shortcut, and a SLOT to call when this action is invoked by  the user.
	*/
	public KAction(String text, String pix, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name) {
		super((Class) null);
		newKAction(text,pix,cut,receiver,slot,parent,name);
	}
	private native void newKAction(String text, String pix, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name);
	/**	
		 The same as the above constructor, but with a KGuiItem providing
		 the text and icon.
			@param item The KGuiItem with the label and (optional) icon.
			@param cut The corresponding keyboard shortcut (shortcut).
			@param receiver The SLOT's parent.
			@param slot The SLOT to invoke to execute this action.
			@param parent This action's parent.
			@param name An internal name for this action.
		     		@short    The same as the above constructor, but with a KGuiItem providing  the text and icon.
	*/
	public KAction(KGuiItem item, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name) {
		super((Class) null);
		newKAction(item,cut,receiver,slot,parent,name);
	}
	private native void newKAction(KGuiItem item, KShortcut cut, QObject receiver, String slot, KActionCollection parent, String name);
	/**	
		 "Plug" or insert this action into a given widget.
			 This will
		 typically be a menu or a toolbar.  From this point on, you will
		 never need to directly manipulate the item in the menu or
		 toolbar.  You do all enabling/disabling/manipulation directly
		 with your KAction object.
			@param widget The GUI element to display this action
			@param index The position into which the action is plugged. If
		 this is negative, the action is inserted at the end.
		     		@short    "Plug" or insert this action into a given widget.
	*/
	public native int plug(QWidget widget, int index);
	public native int plug(QWidget widget);
	/**	
		 "Unplug" or remove this action from a given widget.
			 This will typically be a menu or a toolbar.  This is rarely
		 used in "normal" application.  Typically, it would be used if
		 your application has several views or modes, each with a
		 completely different menu structure.  If you simply want to
		 disable an action for a given period, use setEnabled()
		 instead.
			@param w Remove the action from this GUI element.
		     		@short    "Unplug" or remove this action from a given widget.
	*/
	public native void unplug(QWidget w);
	/**	
		 returns whether the action is plugged into any container widget or not.
				@short    returns whether the action is plugged into any container widget or not.
	*/
	public native boolean isPlugged();
	/**	
		 returns whether the action is plugged into the given container
		     		@short    returns whether the action is plugged into the given container
	*/
	public native boolean isPlugged(QWidget container);
	/**	
		 returns whether the action is plugged into the given container with the given, container specific, id (often
		 menu or toolbar id ) .
		     		@short    returns whether the action is plugged into the given container with the given, container specific, id (often  menu or toolbar id ) .
	*/
	public native boolean isPlugged(QWidget container, int id);
	/**	
		 returns whether the action is plugged into the given container with the given, container specific, representative
		 container widget item.
		     		@short    returns whether the action is plugged into the given container with the given, container specific, representative  container widget item.
	*/
	public native boolean isPlugged(QWidget container, QWidget _representative);
	public native QWidget container(int index);
	public native int itemId(int index);
	public native QWidget representative(int index);
	public native int containerCount();
	public native int kaccelCount();
	public native boolean hasIcon();
	public native boolean hasIconSet();
	public native String plainText();
	/**	
		 Get the text associated with this action.
		     		@short    Get the text associated with this action.
	*/
	public native String text();
	/**	
		 Get the keyboard shortcut associated with this action.
		     		@short    Get the keyboard shortcut associated with this action.
	*/
	public native KShortcut shortcut();
	/**	
		 Get the default shortcut for this action.
		     		@short    Get the default shortcut for this action.
	*/
	public native KShortcut shortcutDefault();
	public native String shortcutText();
	public native void setShortcutText(String arg1);
	/**	
		 Returns true if this action is enabled.
		     		@short    Returns true if this action is enabled.
	*/
	public native boolean isEnabled();
	/**	
		 Returns true if this action's shortcut is configurable.
		     		@short    Returns true if this action's shortcut is configurable.
	*/
	public native boolean isShortcutConfigurable();
	public native String group();
	/**	
		 Get the What's this text for the action.
		     		@short    Get the What's this text for the action.
	*/
	public native String whatsThis();
	/**	
		 Get the tooltip text for the action.
		     		@short    Get the tooltip text for the action.
	*/
	public native String toolTip();
	/**	
		 Get the QIconSet from which the icons used to display this action will
		 be chosen.
			 In KDE4 set group default to KIcon.Small while removing the other
		 iconSet() function.
		     		@short    Get the QIconSet from which the icons used to display this action will  be chosen.
	*/
	public native QIconSet iconSet(int group, int size);
	public native QIconSet iconSet(int group);
	/**	
		 Remove in KDE4
		     		@short    Remove in KDE4
	*/
	public native QIconSet iconSet();
	public native String icon();
	public native KActionCollection parentCollection();
	public native void unplugAll();
	public native String statusText();
	/**	
		 Sets the text associated with this action. The text is used for menu
		 and toolbar labels etc.
		     		@short    Sets the text associated with this action.
	*/
	public native void setText(String text);
	/**	
		 Sets the keyboard shortcut associated with this action.
		     		@short    Sets the keyboard shortcut associated with this action.
	*/
	public native boolean setShortcut(KShortcut arg1);
	public native void setGroup(String arg1);
	/**	
		 Sets the What's this text for the action. This text will be displayed when
		 a widget that has been created by plugging this action into a container
		 is clicked on in What's this mode.
			 The What's this text can include QML markup as well as raw text.
		     		@short    Sets the What's this text for the action.
	*/
	public native void setWhatsThis(String text);
	/**	
		 Sets the tooltip text for the action.
		 This will be used as a tooltip for a toolbar button, as a
		 statusbar help-text for a menu item, and it also appears
		 in the toolbar editor, to describe the action.
			 For the tooltip to show up on the statusbar you will need to connect
		 a couple of the actionclass signals to the toolbar.
		 The easiest way of doing this is in your main window class, when you create
		 a statusbar.  See the KActionCollection class for more details.
			     		@short    Sets the tooltip text for the action.
		@see KActionCollection
	*/
	public native void setToolTip(String arg1);
	/**	
		 Sets the QIconSet from which the icons used to display this action will
		 be chosen.
		     		@short    Sets the QIconSet from which the icons used to display this action will  be chosen.
	*/
	public native void setIconSet(QIconSet iconSet);
	public native void setIcon(String icon);
	/**	
		 Enables or disables this action. All uses of this action (eg. in menus
		 or toolbars) will be updated to reflect the state of the action.
		     		@short    Enables or disables this action.
	*/
	public native void setEnabled(boolean enable);
	/**	
		 Calls setEnabled( !disable ).
				@short    Calls setEnabled( !disable ).
	*/
	public native void setDisabled(boolean disable);
	/**	
		 Indicate whether the user may configure the action's shortcut.
		     		@short    Indicate whether the user may configure the action's shortcut.
	*/
	public native void setShortcutConfigurable(boolean arg1);
	/**	
		 Emulate user's interaction programmatically, by activating the action.
		 The implementation simply emits activated().
		     		@short    Emulate user's interaction programmatically, by activating the action.
	*/
	public native void activate();
	/**	
			 Generate a toolbar button id. Made public for reimplementations.
		     		@short
	*/
	public static native int getToolButtonID();
	protected native KToolBar toolBar(int index);
	protected native QPopupMenu popupMenu(int index);
	protected native void removeContainer(int index);
	protected native int findContainer(QWidget widget);
	protected native int findContainer(int id);
	protected native void plugMainWindowAccel(QWidget w);
	protected native void addContainer(QWidget parent, int id);
	protected native void addContainer(QWidget parent, QWidget representative);
	protected native void updateShortcut(int i);
	protected native void updateShortcut(QPopupMenu menu, int id);
	protected native void updateGroup(int id);
	protected native void updateText(int i);
	protected native void updateEnabled(int i);
	protected native void updateIconSet(int i);
	protected native void updateIcon(int i);
	protected native void updateToolTip(int id);
	protected native void updateWhatsThis(int i);
	protected native String whatsThisWithIcon();
	/**	
		 Return the underlying KGuiItem
				@short    Return the underlying KGuiItem
	*/
	protected native KGuiItem guiItem();
	protected native void slotDestroyed();
	protected native void slotKeycodeChanged();
	protected native void slotActivated();
	protected native void slotPopupActivated();
	protected native void slotButtonClicked(int arg1, int state);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
