/***************************************************************************
                          KScribble.java  -  KScribble using java bindings
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
    java translation     : Kenneth J. Pouncey
    email                : kjpou@hotmail.com
 ***************************************************************************/


import java.util.*;
import org.kde.qt.*;
import org.kde.koala.*;

/**
  * The base class for JavaApiTest application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KBaseView creates your center view, which is connected
  * to the window's Doc object.
  * KBase reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class Main {

	static String description = "java KDE 3 example application";


   static String[][] options = {
      { "+[File]", "image file to open", null }
   };

static String VERSION = "0.1";

   public static void main(String[] cmdLineArgs) {

      KAboutData aboutData = new KAboutData( "kscribble", "KScribble",
         VERSION, description, KAboutData.License_GPL,
         "(C) 2000 by Ralf Nolden");
      KCmdLineArgs.init( cmdLineArgs, aboutData );
      KCmdLineArgs.addCmdLineOptions( options ); // Add our own options.

      KApplication app = new KApplication();
      KImageIO.registerFormats();
      KScribbleApp kscribbleapp = new KScribbleApp();

      if (app.isRestored()) {
         kscribbleapp.RESTORE("kscribbleapp");
      }
      else {
       kscribbleapp.show();
       KCmdLineArgs args = KCmdLineArgs.parsedArgs();

         if (args.count() > 0) {
           kscribbleapp.openDocumentFile(new KURL(args.arg(0)));
         }
         else {
           kscribbleapp.openDocumentFile();
         }
         args.clear();
      }

      app.exec();
      return;
   }

	static {
		qtjava.initialize();
		kdejava.initialize();
	}

}
