/*
* maildrop.h -- Declaration of class KMailDrop.
* Generated by newclass on Sat Nov 29 20:07:45 EST 1997.
*/
#ifndef SSK_MAILDROP_H
#define SSK_MAILDROP_H

#include<qobject.h>
#include<qstring.h>
#include<qcolor.h>

class KConfigBase;
class KDropCfgDialog;
class QColor;

/**
* Abstract base class for all mailbox monitors.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: maildrop.h,v 1.4 2000/06/14 19:37:24 rikkus Exp $
*/
class KMailDrop : public QObject
{
  Q_OBJECT

  public:

    enum  Style { Plain, Colour, Icon };

  private:

    QString _caption;
    QString _clickCmd;
    QString _nMailCmd;
    Style   _style;
    QColor  _bgColour;
    QColor  _fgColour;
    QColor  _nbgColour;
    QColor  _nfgColour;
    QString _icon;
    QString _nIcon;
    int     _lastCount;

  public:

    static const char *TypeConfigKey;
    static const char *CaptionConfigKey;
    static const char *ClickConfigKey;
    static const char *NewMailConfigKey;
    static const char *DisplayStyleConfigKey;
    static const char *NFgColourConfigKey;
    static const char *NBgColourConfigKey;
    static const char *FgColourConfigKey;
    static const char *BgColourConfigKey;
    static const char *IconConfigKey;
    static const char *NewMailIconConfigKey;

    /**
     * KMailDrop Constructor
     */
    KMailDrop();

    /**
     * KMailDrop Destructor
     */
    virtual ~KMailDrop();

    /** 
     * @return TRUE if the mailbox and its configuration are valid.
     */
    virtual bool valid() = 0;

    /** 
     * Number of messages in the mailbox at the last count.
     * @return The number of messages in the mailbox since last count.
     */
    int count() {return _lastCount;};

    /** 
     * Recheck the number of letters in this mailbox. Raises the
     * changed(int) signal if new mail is found.
     *
     * Concrete subclasses MUST reimplement this method.
     */
    virtual void recheck()=0;

    /** 
     */
    virtual bool startMonitor()=0;

    /** 
     */
    virtual bool stopMonitor()=0;

    /** 
     * Check monitor run status.
     * @return true if monitor is running.
     */
    virtual bool running()=0;

    /** 
     * Add a configuration page to the configuration dialog.
     * Each reimplementation should first call the inherited implementation,
     * then call @ref KDropCfgDialog::addConfigPage with a custom
     * @ref KMonitorCfg object.
     */
    virtual void addConfigPage( KDropCfgDialog * );

    /** 
     * Returns a newly created KBoxFactory object initialized to
     * be equivalent to this object (prototype pattern). 
     *
     * Deletion of the returned object becomes the responsibility of 
     * the caller.
     *
     * Subclasses should override this to return objects of their
     * own type.
     */
    virtual KMailDrop *clone() const = 0;

    /** 
     * Read box configuration from a config group. Subclasses that
     * reimplement this should call the overridden method.
     *
     * @param cfg  A configuration object with the group already set to
     *     the configuration for this box.
     * @return true if read was successful, false otherwise.
     */
    virtual bool readConfigGroup( const KConfigBase& cfg );

    /** 
     * Write box configuration to a config group. Subclasses that
     * reimplement this should call the overridden method.
     *
     * @param cfg  A configuration object with the group already set to
     *     the configuration for this box.
     * @return true if read was successful, false otherwise.
     */
    virtual bool writeConfigGroup( KConfigBase& cfg ) const;

    /** 
     * Return the type of this monitor, for display and
     * configuration purposes. Each concrete subclass should return a 
     * unique identifier.
     */
    virtual QString type() const = 0;

    // data that belongs in every monitor

    QString       caption()       const { return _caption; }
    QString       clickCmd()      const { return _clickCmd; }
    QString       newMailCmd()    const { return _nMailCmd; }
    QColor        bgColour()      const { return _bgColour; }
    QColor        fgColour()      const { return _fgColour; }
    QColor        newBgColour()   const { return _nbgColour; }
    QColor        newFgColour()   const { return _nfgColour; }
    QString       icon()          const { return _icon; }
    QString       newIcon()       const { return _nIcon; }
    Style         displayStyle()  const { return _style; }
;
    void setCaption(QString);
    void setClickCmd(QString);
    void setNewMailCmd(QString);
    void setDisplayStyle(Style);
    void setBgColour(QColor);
    void setFgColour(QColor);
    void setNewBgColour(QColor);
    void setNewFgColour(QColor);
    void setIcon(QString);
    void setNewIcon(QString);

    /** 
     * This is called by the manager when it wishes to delete
     * a monitor. Clients should connect to the @ref ::notifyDisconnect
     * signal and ensure that the monitor is not accessed after
     * the signal has been received.
     *
     * Reimplementations should call this implementation too.
     */
    virtual void notifyClients();

    public slots:

    /**
     * Forcibly set the count to zero;
     */
    virtual void forceCountZero();

    protected slots:

      void setCount( int );

signals:

    /** 
     * This signal is emitted when the mailbox discovers 
     * new messages in the maildrop.
     */
    void changed( int );

    /** 
     * This is emitted on configuration change, normally
     * on an updateConfig() but 
     */
    void configChanged();

    /** 
     * Clients should connect to this and discontinue use
     * after it is emitted.
     */
    void notifyDisconnect();
};

#endif // SSK_MAILDROP_H
