/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.awt.Component;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import org.kde.kjas.server.KJASConsole;
import org.kde.kjas.server.KJASProtocolHandler;

public class Main {
    public static final PrintStream protocol_stdout;
    public static final KJASProtocolHandler protocol;
    public static final KJASConsole console;
    private static final boolean show_console;
    public static final boolean Debug;
    public static final boolean log;
    private static boolean good_jdk;

    public static void debug(String string) {
        if (Debug) {
            System.out.println("KJAS: " + string);
        }
    }

    public static void kjas_err(String string, Exception exception) {
        System.err.println(string);
        System.err.println("Backtrace: ");
        exception.printStackTrace();
    }

    public static void kjas_err(String string, Throwable throwable) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    public static void main(String[] stringArray) {
        if (!good_jdk) {
            ((Component)console).setVisible(true);
            System.err.println("ERROR: This version of Java is not supported for security reasons.");
            System.err.println("\t\tPlease use Java version 1.2 or higher.");
            return;
        }
        if (show_console) {
            ((Component)console).setVisible(true);
        }
        try {
            System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            if (Security.getProvider("SunJSSE") == null) {
                Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                if (clazz != null) {
                    Main.debug("adding Security Provider");
                    Provider provider = (Provider)clazz.newInstance();
                    Security.addProvider(provider);
                } else {
                    Main.debug("could not get class: com.sun.net.ssl.internal.ssl.Provider");
                }
            } else {
                Main.debug("could not get provider: SunJSSE");
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to load JSSE SSL stream handler, https support not available");
        }
        protocol.commandLoop();
    }

    static {
        good_jdk = true;
        Debug = System.getProperty("kjas.debug") != null;
        show_console = System.getProperty("kjas.showConsole") != null;
        log = System.getProperty("kjas.log") != null;
        protocol_stdout = System.out;
        console = new KJASConsole();
        protocol = new KJASProtocolHandler(System.in, protocol_stdout);
        Main.debug("JVM version = " + System.getProperty("java.version"));
        String string = System.getProperty("java.version").substring(0, 3);
        Main.debug("JVM numerical version = " + string);
        try {
            float f = Float.parseFloat(string);
            if ((double)f < 1.2) {
                good_jdk = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            good_jdk = false;
        }
    }
}

