/* This file is part of Validators
 *
 *  It's a merge of the HTML- and the CSSValidator
 *
 *  Copyright (C) 2001 by  Richard Moore <rich@kde.org>
 *                         Andreas Schlapbach <schlpbch@iam.unibe.ch>
 * 
 *  for information how to write your own plugin see:  
 *    http://developer.kde.org/documentation/tutorials/dot/writing-plugins.html
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

/* $Id: plugin_validators.cpp,v 1.4 2001/07/22 21:29:25 schlpbch Exp $ */

#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kaction.h>
#include <khtml_part.h>
#include <kconfig.h>   

#include "plugin_validators.h"

PluginValidators::PluginValidators( QObject* parent, const char* name )
  : Plugin( parent, name )
{
  m_menu = new KActionMenu ( i18n( "&Validate Web Page" ), "validators",
			     actionCollection(), "validateWebpage" );
  m_menu->setDelayed( false );

  m_menu->insert( new KAction( i18n( "&Validate HTML" ), 
			       "htmlvalidator", 0,
			       this, SLOT(slotValidateHTML()),
			       actionCollection(), "validateHTML") );

  m_menu->insert( new KAction( i18n( "&Validate CSS" ),
			       "cssvalidator", 0,
			       this, SLOT(slotValidateCSS()),
			       actionCollection(), "validateCSS") );
  // Load web addresses
  //# Needs a GUI after 2.2
 
  m_config = new KConfig("validatorsrc");   
  m_config->setGroup("Addresses");
  m_WWWValidatorUrl = static_cast<KURL>(m_config->readEntry("WWWValidatorUrl",
							  "http://validator.w3.org/check/" ));
  m_CSSValidatorUrl = static_cast<KURL>(m_config->readEntry("CSSValidatorUrl",
							  "http://jigsaw.w3.org/css-validator/validator"));
  m_WWWValidatorUploadUrl = static_cast<KURL>(m_config->readEntry("WWWValidatorUploadUrl",
								"http://validator.w3.org/file-upload.html" ));
  m_CSSValidatorUploadUrl = static_cast<KURL>(m_config->readEntry("CSSValidatorUploadUrl",
								"http://jigsaw.w3.org/css-validator/validator-upload.html" ));

}

PluginValidators::~PluginValidators()
{
  m_config->writeEntry( "WWWValidatorUrl", m_WWWValidatorUrl.url() );
  m_config->writeEntry( "CSSValidatorUrl", m_CSSValidatorUrl.url() );
  m_config->writeEntry( "WWWValidatorUploadUrl", m_WWWValidatorUploadUrl.url() );
  m_config->writeEntry( "CSSValidatorUploadUrl", m_CSSValidatorUploadUrl.url() );
  m_config->sync();
  delete m_config;
  delete m_menu;
}

void PluginValidators::slotValidateHTML()
{
  m_url = m_WWWValidatorUrl;
  m_uploadUrl = m_WWWValidatorUploadUrl;
  validateURL();
}

void PluginValidators::slotValidateCSS()
{
  m_url = m_CSSValidatorUrl;
  m_uploadUrl = m_CSSValidatorUploadUrl; 
  validateURL();  
}

void PluginValidators::validateURL()
{ 
  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
    {
      QString title = i18n( "Cannot Validate Source" );
      QString text = i18n( "You cannot validate anything except web pages with\n"
			   "this plugin." );

      KMessageBox::sorry( 0, text, title );
      return;
    }
  // Check syntax

  KURL validatorUrl(m_url);

  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());
  // Get URL
  KURL url = part->url();
  
  if ( url.isMalformed() ) // Just in case ;)
    {
      QString title = i18n( "Malformed URL" );
      QString text = i18n( "The URL you entered is not valid, please "
			   "correct it and try again." );
      KMessageBox::sorry( 0, text, title );
      return;
    }
  
  if (url.isLocalFile()) {
    validatorUrl = m_uploadUrl;
  } else {
    // Set entered URL as a parameter
    QString p;
    QString q = url.url();
    q = KURL::encode_string( q );
    p = "uri=";
    p += q;
    validatorUrl.setQuery( p );
  }

  emit part->browserExtension()->openURLRequest( validatorUrl );
}

ValidatorsFactory::ValidatorsFactory()
{
}

ValidatorsFactory::~ValidatorsFactory()
{
  delete s_instance;
  s_instance = 0;
}

QObject* ValidatorsFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
  return new PluginValidators( parent, name );
}

KInstance *ValidatorsFactory::instance()
{
  if ( !s_instance )
    s_instance = new KInstance( "validatorsplugin" );
  return s_instance;
}

extern "C"
{
  void* init_libvalidatorsplugin()
  {
    KGlobal::locale()->insertCatalogue("validatorsplugin");
    return new ValidatorsFactory;
  }
}

KInstance* ValidatorsFactory::s_instance = 0;

#include <plugin_validators.moc>
    