/* $Id: plugin_domtreeviewer.cpp,v 1.6 2001/07/16 11:11:35 lukas Exp $ */

#include "plugin_domtreeviewer.h"

#include <kaction.h>
#include <kinstance.h>

#include <klocale.h>

#include <khtml_part.h>

#include <domtreeview.h>

PluginDomtreeviewer::PluginDomtreeviewer( QObject* parent, const char* name )
  : Plugin( parent, name )
{
  (void) new KAction( i18n("Show &DOM tree"),
                      "domtreeviewer", 0,
                      this, SLOT(slotShowDOMTree()),
                      actionCollection(), "viewdomtree" );
}

PluginDomtreeviewer::~PluginDomtreeviewer()
{
}

void PluginDomtreeviewer::slotShowDOMTree()
{
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());

  DOMTreeView * dtv = new DOMTreeView(0, part, "DomTreeView", false);
  dtv->show();
}


DomtreeviewerFactory::DomtreeviewerFactory()
{
}

DomtreeviewerFactory::~DomtreeviewerFactory()
{
  delete s_instance;
  s_instance = 0;
}

QObject* DomtreeviewerFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
  return new PluginDomtreeviewer( parent, name );
}

KInstance *DomtreeviewerFactory::instance()
{
  if ( !s_instance )
    s_instance = new KInstance( "domtreeviewer" );
  return s_instance;
}

extern "C"
{
  void* init_libdomtreeviewerplugin()
  {
    KGlobal::locale()->insertCatalogue("domtreeviewer"); 
    return new DomtreeviewerFactory;
  }
}

KInstance* DomtreeviewerFactory::s_instance = 0;

#include <plugin_domtreeviewer.moc>
