/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_EXTENSIONS_SOURCE_PROPCTRLR_FORMSTRINGS_HXX
#define INCLUDED_EXTENSIONS_SOURCE_PROPCTRLR_FORMSTRINGS_HXX


namespace pcr
{


    #define PROPERTY_DEFAULTCONTROL          "DefaultControl"
    #define PROPERTY_INTROSPECTEDOBJECT      "IntrospectedObject"
    #define PROPERTY_CURRENTPAGE             "CurrentPage"
    #define PROPERTY_CONTROLCONTEXT          "ControlContext"

    // properties
    #define PROPERTY_CLASSID                 "ClassId"
    #define PROPERTY_CONTROLLABEL            "LabelControl"
    #define PROPERTY_LABEL                   "Label"
    #define PROPERTY_TABINDEX                "TabIndex"
    #define PROPERTY_WHEEL_BEHAVIOR          "MouseWheelBehavior"
    #define PROPERTY_TAG                     "Tag"
    #define PROPERTY_NAME                    "Name"
    #define PROPERTY_GROUP_NAME              "GroupName"
    #define PROPERTY_VALUE                   "Value"
    #define PROPERTY_TEXT                    "Text"
    #define PROPERTY_NAVIGATION              "NavigationBarMode"
    #define PROPERTY_CYCLE                   "Cycle"
    #define PROPERTY_CONTROLSOURCE           "DataField"
    #define PROPERTY_INPUT_REQUIRED          "InputRequired"
    #define PROPERTY_ENABLED                 "Enabled"
    #define PROPERTY_ENABLE_VISIBLE          "EnableVisible"
    #define PROPERTY_READONLY                "ReadOnly"
    #define PROPERTY_ISREADONLY              "IsReadOnly"
    #define PROPERTY_FILTER                  "Filter"
    #define PROPERTY_WIDTH                   "Width"
    #define PROPERTY_MULTILINE               "MultiLine"
    #define PROPERTY_WORDBREAK               "WordBreak"
    #define PROPERTY_TARGET_URL              "TargetURL"
    #define PROPERTY_TARGET_FRAME            "TargetFrame"
    #define PROPERTY_MAXTEXTLEN              "MaxTextLen"
    #define PROPERTY_EDITMASK                "EditMask"
    #define PROPERTY_SPIN                    "Spin"
    #define PROPERTY_TRISTATE                "TriState"
    #define PROPERTY_HIDDEN_VALUE            "HiddenValue"
    #define PROPERTY_BUTTONTYPE             "ButtonType"
    #define PROPERTY_XFORMS_BUTTONTYPE      "XFormsButtonType"
    #define PROPERTY_STRINGITEMLIST         "StringItemList"
    #define PROPERTY_TYPEDITEMLIST          "TypedItemList"
    #define PROPERTY_DEFAULT_TEXT           "DefaultText"
    #define PROPERTY_DEFAULT_STATE          "DefaultState"
    #define PROPERTY_FORMATKEY              "FormatKey"
    #define PROPERTY_FORMATSSUPPLIER        "FormatsSupplier"
    #define PROPERTY_SUBMIT_ACTION          "SubmitAction"
    #define PROPERTY_SUBMIT_TARGET          "SubmitTarget"
    #define PROPERTY_SUBMIT_METHOD          "SubmitMethod"
    #define PROPERTY_SUBMIT_ENCODING        "SubmitEncoding"
    #define PROPERTY_IMAGE_URL              "ImageURL"
    #define PROPERTY_GRAPHIC                "Graphic"
    #define PROPERTY_EMPTY_IS_NULL          "ConvertEmptyToNull"
    #define PROPERTY_LISTSOURCETYPE         "ListSourceType"
    #define PROPERTY_LISTSOURCE             "ListSource"
    #define PROPERTY_DEFAULT_SELECT_SEQ     "DefaultSelection"
    #define PROPERTY_MULTISELECTION         "MultiSelection"
    #define PROPERTY_ALIGN                  "Align"
    #define PROPERTY_VERTICAL_ALIGN         "VerticalAlign"
    #define PROPERTY_DEFAULT_DATE           "DefaultDate"
    #define PROPERTY_DEFAULT_TIME           "DefaultTime"
    #define PROPERTY_DEFAULT_VALUE          "DefaultValue"
    #define PROPERTY_DECIMAL_ACCURACY       "DecimalAccuracy"
    #define PROPERTY_REFVALUE               "RefValue"
    #define PROPERTY_UNCHECKEDREFVALUE      "SecondaryRefValue"
    #define PROPERTY_VALUEMIN               "ValueMin"
    #define PROPERTY_VALUEMAX               "ValueMax"
    #define PROPERTY_STRICTFORMAT           "StrictFormat"
    #define PROPERTY_ALLOWADDITIONS         "AllowInserts"
    #define PROPERTY_ALLOWEDITS             "AllowUpdates"
    #define PROPERTY_ALLOWDELETIONS         "AllowDeletes"
    #define PROPERTY_MASTERFIELDS           "MasterFields"
    #define PROPERTY_LITERALMASK            "LiteralMask"
    #define PROPERTY_VALUESTEP              "ValueStep"
    #define PROPERTY_SHOWTHOUSANDSEP        "ShowThousandsSeparator"
    #define PROPERTY_CURRENCYSYMBOL         "CurrencySymbol"
    #define PROPERTY_DATEFORMAT             "DateFormat"
    #define PROPERTY_DATEMIN                "DateMin"
    #define PROPERTY_DATEMAX                "DateMax"
    #define PROPERTY_TIMEFORMAT             "TimeFormat"
    #define PROPERTY_TIMEMIN                "TimeMin"
    #define PROPERTY_TIMEMAX                "TimeMax"
    #define PROPERTY_LINECOUNT              "LineCount"
    #define PROPERTY_BOUNDCOLUMN            "BoundColumn"
    #define PROPERTY_BACKGROUNDCOLOR        "BackgroundColor"
    #define PROPERTY_FILLCOLOR              "FillColor"
    #define PROPERTY_TEXTCOLOR              "TextColor"
    #define PROPERTY_LINECOLOR              "LineColor"
    #define PROPERTY_BORDER                 "Border"
    #define PROPERTY_ICONSIZE               "IconSize"
    #define PROPERTY_DROPDOWN               "Dropdown"
    #define PROPERTY_HSCROLL                "HScroll"
    #define PROPERTY_VSCROLL                "VScroll"
    #define PROPERTY_SHOW_SCROLLBARS        "ShowScrollbars"
    #define PROPERTY_TABSTOP                "Tabstop"
    #define PROPERTY_AUTOCOMPLETE           "Autocomplete"
    #define PROPERTY_PRINTABLE              "Printable"
    #define PROPERTY_ECHO_CHAR              "EchoChar"
    #define PROPERTY_ROWHEIGHT              "RowHeight"
    #define PROPERTY_HELPTEXT               "HelpText"
    #define PROPERTY_FONT                   "FontDescriptor"
    #define PROPERTY_FONT_NAME              "FontName"
    #define PROPERTY_FONT_STYLENAME         "FontStyleName"
    #define PROPERTY_FONT_FAMILY            "FontFamily"
    #define PROPERTY_FONT_CHARSET           "FontCharset"
    #define PROPERTY_FONT_HEIGHT            "FontHeight"
    #define PROPERTY_FONT_WEIGHT            "FontWeight"
    #define PROPERTY_FONT_SLANT             "FontSlant"
    #define PROPERTY_FONT_UNDERLINE         "FontUnderline"
    #define PROPERTY_FONT_STRIKEOUT         "FontStrikeout"
    #define PROPERTY_FONT_RELIEF            "FontRelief"
    #define PROPERTY_FONT_EMPHASIS_MARK     "FontEmphasisMark"
    #define PROPERTY_TEXTLINECOLOR          "TextLineColor"
    #define PROPERTY_HELPURL                "HelpURL"
    #define PROPERTY_RECORDMARKER           "HasRecordMarker"
    #define PROPERTY_EFFECTIVE_DEFAULT      "EffectiveDefault"
    #define PROPERTY_EFFECTIVE_MIN          "EffectiveMin"
    #define PROPERTY_EFFECTIVE_MAX          "EffectiveMax"
    #define PROPERTY_FILTERPROPOSAL         "UseFilterValueProposal"
    #define PROPERTY_CURRSYM_POSITION       "PrependCurrencySymbol"
    #define PROPERTY_COMMAND                "Command"
    #define PROPERTY_COMMANDTYPE            "CommandType"
    #define PROPERTY_INSERTONLY             "IgnoreResult"
    #define PROPERTY_ESCAPE_PROCESSING      "EscapeProcessing"
    #define PROPERTY_TITLE                  "Title"
    #define PROPERTY_SORT                   "Order"
    #define PROPERTY_DATASOURCE             "DataSourceName"
    #define PROPERTY_DETAILFIELDS           "DetailFields"
    #define PROPERTY_DEFAULTBUTTON          "DefaultButton"
    #define PROPERTY_LISTINDEX              "ListIndex"
    #define PROPERTY_HEIGHT                 "Height"
    #define PROPERTY_HASNAVIGATION          "HasNavigationBar"
    #define PROPERTY_POSITIONX              "PositionX"
    #define PROPERTY_POSITIONY              "PositionY"
    #define PROPERTY_STEP                   "Step"
    #define PROPERTY_WORDLINEMODE           "FontWordLineMode"
    #define PROPERTY_PROGRESSVALUE          "ProgressValue"
    #define PROPERTY_PROGRESSVALUE_MIN      "ProgressValueMin"
    #define PROPERTY_PROGRESSVALUE_MAX      "ProgressValueMax"
    #define PROPERTY_SCROLLVALUE            "ScrollValue"
    #define PROPERTY_DEFAULT_SCROLLVALUE    "DefaultScrollValue"
    #define PROPERTY_SCROLLVALUE_MIN        "ScrollValueMin"
    #define PROPERTY_SCROLLVALUE_MAX        "ScrollValueMax"
    #define PROPERTY_SCROLL_WIDTH        "ScrollWidth"
    #define PROPERTY_SCROLL_HEIGHT        "ScrollHeight"
    #define PROPERTY_SCROLL_TOP        "ScrollTop"
    #define PROPERTY_SCROLL_LEFT        "ScrollLeft"
    #define PROPERTY_LINEINCREMENT          "LineIncrement"
    #define PROPERTY_BLOCKINCREMENT         "BlockIncrement"
    #define PROPERTY_VISIBLESIZE            "VisibleSize"
    #define PROPERTY_ORIENTATION            "Orientation"
    #define PROPERTY_IMAGEPOSITION          "ImagePosition"
    #define PROPERTY_ACTIVE_CONNECTION      "ActiveConnection"
    #define PROPERTY_ACTIVECOMMAND          "ActiveCommand"
    #define PROPERTY_DATE                   "Date"
    #define PROPERTY_STATE                  "State"
    #define PROPERTY_TIME                   "Time"
    #define PROPERTY_SCALEIMAGE             "ScaleImage"
    #define PROPERTY_SCALE_MODE             "ScaleMode"
    #define PROPERTY_PUSHBUTTONTYPE         "PushButtonType"
    #define PROPERTY_EFFECTIVE_VALUE        "EffectiveValue"
    #define PROPERTY_SELECTEDITEMS          "SelectedItems"
    #define PROPERTY_REPEAT                 "Repeat"
    #define PROPERTY_REPEAT_DELAY           "RepeatDelay"
    #define PROPERTY_SYMBOLCOLOR            "SymbolColor"
    #define PROPERTY_SPINVALUE              "SpinValue"
    #define PROPERTY_SPINVALUE_MIN          "SpinValueMin"
    #define PROPERTY_SPINVALUE_MAX          "SpinValueMax"
    #define PROPERTY_DEFAULT_SPINVALUE      "DefaultSpinValue"
    #define PROPERTY_SPININCREMENT          "SpinIncrement"
    #define PROPERTY_SHOW_POSITION          "ShowPosition"
    #define PROPERTY_SHOW_NAVIGATION        "ShowNavigation"
    #define PROPERTY_SHOW_RECORDACTIONS     "ShowRecordActions"
    #define PROPERTY_SHOW_FILTERSORT        "ShowFilterSort"
    #define PROPERTY_LINEEND_FORMAT         "LineEndFormat"
    #define PROPERTY_DECORATION             "Decoration"
    #define PROPERTY_NOLABEL                "NoLabel"

    #define PROPERTY_SELECTION_TYPE         "SelectionType"
    #define PROPERTY_ROOT_DISPLAYED         "RootDisplayed"
    #define PROPERTY_SHOWS_HANDLES          "ShowsHandles"
    #define PROPERTY_SHOWS_ROOT_HANDLES     "ShowsRootHandles"
    #define PROPERTY_EDITABLE               "Editable"
    #define PROPERTY_INVOKES_STOP_NOT_EDITING "InvokesStopNodeEditing"

    #define PROPERTY_HARDLINEBREAKS         "HardLineBreaks"

    #define PROPERTY_TOGGLE                 "Toggle"
    #define PROPERTY_FOCUSONCLICK           "FocusOnClick"
    #define PROPERTY_HIDEINACTIVESELECTION  "HideInactiveSelection"
    #define PROPERTY_VISUALEFFECT           "VisualEffect"
    #define PROPERTY_BORDERCOLOR            "BorderColor"

    #define PROPERTY_ADDRESS                "Address"
    #define PROPERTY_REFERENCE_SHEET        "ReferenceSheet"
    #define PROPERTY_UI_REPRESENTATION      "UserInterfaceRepresentation"

    #define PROPERTY_XML_DATA_MODEL         "XMLDataModel"
    #define PROPERTY_BINDING_NAME           "BindingName"
    #define PROPERTY_BIND_EXPRESSION        "BindingExpression"
    #define PROPERTY_LIST_BINDING           "ListBinding"
    #define PROPERTY_XSD_REQUIRED           "RequiredExpression"
    #define PROPERTY_XSD_RELEVANT           "RelevantExpression"
    #define PROPERTY_XSD_READONLY           "ReadonlyExpression"
    #define PROPERTY_XSD_CONSTRAINT         "ConstraintExpression"
    #define PROPERTY_XSD_CALCULATION        "CalculateExpression"
    #define PROPERTY_XSD_DATA_TYPE          "Type"
    #define PROPERTY_XSD_WHITESPACES        "WhiteSpace"
    #define PROPERTY_XSD_PATTERN            "Pattern"
    #define PROPERTY_XSD_LENGTH             "Length"
    #define PROPERTY_XSD_MIN_LENGTH         "MinLength"
    #define PROPERTY_XSD_MAX_LENGTH         "MaxLength"
    #define PROPERTY_XSD_TOTAL_DIGITS       "TotalDigits"
    #define PROPERTY_XSD_FRACTION_DIGITS    "FractionDigits"
    #define PROPERTY_XSD_MAX_INCLUSIVE_INT  "MaxInclusiveInt"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_INT  "MaxExclusiveInt"
    #define PROPERTY_XSD_MIN_INCLUSIVE_INT  "MinInclusiveInt"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_INT  "MinExclusiveInt"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DOUBLE "MaxInclusiveDouble"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DOUBLE "MaxExclusiveDouble"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DOUBLE "MinInclusiveDouble"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DOUBLE "MinExclusiveDouble"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DATE "MaxInclusiveDate"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DATE "MaxExclusiveDate"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DATE "MinInclusiveDate"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DATE "MinExclusiveDate"
    #define PROPERTY_XSD_MAX_INCLUSIVE_TIME "MaxInclusiveTime"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_TIME "MaxExclusiveTime"
    #define PROPERTY_XSD_MIN_INCLUSIVE_TIME "MinInclusiveTime"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_TIME "MinExclusiveTime"
    #define PROPERTY_XSD_MAX_INCLUSIVE_DATE_TIME "MaxInclusiveDateTime"
    #define PROPERTY_XSD_MAX_EXCLUSIVE_DATE_TIME "MaxExclusiveDateTime"
    #define PROPERTY_XSD_MIN_INCLUSIVE_DATE_TIME "MinInclusiveDateTime"
    #define PROPERTY_XSD_MIN_EXCLUSIVE_DATE_TIME "MinExclusiveDateTime"
    #define PROPERTY_SUBMISSION_ID          "SubmissionID"
    #define PROPERTY_BINDING_ID             "BindingID"
    #define PROPERTY_ID                     "ID"
    #define PROPERTY_WRITING_MODE           "WritingMode"
    #define PROPERTY_TEXT_ANCHOR_TYPE       "TextAnchorType"
    #define PROPERTY_SHEET_ANCHOR_TYPE      "SheetAnchorType"
    #define PROPERTY_ANCHOR_TYPE            "AnchorType"
    #define PROPERTY_ANCHOR                 "Anchor"
    #define PROPERTY_IS_VISIBLE             "IsVisible"

    #define PROPERTY_MODEL                  "Model"

    #define PROPERTY_CELL_EXCHANGE_TYPE     "ExchangeSelectionIndex"
    #define PROPERTY_BOUND_CELL             "BoundCell"
    #define PROPERTY_LIST_CELL_RANGE        "CellRange"
    #define PROPERTY_AUTOLINEBREAK          "AutomaticLineBreak"
    #define PROPERTY_TEXTTYPE               "TextType"
    #define PROPERTY_RICHTEXT               "RichText"
    #define PROPERTY_ROWSET                 "RowSet"

    // services
    #define SERVICE_COMPONENT_GROUPBOX      "com.sun.star.form.component.GroupBox"
    #define SERVICE_COMPONENT_FIXEDTEXT     "com.sun.star.form.component.FixedText"
    #define SERVICE_COMPONENT_FORMATTEDFIELD "com.sun.star.form.component.FormattedField"

    #define SERVICE_TEXT_DOCUMENT           "com.sun.star.text.TextDocument"
    #define SERVICE_WEB_DOCUMENT            "com.sun.star.text.WebDocument"
    #define SERVICE_SPREADSHEET_DOCUMENT    "com.sun.star.sheet.SpreadsheetDocument"
    #define SERVICE_DRAWING_DOCUMENT        "com.sun.star.drawing.DrawingDocument"
    #define SERVICE_PRESENTATION_DOCUMENT   "com.sun.star.presentation.PresentationDocument"

    #define SERVICE_SHEET_CELL_BINDING      "com.sun.star.table.CellValueBinding"
    #define SERVICE_SHEET_CELL_INT_BINDING  "com.sun.star.table.ListPositionCellBinding"
    #define SERVICE_SHEET_CELLRANGE_LISTSOURCE "com.sun.star.table.CellRangeListSource"
    #define SERVICE_ADDRESS_CONVERSION      "com.sun.star.table.CellAddressConversion"
    #define SERVICE_RANGEADDRESS_CONVERSION "com.sun.star.table.CellRangeAddressConversion"


} // namespace pcr


#endif // INCLUDED_EXTENSIONS_SOURCE_PROPCTRLR_FORMSTRINGS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
