/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef CASEFOLDING_DATA_H
#define CASEFOLDING_DATA_H

#include <sal/types.h>

namespace com { namespace sun { namespace star { namespace i18n {

static sal_Int8 CaseMappingIndex[] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05,   -1,   -1, // 0000 - 07ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 0800 - 0fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 1000 - 17ff
      -1,   -1,   -1,   -1,   -1,   -1, 0x06, 0x07, // 1800 - 1fff
      -1, 0x08,   -1,   -1, 0x09,   -1,   -1,   -1, // 2000 - 27ff
      -1,   -1,   -1,   -1, 0x0a,   -1,   -1,   -1, // 2800 - 2fff, Coptic added
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 3000 - 37ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 3800 - 3fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 4000 - 47ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 4800 - 4fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 5000 - 57ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 5800 - 5fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 6000 - 67ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 6800 - 6fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 7000 - 77ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 7800 - 7fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 8000 - 87ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 8800 - 8fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 9000 - 97ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // 9800 - 9fff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // a000 - a7ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // a800 - afff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // b000 - b7ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // b800 - bfff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // c000 - c7ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // c800 - cfff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // d000 - d7ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // d800 - dfff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // e000 - e7ff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // e800 - efff
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, // f000 - f7ff
      -1,   -1,   -1, 0x0b,   -1,   -1,   -1, 0x0c, // f800 - ffff
};


static Value CaseMappingValue[] = {
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0000 - 0007
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0008 - 000f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0010 - 0017
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0018 - 001f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0020 - 0027
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0028 - 002f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0030 - 0037
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0038 - 003f
    {0x00, 0x0000}, {0x6a, 0x0061}, {0x6a, 0x0062}, {0x6a, 0x0063}, {0x6a, 0x0064}, {0x6a, 0x0065}, {0x6a, 0x0066}, {0x6a, 0x0067}, // 0040 - 0047
    {0x6a, 0x0068}, {0xea, 0x0000}, {0xea, 0x0003}, {0x6a, 0x006B}, {0x6a, 0x006C}, {0x6a, 0x006D}, {0x6a, 0x006E}, {0x6a, 0x006F}, // 0048 - 004f
    {0x6a, 0x0070}, {0x6a, 0x0071}, {0x6a, 0x0072}, {0x6a, 0x0073}, {0x6a, 0x0074}, {0x6a, 0x0075}, {0x6a, 0x0076}, {0x6a, 0x0077}, // 0050 - 0057
    {0x6a, 0x0078}, {0x6a, 0x0079}, {0x6a, 0x007A}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0058 - 005f
    {0x00, 0x0000}, {0x15, 0x0041}, {0x15, 0x0042}, {0x15, 0x0043}, {0x15, 0x0044}, {0x15, 0x0045}, {0x15, 0x0046}, {0x15, 0x0047}, // 0060 - 0067
    {0x15, 0x0048}, {0x95, 0x0000}, {0x15, 0x004A}, {0x15, 0x004B}, {0x15, 0x004C}, {0x15, 0x004D}, {0x15, 0x004E}, {0x15, 0x004F}, // 0068 - 006f
    {0x15, 0x0050}, {0x15, 0x0051}, {0x15, 0x0052}, {0x15, 0x0053}, {0x15, 0x0054}, {0x15, 0x0055}, {0x15, 0x0056}, {0x15, 0x0057}, // 0070 - 0077
    {0x15, 0x0058}, {0x15, 0x0059}, {0x15, 0x005A}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0078 - 007f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0080 - 0087
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0088 - 008f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0090 - 0097
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0098 - 009f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 00a0 - 00a7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 00a8 - 00af
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0xf5, 0x0005}, {0x00, 0x0000}, {0x00, 0x0000}, // 00b0 - 00b7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 00b8 - 00bf
    {0x6a, 0x00E0}, {0x6a, 0x00E1}, {0x6a, 0x00E2}, {0x6a, 0x00E3}, {0x6a, 0x00E4}, {0x6a, 0x00E5}, {0x6a, 0x00E6}, {0x6a, 0x00E7}, // 00c0 - 00c7
    {0x6a, 0x00E8}, {0x6a, 0x00E9}, {0x6a, 0x00EA}, {0x6a, 0x00EB}, {0xea, 0x0007}, {0xea, 0x0009}, {0x6a, 0x00EE}, {0x6a, 0x00EF}, // 00c8 - 00cf
    {0x6a, 0x00F0}, {0x6a, 0x00F1}, {0x6a, 0x00F2}, {0x6a, 0x00F3}, {0x6a, 0x00F4}, {0x6a, 0x00F5}, {0x6a, 0x00F6}, {0x00, 0x0000}, // 00d0 - 00d7
    {0x6a, 0x00F8}, {0x6a, 0x00F9}, {0x6a, 0x00FA}, {0x6a, 0x00FB}, {0x6a, 0x00FC}, {0x6a, 0x00FD}, {0x6a, 0x00FE}, {0xd5, 0x000B}, // 00d8 - 00df
    {0x15, 0x00C0}, {0x15, 0x00C1}, {0x15, 0x00C2}, {0x15, 0x00C3}, {0x15, 0x00C4}, {0x15, 0x00C5}, {0x15, 0x00C6}, {0x15, 0x00C7}, // 00e0 - 00e7
    {0x15, 0x00C8}, {0x15, 0x00C9}, {0x15, 0x00CA}, {0x15, 0x00CB}, {0x15, 0x00CC}, {0x15, 0x00CD}, {0x15, 0x00CE}, {0x15, 0x00CF}, // 00e8 - 00ef
    {0x15, 0x00D0}, {0x15, 0x00D1}, {0x15, 0x00D2}, {0x15, 0x00D3}, {0x15, 0x00D4}, {0x15, 0x00D5}, {0x15, 0x00D6}, {0x00, 0x0000}, // 00f0 - 00f7
    {0x15, 0x00D8}, {0x15, 0x00D9}, {0x15, 0x00DA}, {0x15, 0x00DB}, {0x15, 0x00DC}, {0x15, 0x00DD}, {0x15, 0x00DE}, {0x15, 0x0178}, // 00f8 - 00ff

    {0x6a, 0x0101}, {0x15, 0x0100}, {0x6a, 0x0103}, {0x15, 0x0102}, {0x6a, 0x0105}, {0x15, 0x0104}, {0x6a, 0x0107}, {0x15, 0x0106}, // 0100 - 0107
    {0x6a, 0x0109}, {0x15, 0x0108}, {0x6a, 0x010B}, {0x15, 0x010A}, {0x6a, 0x010D}, {0x15, 0x010C}, {0x6a, 0x010F}, {0x15, 0x010E}, // 0108 - 010f
    {0x6a, 0x0111}, {0x15, 0x0110}, {0x6a, 0x0113}, {0x15, 0x0112}, {0x6a, 0x0115}, {0x15, 0x0114}, {0x6a, 0x0117}, {0x15, 0x0116}, // 0110 - 0117
    {0x6a, 0x0119}, {0x15, 0x0118}, {0x6a, 0x011B}, {0x15, 0x011A}, {0x6a, 0x011D}, {0x15, 0x011C}, {0x6a, 0x011F}, {0x15, 0x011E}, // 0118 - 011f
    {0x6a, 0x0121}, {0x15, 0x0120}, {0x6a, 0x0123}, {0x15, 0x0122}, {0x6a, 0x0125}, {0x15, 0x0124}, {0x6a, 0x0127}, {0x15, 0x0126}, // 0120 - 0127
    {0xea, 0x000E}, {0x15, 0x0128}, {0x6a, 0x012B}, {0x15, 0x012A}, {0x6a, 0x012D}, {0x15, 0x012C}, {0xea, 0x0010}, {0x15, 0x012E}, // 0128 - 012f
    {0xea, 0x0000}, {0x15, 0x0049}, {0x6a, 0x0133}, {0x15, 0x0132}, {0x6a, 0x0135}, {0x15, 0x0134}, {0x6a, 0x0137}, {0x15, 0x0136}, // 0130 - 0137
    {0x00, 0x0000}, {0x6a, 0x013A}, {0x15, 0x0139}, {0x6a, 0x013C}, {0x15, 0x013B}, {0x6a, 0x013E}, {0x15, 0x013D}, {0x6a, 0x0140}, // 0138 - 013f
    {0x15, 0x013F}, {0x6a, 0x0142}, {0x15, 0x0141}, {0x6a, 0x0144}, {0x15, 0x0143}, {0x6a, 0x0146}, {0x15, 0x0145}, {0x6a, 0x0148}, // 0140 - 0147
    {0x15, 0x0147}, {0xd5, 0x0014}, {0x6a, 0x014B}, {0x15, 0x014A}, {0x6a, 0x014D}, {0x15, 0x014C}, {0x6a, 0x014F}, {0x15, 0x014E}, // 0148 - 014f
    {0x6a, 0x0151}, {0x15, 0x0150}, {0x6a, 0x0153}, {0x15, 0x0152}, {0x6a, 0x0155}, {0x15, 0x0154}, {0x6a, 0x0157}, {0x15, 0x0156}, // 0150 - 0157
    {0x6a, 0x0159}, {0x15, 0x0158}, {0x6a, 0x015B}, {0x15, 0x015A}, {0x6a, 0x015D}, {0x15, 0x015C}, {0x6a, 0x015F}, {0x15, 0x015E}, // 0158 - 015f
    {0x6a, 0x0161}, {0x15, 0x0160}, {0x6a, 0x0163}, {0x15, 0x0162}, {0x6a, 0x0165}, {0x15, 0x0164}, {0x6a, 0x0167}, {0x15, 0x0166}, // 0160 - 0167
    {0x6a, 0x0169}, {0x15, 0x0168}, {0x6a, 0x016B}, {0x15, 0x016A}, {0x6a, 0x016D}, {0x15, 0x016C}, {0x6a, 0x016F}, {0x15, 0x016E}, // 0168 - 016f
    {0x6a, 0x0171}, {0x15, 0x0170}, {0x6a, 0x0173}, {0x15, 0x0172}, {0x6a, 0x0175}, {0x15, 0x0174}, {0x6a, 0x0177}, {0x15, 0x0176}, // 0170 - 0177
    {0x6a, 0x00FF}, {0x6a, 0x017A}, {0x15, 0x0179}, {0x6a, 0x017C}, {0x15, 0x017B}, {0x6a, 0x017E}, {0x15, 0x017D}, {0xf5, 0x0016}, // 0178 - 017f
    {0x00, 0x0000}, {0x6a, 0x0253}, {0x6a, 0x0183}, {0x15, 0x0182}, {0x6a, 0x0185}, {0x15, 0x0184}, {0x6a, 0x0254}, {0x6a, 0x0188}, // 0180 - 0187
    {0x15, 0x0187}, {0x6a, 0x0256}, {0x6a, 0x0257}, {0x6a, 0x018C}, {0x15, 0x018B}, {0x00, 0x0000}, {0x6a, 0x01DD}, {0x6a, 0x0259}, // 0188 - 018f
    {0x6a, 0x025B}, {0x6a, 0x0192}, {0x15, 0x0191}, {0x6a, 0x0260}, {0x6a, 0x0263}, {0x15, 0x01F6}, {0x6a, 0x0269}, {0x6a, 0x0268}, // 0190 - 0197
    {0x6a, 0x0199}, {0x15, 0x0198}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x026F}, {0x6a, 0x0272}, {0x00, 0x0000}, {0x6a, 0x0275}, // 0198 - 019f
    {0x6a, 0x01A1}, {0x15, 0x01A0}, {0x6a, 0x01A3}, {0x15, 0x01A2}, {0x6a, 0x01A5}, {0x15, 0x01A4}, {0x6a, 0x0280}, {0x6a, 0x01A8}, // 01a0 - 01a7
    {0x15, 0x01A7}, {0x6a, 0x0283}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x01AD}, {0x15, 0x01AC}, {0x6a, 0x0288}, {0x6a, 0x01B0}, // 01a8 - 01af
    {0x15, 0x01AF}, {0x6a, 0x028A}, {0x6a, 0x028B}, {0x6a, 0x01B4}, {0x15, 0x01B3}, {0x6a, 0x01B6}, {0x15, 0x01B5}, {0x6a, 0x0292}, // 01b0 - 01b7
    {0x6a, 0x01B9}, {0x15, 0x01B8}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x01BD}, {0x15, 0x01BC}, {0x00, 0x0000}, {0x15, 0x01F7}, // 01b8 - 01bf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0xfa, 0x0018}, {0xec, 0x001A}, {0x95, 0x001C}, {0xfa, 0x001E}, // 01c0 - 01c7
    {0xec, 0x0020}, {0x95, 0x0022}, {0xfa, 0x0024}, {0xec, 0x0026}, {0x95, 0x0028}, {0x6a, 0x01CE}, {0x15, 0x01CD}, {0x6a, 0x01D0}, // 01c8 - 01cf
    {0x15, 0x01CF}, {0x6a, 0x01D2}, {0x15, 0x01D1}, {0x6a, 0x01D4}, {0x15, 0x01D3}, {0x6a, 0x01D6}, {0x15, 0x01D5}, {0x6a, 0x01D8}, // 01d0 - 01d7
    {0x15, 0x01D7}, {0x6a, 0x01DA}, {0x15, 0x01D9}, {0x6a, 0x01DC}, {0x15, 0x01DB}, {0x15, 0x018E}, {0x6a, 0x01DF}, {0x15, 0x01DE}, // 01d8 - 01df
    {0x6a, 0x01E1}, {0x15, 0x01E0}, {0x6a, 0x01E3}, {0x15, 0x01E2}, {0x6a, 0x01E5}, {0x15, 0x01E4}, {0x6a, 0x01E7}, {0x15, 0x01E6}, // 01e0 - 01e7
    {0x6a, 0x01E9}, {0x15, 0x01E8}, {0x6a, 0x01EB}, {0x15, 0x01EA}, {0x6a, 0x01ED}, {0x15, 0x01EC}, {0x6a, 0x01EF}, {0x15, 0x01EE}, // 01e8 - 01ef
    {0xd5, 0x002A}, {0xfa, 0x002C}, {0xec, 0x002E}, {0x95, 0x0030}, {0x6a, 0x01F5}, {0x15, 0x01F4}, {0x6a, 0x0195}, {0x6a, 0x01BF}, // 01f0 - 01f7
    {0x6a, 0x01F9}, {0x15, 0x01F8}, {0x6a, 0x01FB}, {0x15, 0x01FA}, {0x6a, 0x01FD}, {0x15, 0x01FC}, {0x6a, 0x01FF}, {0x15, 0x01FE}, // 01f8 - 01ff

    {0x6a, 0x0201}, {0x15, 0x0200}, {0x6a, 0x0203}, {0x15, 0x0202}, {0x6a, 0x0205}, {0x15, 0x0204}, {0x6a, 0x0207}, {0x15, 0x0206}, // 0200 - 0207
    {0x6a, 0x0209}, {0x15, 0x0208}, {0x6a, 0x020B}, {0x15, 0x020A}, {0x6a, 0x020D}, {0x15, 0x020C}, {0x6a, 0x020F}, {0x15, 0x020E}, // 0208 - 020f
    {0x6a, 0x0211}, {0x15, 0x0210}, {0x6a, 0x0213}, {0x15, 0x0212}, {0x6a, 0x0215}, {0x15, 0x0214}, {0x6a, 0x0217}, {0x15, 0x0216}, // 0210 - 0217
    {0x6a, 0x0219}, {0x15, 0x0218}, {0x6a, 0x021B}, {0x15, 0x021A}, {0x6a, 0x021D}, {0x15, 0x021C}, {0x6a, 0x021F}, {0x15, 0x021E}, // 0218 - 021f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x0223}, {0x15, 0x0222}, {0x6a, 0x0225}, {0x15, 0x0224}, {0x6a, 0x0227}, {0x15, 0x0226}, // 0220 - 0227
    {0x6a, 0x0229}, {0x15, 0x0228}, {0x6a, 0x022B}, {0x15, 0x022A}, {0x6a, 0x022D}, {0x15, 0x022C}, {0x6a, 0x022F}, {0x15, 0x022E}, // 0228 - 022f
    {0x6a, 0x0231}, {0x15, 0x0230}, {0x6a, 0x0233}, {0x15, 0x0232}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0230 - 0237
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0238 - 023f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0240 - 0247
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0248 - 024f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x0181}, {0x15, 0x0186}, {0x00, 0x0000}, {0x15, 0x0189}, {0x15, 0x018A}, // 0250 - 0257
    {0x00, 0x0000}, {0x15, 0x018F}, {0x00, 0x0000}, {0x15, 0x0190}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0258 - 025f
    {0x15, 0x0193}, {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x0194}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0260 - 0267
    {0x15, 0x0197}, {0x15, 0x0196}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x019C}, // 0268 - 026f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x019D}, {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x019F}, {0x00, 0x0000}, {0x00, 0x0000}, // 0270 - 0277
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0278 - 027f
    {0x15, 0x01A6}, {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x01A9}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0280 - 0287
    {0x15, 0x01AE}, {0x00, 0x0000}, {0x15, 0x01B1}, {0x15, 0x01B2}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0288 - 028f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x15, 0x01B7}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0290 - 0297
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0298 - 029f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02a0 - 02a7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02a8 - 02af
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02b0 - 02b7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02b8 - 02bf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02c0 - 02c7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02c8 - 02cf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02d0 - 02d7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02d8 - 02df
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02e0 - 02e7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02e8 - 02ef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02f0 - 02f7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 02f8 - 02ff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x9f, 0x0000}, // 0300 - 0307
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0308 - 030f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0310 - 0317
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0318 - 031f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0320 - 0327
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0328 - 032f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0330 - 0337
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0338 - 033f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0xf4, 0x0032}, {0x00, 0x0000}, {0x00, 0x0000}, // 0340 - 0347
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0348 - 034f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0350 - 0357
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0358 - 035f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0360 - 0367
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0368 - 036f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0370 - 0377
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0378 - 037f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x03AC}, {0x00, 0x0000}, // 0380 - 0387
    {0x6a, 0x03AD}, {0x6a, 0x03AE}, {0x6a, 0x03AF}, {0x00, 0x0000}, {0x6a, 0x03CC}, {0x00, 0x0000}, {0x6a, 0x03CD}, {0x6a, 0x03CE}, // 0388 - 038f
    {0xd5, 0x0034}, {0x6a, 0x03B1}, {0x6a, 0x03B2}, {0x6a, 0x03B3}, {0x6a, 0x03B4}, {0x6a, 0x03B5}, {0x6a, 0x03B6}, {0x6a, 0x03B7}, // 0390 - 0397
    {0x6a, 0x03B8}, {0x6a, 0x03B9}, {0x6a, 0x03BA}, {0x6a, 0x03BB}, {0x6a, 0x03BC}, {0x6a, 0x03BD}, {0x6a, 0x03BE}, {0x6a, 0x03BF}, // 0398 - 039f
    {0x6a, 0x03C0}, {0x6a, 0x03C1}, {0x00, 0x0000}, {0xea, 0x0036}, {0x6a, 0x03C4}, {0x6a, 0x03C5}, {0x6a, 0x03C6}, {0x6a, 0x03C7}, // 03a0 - 03a7
    {0x6a, 0x03C8}, {0x6a, 0x03C9}, {0x6a, 0x03CA}, {0x6a, 0x03CB}, {0x15, 0x0386}, {0x15, 0x0388}, {0x15, 0x0389}, {0x15, 0x038A}, // 03a8 - 03af
    {0xd5, 0x0038}, {0x15, 0x0391}, {0x15, 0x0392}, {0x15, 0x0393}, {0x15, 0x0394}, {0x15, 0x0395}, {0x15, 0x0396}, {0x15, 0x0397}, // 03b0 - 03b7
    {0x15, 0x0398}, {0x15, 0x0399}, {0x15, 0x039A}, {0x15, 0x039B}, {0x15, 0x039C}, {0x15, 0x039D}, {0x15, 0x039E}, {0x15, 0x039F}, // 03b8 - 03bf
    {0x15, 0x03A0}, {0x15, 0x03A1}, {0xf5, 0x003A}, {0x15, 0x03A3}, {0x15, 0x03A4}, {0x15, 0x03A5}, {0x15, 0x03A6}, {0x15, 0x03A7}, // 03c0 - 03c7
    {0x15, 0x03A8}, {0x15, 0x03A9}, {0x15, 0x03AA}, {0x15, 0x03AB}, {0x15, 0x038C}, {0x15, 0x038E}, {0x15, 0x038F}, {0x00, 0x0000}, // 03c8 - 03cf
    {0xf5, 0x003C}, {0xf5, 0x003E}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0xf5, 0x0040}, {0xf5, 0x0042}, {0x00, 0x0000}, // 03d0 - 03d7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x03DB}, {0x15, 0x03DA}, {0x6a, 0x03DD}, {0x15, 0x03DC}, {0x6a, 0x03DF}, {0x15, 0x03DE}, // 03d8 - 03df
    {0x6a, 0x03E1}, {0x15, 0x03E0}, {0x6a, 0x03E3}, {0x15, 0x03E2}, {0x6a, 0x03E5}, {0x15, 0x03E4}, {0x6a, 0x03E7}, {0x15, 0x03E6}, // 03e0 - 03e7
    {0x6a, 0x03E9}, {0x15, 0x03E8}, {0x6a, 0x03EB}, {0x15, 0x03EA}, {0x6a, 0x03ED}, {0x15, 0x03EC}, {0x6a, 0x03EF}, {0x15, 0x03EE}, // 03e8 - 03ef
    {0xf5, 0x0044}, {0xf5, 0x0046}, {0xf5, 0x0048}, {0x00, 0x0000}, {0x6a, 0x03B8}, {0xf5, 0x004A}, {0x00, 0x0000}, {0x00, 0x0000}, // 03f0 - 03f7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 03f8 - 03ff

    {0x6a, 0x0450}, {0x6a, 0x0451}, {0x6a, 0x0452}, {0x6a, 0x0453}, {0x6a, 0x0454}, {0x6a, 0x0455}, {0x6a, 0x0456}, {0x6a, 0x0457}, // 0400 - 0407
    {0x6a, 0x0458}, {0x6a, 0x0459}, {0x6a, 0x045A}, {0x6a, 0x045B}, {0x6a, 0x045C}, {0x6a, 0x045D}, {0x6a, 0x045E}, {0x6a, 0x045F}, // 0408 - 040f
    {0x6a, 0x0430}, {0x6a, 0x0431}, {0x6a, 0x0432}, {0x6a, 0x0433}, {0x6a, 0x0434}, {0x6a, 0x0435}, {0x6a, 0x0436}, {0x6a, 0x0437}, // 0410 - 0417
    {0x6a, 0x0438}, {0x6a, 0x0439}, {0x6a, 0x043A}, {0x6a, 0x043B}, {0x6a, 0x043C}, {0x6a, 0x043D}, {0x6a, 0x043E}, {0x6a, 0x043F}, // 0418 - 041f
    {0x6a, 0x0440}, {0x6a, 0x0441}, {0x6a, 0x0442}, {0x6a, 0x0443}, {0x6a, 0x0444}, {0x6a, 0x0445}, {0x6a, 0x0446}, {0x6a, 0x0447}, // 0420 - 0427
    {0x6a, 0x0448}, {0x6a, 0x0449}, {0x6a, 0x044A}, {0x6a, 0x044B}, {0x6a, 0x044C}, {0x6a, 0x044D}, {0x6a, 0x044E}, {0x6a, 0x044F}, // 0428 - 042f
    {0x15, 0x0410}, {0x15, 0x0411}, {0x15, 0x0412}, {0x15, 0x0413}, {0x15, 0x0414}, {0x15, 0x0415}, {0x15, 0x0416}, {0x15, 0x0417}, // 0430 - 0437
    {0x15, 0x0418}, {0x15, 0x0419}, {0x15, 0x041A}, {0x15, 0x041B}, {0x15, 0x041C}, {0x15, 0x041D}, {0x15, 0x041E}, {0x15, 0x041F}, // 0438 - 043f
    {0x15, 0x0420}, {0x15, 0x0421}, {0x15, 0x0422}, {0x15, 0x0423}, {0x15, 0x0424}, {0x15, 0x0425}, {0x15, 0x0426}, {0x15, 0x0427}, // 0440 - 0447
    {0x15, 0x0428}, {0x15, 0x0429}, {0x15, 0x042A}, {0x15, 0x042B}, {0x15, 0x042C}, {0x15, 0x042D}, {0x15, 0x042E}, {0x15, 0x042F}, // 0448 - 044f
    {0x15, 0x0400}, {0x15, 0x0401}, {0x15, 0x0402}, {0x15, 0x0403}, {0x15, 0x0404}, {0x15, 0x0405}, {0x15, 0x0406}, {0x15, 0x0407}, // 0450 - 0457
    {0x15, 0x0408}, {0x15, 0x0409}, {0x15, 0x040A}, {0x15, 0x040B}, {0x15, 0x040C}, {0x15, 0x040D}, {0x15, 0x040E}, {0x15, 0x040F}, // 0458 - 045f
    {0x6a, 0x0461}, {0x15, 0x0460}, {0x6a, 0x0463}, {0x15, 0x0462}, {0x6a, 0x0465}, {0x15, 0x0464}, {0x6a, 0x0467}, {0x15, 0x0466}, // 0460 - 0467
    {0x6a, 0x0469}, {0x15, 0x0468}, {0x6a, 0x046B}, {0x15, 0x046A}, {0x6a, 0x046D}, {0x15, 0x046C}, {0x6a, 0x046F}, {0x15, 0x046E}, // 0468 - 046f
    {0x6a, 0x0471}, {0x15, 0x0470}, {0x6a, 0x0473}, {0x15, 0x0472}, {0x6a, 0x0475}, {0x15, 0x0474}, {0x6a, 0x0477}, {0x15, 0x0476}, // 0470 - 0477
    {0x6a, 0x0479}, {0x15, 0x0478}, {0x6a, 0x047B}, {0x15, 0x047A}, {0x6a, 0x047D}, {0x15, 0x047C}, {0x6a, 0x047F}, {0x15, 0x047E}, // 0478 - 047f
    {0x6a, 0x0481}, {0x15, 0x0480}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0480 - 0487
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x048D}, {0x15, 0x048C}, {0x6a, 0x048F}, {0x15, 0x048E}, // 0488 - 048f
    {0x6a, 0x0491}, {0x15, 0x0490}, {0x6a, 0x0493}, {0x15, 0x0492}, {0x6a, 0x0495}, {0x15, 0x0494}, {0x6a, 0x0497}, {0x15, 0x0496}, // 0490 - 0497
    {0x6a, 0x0499}, {0x15, 0x0498}, {0x6a, 0x049B}, {0x15, 0x049A}, {0x6a, 0x049D}, {0x15, 0x049C}, {0x6a, 0x049F}, {0x15, 0x049E}, // 0498 - 049f
    {0x6a, 0x04A1}, {0x15, 0x04A0}, {0x6a, 0x04A3}, {0x15, 0x04A2}, {0x6a, 0x04A5}, {0x15, 0x04A4}, {0x6a, 0x04A7}, {0x15, 0x04A6}, // 04a0 - 04a7
    {0x6a, 0x04A9}, {0x15, 0x04A8}, {0x6a, 0x04AB}, {0x15, 0x04AA}, {0x6a, 0x04AD}, {0x15, 0x04AC}, {0x6a, 0x04AF}, {0x15, 0x04AE}, // 04a8 - 04af
    {0x6a, 0x04B1}, {0x15, 0x04B0}, {0x6a, 0x04B3}, {0x15, 0x04B2}, {0x6a, 0x04B5}, {0x15, 0x04B4}, {0x6a, 0x04B7}, {0x15, 0x04B6}, // 04b0 - 04b7
    {0x6a, 0x04B9}, {0x15, 0x04B8}, {0x6a, 0x04BB}, {0x15, 0x04BA}, {0x6a, 0x04BD}, {0x15, 0x04BC}, {0x6a, 0x04BF}, {0x15, 0x04BE}, // 04b8 - 04bf
    {0x00, 0x0000}, {0x6a, 0x04C2}, {0x15, 0x04C1}, {0x6a, 0x04C4}, {0x15, 0x04C3}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x04C8}, // 04c0 - 04c7
    {0x15, 0x04C7}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x04CC}, {0x15, 0x04CB}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 04c8 - 04cf
    {0x6a, 0x04D1}, {0x15, 0x04D0}, {0x6a, 0x04D3}, {0x15, 0x04D2}, {0x6a, 0x04D5}, {0x15, 0x04D4}, {0x6a, 0x04D7}, {0x15, 0x04D6}, // 04d0 - 04d7
    {0x6a, 0x04D9}, {0x15, 0x04D8}, {0x6a, 0x04DB}, {0x15, 0x04DA}, {0x6a, 0x04DD}, {0x15, 0x04DC}, {0x6a, 0x04DF}, {0x15, 0x04DE}, // 04d8 - 04df
    {0x6a, 0x04E1}, {0x15, 0x04E0}, {0x6a, 0x04E3}, {0x15, 0x04E2}, {0x6a, 0x04E5}, {0x15, 0x04E4}, {0x6a, 0x04E7}, {0x15, 0x04E6}, // 04e0 - 04e7
    {0x6a, 0x04E9}, {0x15, 0x04E8}, {0x6a, 0x04EB}, {0x15, 0x04EA}, {0x6a, 0x04ED}, {0x15, 0x04EC}, {0x6a, 0x04EF}, {0x15, 0x04EE}, // 04e8 - 04ef
    {0x6a, 0x04F1}, {0x15, 0x04F0}, {0x6a, 0x04F3}, {0x15, 0x04F2}, {0x6a, 0x04F5}, {0x15, 0x04F4}, {0x00, 0x0000}, {0x00, 0x0000}, // 04f0 - 04f7
    {0x6a, 0x04F9}, {0x15, 0x04F8}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 04f8 - 04ff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0500 - 0507
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0508 - 050f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0510 - 0517
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0518 - 051f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0520 - 0527
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0528 - 052f
    {0x00, 0x0000}, {0x6a, 0x0561}, {0x6a, 0x0562}, {0x6a, 0x0563}, {0x6a, 0x0564}, {0x6a, 0x0565}, {0x6a, 0x0566}, {0x6a, 0x0567}, // 0530 - 0537
    {0x6a, 0x0568}, {0x6a, 0x0569}, {0x6a, 0x056A}, {0x6a, 0x056B}, {0x6a, 0x056C}, {0x6a, 0x056D}, {0x6a, 0x056E}, {0x6a, 0x056F}, // 0538 - 053f
    {0x6a, 0x0570}, {0x6a, 0x0571}, {0x6a, 0x0572}, {0x6a, 0x0573}, {0x6a, 0x0574}, {0x6a, 0x0575}, {0x6a, 0x0576}, {0x6a, 0x0577}, // 0540 - 0547
    {0x6a, 0x0578}, {0x6a, 0x0579}, {0x6a, 0x057A}, {0x6a, 0x057B}, {0x6a, 0x057C}, {0x6a, 0x057D}, {0x6a, 0x057E}, {0x6a, 0x057F}, // 0548 - 054f
    {0x6a, 0x0580}, {0x6a, 0x0581}, {0x6a, 0x0582}, {0x6a, 0x0583}, {0x6a, 0x0584}, {0x6a, 0x0585}, {0x6a, 0x0586}, {0x00, 0x0000}, // 0550 - 0557
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0558 - 055f
    {0x00, 0x0000}, {0x15, 0x0531}, {0x15, 0x0532}, {0x15, 0x0533}, {0x15, 0x0534}, {0x15, 0x0535}, {0x15, 0x0536}, {0x15, 0x0537}, // 0560 - 0567
    {0x15, 0x0538}, {0x15, 0x0539}, {0x15, 0x053A}, {0x15, 0x053B}, {0x15, 0x053C}, {0x15, 0x053D}, {0x15, 0x053E}, {0x15, 0x053F}, // 0568 - 056f
    {0x15, 0x0540}, {0x15, 0x0541}, {0x15, 0x0542}, {0x15, 0x0543}, {0x15, 0x0544}, {0x15, 0x0545}, {0x15, 0x0546}, {0x15, 0x0547}, // 0570 - 0577
    {0x15, 0x0548}, {0x15, 0x0549}, {0x15, 0x054A}, {0x15, 0x054B}, {0x15, 0x054C}, {0x15, 0x054D}, {0x15, 0x054E}, {0x15, 0x054F}, // 0578 - 057f
    {0x15, 0x0550}, {0x15, 0x0551}, {0x15, 0x0552}, {0x15, 0x0553}, {0x15, 0x0554}, {0x15, 0x0555}, {0x15, 0x0556}, {0xd5, 0x004C}, // 0580 - 0587
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0588 - 058f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0590 - 0597
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 0598 - 059f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05a0 - 05a7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05a8 - 05af
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05b0 - 05b7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05b8 - 05bf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05c0 - 05c7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05c8 - 05cf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05d0 - 05d7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05d8 - 05df
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05e0 - 05e7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05e8 - 05ef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05f0 - 05f7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 05f8 - 05ff

    {0x6a, 0x1E01}, {0x15, 0x1E00}, {0x6a, 0x1E03}, {0x15, 0x1E02}, {0x6a, 0x1E05}, {0x15, 0x1E04}, {0x6a, 0x1E07}, {0x15, 0x1E06}, // 1e00 - 1e07
    {0x6a, 0x1E09}, {0x15, 0x1E08}, {0x6a, 0x1E0B}, {0x15, 0x1E0A}, {0x6a, 0x1E0D}, {0x15, 0x1E0C}, {0x6a, 0x1E0F}, {0x15, 0x1E0E}, // 1e08 - 1e0f
    {0x6a, 0x1E11}, {0x15, 0x1E10}, {0x6a, 0x1E13}, {0x15, 0x1E12}, {0x6a, 0x1E15}, {0x15, 0x1E14}, {0x6a, 0x1E17}, {0x15, 0x1E16}, // 1e10 - 1e17
    {0x6a, 0x1E19}, {0x15, 0x1E18}, {0x6a, 0x1E1B}, {0x15, 0x1E1A}, {0x6a, 0x1E1D}, {0x15, 0x1E1C}, {0x6a, 0x1E1F}, {0x15, 0x1E1E}, // 1e18 - 1e1f
    {0x6a, 0x1E21}, {0x15, 0x1E20}, {0x6a, 0x1E23}, {0x15, 0x1E22}, {0x6a, 0x1E25}, {0x15, 0x1E24}, {0x6a, 0x1E27}, {0x15, 0x1E26}, // 1e20 - 1e27
    {0x6a, 0x1E29}, {0x15, 0x1E28}, {0x6a, 0x1E2B}, {0x15, 0x1E2A}, {0x6a, 0x1E2D}, {0x15, 0x1E2C}, {0x6a, 0x1E2F}, {0x15, 0x1E2E}, // 1e28 - 1e2f
    {0x6a, 0x1E31}, {0x15, 0x1E30}, {0x6a, 0x1E33}, {0x15, 0x1E32}, {0x6a, 0x1E35}, {0x15, 0x1E34}, {0x6a, 0x1E37}, {0x15, 0x1E36}, // 1e30 - 1e37
    {0x6a, 0x1E39}, {0x15, 0x1E38}, {0x6a, 0x1E3B}, {0x15, 0x1E3A}, {0x6a, 0x1E3D}, {0x15, 0x1E3C}, {0x6a, 0x1E3F}, {0x15, 0x1E3E}, // 1e38 - 1e3f
    {0x6a, 0x1E41}, {0x15, 0x1E40}, {0x6a, 0x1E43}, {0x15, 0x1E42}, {0x6a, 0x1E45}, {0x15, 0x1E44}, {0x6a, 0x1E47}, {0x15, 0x1E46}, // 1e40 - 1e47
    {0x6a, 0x1E49}, {0x15, 0x1E48}, {0x6a, 0x1E4B}, {0x15, 0x1E4A}, {0x6a, 0x1E4D}, {0x15, 0x1E4C}, {0x6a, 0x1E4F}, {0x15, 0x1E4E}, // 1e48 - 1e4f
    {0x6a, 0x1E51}, {0x15, 0x1E50}, {0x6a, 0x1E53}, {0x15, 0x1E52}, {0x6a, 0x1E55}, {0x15, 0x1E54}, {0x6a, 0x1E57}, {0x15, 0x1E56}, // 1e50 - 1e57
    {0x6a, 0x1E59}, {0x15, 0x1E58}, {0x6a, 0x1E5B}, {0x15, 0x1E5A}, {0x6a, 0x1E5D}, {0x15, 0x1E5C}, {0x6a, 0x1E5F}, {0x15, 0x1E5E}, // 1e58 - 1e5f
    {0x6a, 0x1E61}, {0x15, 0x1E60}, {0x6a, 0x1E63}, {0x15, 0x1E62}, {0x6a, 0x1E65}, {0x15, 0x1E64}, {0x6a, 0x1E67}, {0x15, 0x1E66}, // 1e60 - 1e67
    {0x6a, 0x1E69}, {0x15, 0x1E68}, {0x6a, 0x1E6B}, {0x15, 0x1E6A}, {0x6a, 0x1E6D}, {0x15, 0x1E6C}, {0x6a, 0x1E6F}, {0x15, 0x1E6E}, // 1e68 - 1e6f
    {0x6a, 0x1E71}, {0x15, 0x1E70}, {0x6a, 0x1E73}, {0x15, 0x1E72}, {0x6a, 0x1E75}, {0x15, 0x1E74}, {0x6a, 0x1E77}, {0x15, 0x1E76}, // 1e70 - 1e77
    {0x6a, 0x1E79}, {0x15, 0x1E78}, {0x6a, 0x1E7B}, {0x15, 0x1E7A}, {0x6a, 0x1E7D}, {0x15, 0x1E7C}, {0x6a, 0x1E7F}, {0x15, 0x1E7E}, // 1e78 - 1e7f
    {0x6a, 0x1E81}, {0x15, 0x1E80}, {0x6a, 0x1E83}, {0x15, 0x1E82}, {0x6a, 0x1E85}, {0x15, 0x1E84}, {0x6a, 0x1E87}, {0x15, 0x1E86}, // 1e80 - 1e87
    {0x6a, 0x1E89}, {0x15, 0x1E88}, {0x6a, 0x1E8B}, {0x15, 0x1E8A}, {0x6a, 0x1E8D}, {0x15, 0x1E8C}, {0x6a, 0x1E8F}, {0x15, 0x1E8E}, // 1e88 - 1e8f
    {0x6a, 0x1E91}, {0x15, 0x1E90}, {0x6a, 0x1E93}, {0x15, 0x1E92}, {0x6a, 0x1E95}, {0x15, 0x1E94}, {0xd5, 0x004F}, {0xd5, 0x0051}, // 1e90 - 1e97
    {0xd5, 0x0053}, {0xd5, 0x0055}, {0xd5, 0x0057}, {0xf5, 0x0059}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1e98 - 1e9f
    {0x6a, 0x1EA1}, {0x15, 0x1EA0}, {0x6a, 0x1EA3}, {0x15, 0x1EA2}, {0x6a, 0x1EA5}, {0x15, 0x1EA4}, {0x6a, 0x1EA7}, {0x15, 0x1EA6}, // 1ea0 - 1ea7
    {0x6a, 0x1EA9}, {0x15, 0x1EA8}, {0x6a, 0x1EAB}, {0x15, 0x1EAA}, {0x6a, 0x1EAD}, {0x15, 0x1EAC}, {0x6a, 0x1EAF}, {0x15, 0x1EAE}, // 1ea8 - 1eaf
    {0x6a, 0x1EB1}, {0x15, 0x1EB0}, {0x6a, 0x1EB3}, {0x15, 0x1EB2}, {0x6a, 0x1EB5}, {0x15, 0x1EB4}, {0x6a, 0x1EB7}, {0x15, 0x1EB6}, // 1eb0 - 1eb7
    {0x6a, 0x1EB9}, {0x15, 0x1EB8}, {0x6a, 0x1EBB}, {0x15, 0x1EBA}, {0x6a, 0x1EBD}, {0x15, 0x1EBC}, {0x6a, 0x1EBF}, {0x15, 0x1EBE}, // 1eb8 - 1ebf
    {0x6a, 0x1EC1}, {0x15, 0x1EC0}, {0x6a, 0x1EC3}, {0x15, 0x1EC2}, {0x6a, 0x1EC5}, {0x15, 0x1EC4}, {0x6a, 0x1EC7}, {0x15, 0x1EC6}, // 1ec0 - 1ec7
    {0x6a, 0x1EC9}, {0x15, 0x1EC8}, {0x6a, 0x1ECB}, {0x15, 0x1ECA}, {0x6a, 0x1ECD}, {0x15, 0x1ECC}, {0x6a, 0x1ECF}, {0x15, 0x1ECE}, // 1ec8 - 1ecf
    {0x6a, 0x1ED1}, {0x15, 0x1ED0}, {0x6a, 0x1ED3}, {0x15, 0x1ED2}, {0x6a, 0x1ED5}, {0x15, 0x1ED4}, {0x6a, 0x1ED7}, {0x15, 0x1ED6}, // 1ed0 - 1ed7
    {0x6a, 0x1ED9}, {0x15, 0x1ED8}, {0x6a, 0x1EDB}, {0x15, 0x1EDA}, {0x6a, 0x1EDD}, {0x15, 0x1EDC}, {0x6a, 0x1EDF}, {0x15, 0x1EDE}, // 1ed8 - 1edf
    {0x6a, 0x1EE1}, {0x15, 0x1EE0}, {0x6a, 0x1EE3}, {0x15, 0x1EE2}, {0x6a, 0x1EE5}, {0x15, 0x1EE4}, {0x6a, 0x1EE7}, {0x15, 0x1EE6}, // 1ee0 - 1ee7
    {0x6a, 0x1EE9}, {0x15, 0x1EE8}, {0x6a, 0x1EEB}, {0x15, 0x1EEA}, {0x6a, 0x1EED}, {0x15, 0x1EEC}, {0x6a, 0x1EEF}, {0x15, 0x1EEE}, // 1ee8 - 1eef
    {0x6a, 0x1EF1}, {0x15, 0x1EF0}, {0x6a, 0x1EF3}, {0x15, 0x1EF2}, {0x6a, 0x1EF5}, {0x15, 0x1EF4}, {0x6a, 0x1EF7}, {0x15, 0x1EF6}, // 1ef0 - 1ef7
    {0x6a, 0x1EF9}, {0x15, 0x1EF8}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1ef8 - 1eff

    {0x15, 0x1F08}, {0x15, 0x1F09}, {0x15, 0x1F0A}, {0x15, 0x1F0B}, {0x15, 0x1F0C}, {0x15, 0x1F0D}, {0x15, 0x1F0E}, {0x15, 0x1F0F}, // 1f00 - 1f07
    {0x6a, 0x1F00}, {0x6a, 0x1F01}, {0x6a, 0x1F02}, {0x6a, 0x1F03}, {0x6a, 0x1F04}, {0x6a, 0x1F05}, {0x6a, 0x1F06}, {0x6a, 0x1F07}, // 1f08 - 1f0f
    {0x15, 0x1F18}, {0x15, 0x1F19}, {0x15, 0x1F1A}, {0x15, 0x1F1B}, {0x15, 0x1F1C}, {0x15, 0x1F1D}, {0x00, 0x0000}, {0x00, 0x0000}, // 1f10 - 1f17
    {0x6a, 0x1F10}, {0x6a, 0x1F11}, {0x6a, 0x1F12}, {0x6a, 0x1F13}, {0x6a, 0x1F14}, {0x6a, 0x1F15}, {0x00, 0x0000}, {0x00, 0x0000}, // 1f18 - 1f1f
    {0x15, 0x1F28}, {0x15, 0x1F29}, {0x15, 0x1F2A}, {0x15, 0x1F2B}, {0x15, 0x1F2C}, {0x15, 0x1F2D}, {0x15, 0x1F2E}, {0x15, 0x1F2F}, // 1f20 - 1f27
    {0x6a, 0x1F20}, {0x6a, 0x1F21}, {0x6a, 0x1F22}, {0x6a, 0x1F23}, {0x6a, 0x1F24}, {0x6a, 0x1F25}, {0x6a, 0x1F26}, {0x6a, 0x1F27}, // 1f28 - 1f2f
    {0x15, 0x1F38}, {0x15, 0x1F39}, {0x15, 0x1F3A}, {0x15, 0x1F3B}, {0x15, 0x1F3C}, {0x15, 0x1F3D}, {0x15, 0x1F3E}, {0x15, 0x1F3F}, // 1f30 - 1f37
    {0x6a, 0x1F30}, {0x6a, 0x1F31}, {0x6a, 0x1F32}, {0x6a, 0x1F33}, {0x6a, 0x1F34}, {0x6a, 0x1F35}, {0x6a, 0x1F36}, {0x6a, 0x1F37}, // 1f38 - 1f3f
    {0x15, 0x1F48}, {0x15, 0x1F49}, {0x15, 0x1F4A}, {0x15, 0x1F4B}, {0x15, 0x1F4C}, {0x15, 0x1F4D}, {0x00, 0x0000}, {0x00, 0x0000}, // 1f40 - 1f47
    {0x6a, 0x1F40}, {0x6a, 0x1F41}, {0x6a, 0x1F42}, {0x6a, 0x1F43}, {0x6a, 0x1F44}, {0x6a, 0x1F45}, {0x00, 0x0000}, {0x00, 0x0000}, // 1f48 - 1f4f
    {0xd5, 0x005B}, {0x15, 0x1F59}, {0xd5, 0x005D}, {0x15, 0x1F5B}, {0xd5, 0x005F}, {0x15, 0x1F5D}, {0xd5, 0x0061}, {0x15, 0x1F5F}, // 1f50 - 1f57
    {0x00, 0x0000}, {0x6a, 0x1F51}, {0x00, 0x0000}, {0x6a, 0x1F53}, {0x00, 0x0000}, {0x6a, 0x1F55}, {0x00, 0x0000}, {0x6a, 0x1F57}, // 1f58 - 1f5f
    {0x15, 0x1F68}, {0x15, 0x1F69}, {0x15, 0x1F6A}, {0x15, 0x1F6B}, {0x15, 0x1F6C}, {0x15, 0x1F6D}, {0x15, 0x1F6E}, {0x15, 0x1F6F}, // 1f60 - 1f67
    {0x6a, 0x1F60}, {0x6a, 0x1F61}, {0x6a, 0x1F62}, {0x6a, 0x1F63}, {0x6a, 0x1F64}, {0x6a, 0x1F65}, {0x6a, 0x1F66}, {0x6a, 0x1F67}, // 1f68 - 1f6f
    {0x15, 0x1FBA}, {0x15, 0x1FBB}, {0x15, 0x1FC8}, {0x15, 0x1FC9}, {0x15, 0x1FCA}, {0x15, 0x1FCB}, {0x15, 0x1FDA}, {0x15, 0x1FDB}, // 1f70 - 1f77
    {0x15, 0x1FF8}, {0x15, 0x1FF9}, {0x15, 0x1FEA}, {0x15, 0x1FEB}, {0x15, 0x1FFA}, {0x15, 0x1FFB}, {0x00, 0x0000}, {0x00, 0x0000}, // 1f78 - 1f7f
    {0xd5, 0x0063}, {0xd5, 0x0066}, {0xd5, 0x0069}, {0xd5, 0x006C}, {0xd5, 0x006F}, {0xd5, 0x0072}, {0xd5, 0x0075}, {0xd5, 0x0078}, // 1f80 - 1f87
    {0xec, 0x007B}, {0xec, 0x007E}, {0xec, 0x0081}, {0xec, 0x0084}, {0xec, 0x0087}, {0xec, 0x008A}, {0xec, 0x008D}, {0xec, 0x0090}, // 1f88 - 1f8f
    {0xd5, 0x0093}, {0xd5, 0x0096}, {0xd5, 0x0099}, {0xd5, 0x009C}, {0xd5, 0x009F}, {0xd5, 0x00A2}, {0xd5, 0x00A5}, {0xd5, 0x00A8}, // 1f90 - 1f97
    {0xec, 0x00AB}, {0xec, 0x00AE}, {0xec, 0x00B1}, {0xec, 0x00B4}, {0xec, 0x00B7}, {0xec, 0x00BA}, {0xec, 0x00BD}, {0xec, 0x00C0}, // 1f98 - 1f9f
    {0xd5, 0x00C3}, {0xd5, 0x00C6}, {0xd5, 0x00C9}, {0xd5, 0x00CC}, {0xd5, 0x00CF}, {0xd5, 0x00D2}, {0xd5, 0x00D5}, {0xd5, 0x00D8}, // 1fa0 - 1fa7
    {0xec, 0x00DB}, {0xec, 0x00DE}, {0xec, 0x00E1}, {0xec, 0x00E4}, {0xec, 0x00E7}, {0xec, 0x00EA}, {0xec, 0x00ED}, {0xec, 0x00F0}, // 1fa8 - 1faf
    {0x15, 0x1FB8}, {0x15, 0x1FB9}, {0xd5, 0x00F3}, {0xd5, 0x00F6}, {0xd5, 0x00F9}, {0x00, 0x0000}, {0xd5, 0x00FC}, {0xd5, 0x00FE}, // 1fb0 - 1fb7
    {0x6a, 0x1FB0}, {0x6a, 0x1FB1}, {0x6a, 0x1F70}, {0x6a, 0x1F71}, {0xec, 0x0101}, {0x00, 0x0000}, {0xf5, 0x0104}, {0x00, 0x0000}, // 1fb8 - 1fbf
    {0x00, 0x0000}, {0x00, 0x0000}, {0xd5, 0x0106}, {0xd5, 0x0109}, {0xd5, 0x010C}, {0x00, 0x0000}, {0xd5, 0x010F}, {0xd5, 0x0111}, // 1fc0 - 1fc7
    {0x6a, 0x1F72}, {0x6a, 0x1F73}, {0x6a, 0x1F74}, {0x6a, 0x1F75}, {0xec, 0x0114}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1fc8 - 1fcf
    {0x15, 0x1FD8}, {0x15, 0x1FD9}, {0xd5, 0x0117}, {0xd5, 0x0119}, {0x00, 0x0000}, {0x00, 0x0000}, {0xd5, 0x011B}, {0xd5, 0x011D}, // 1fd0 - 1fd7
    {0x6a, 0x1FD0}, {0x6a, 0x1FD1}, {0x6a, 0x1F76}, {0x6a, 0x1F77}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1fd8 - 1fdf
    {0x15, 0x1FE8}, {0x15, 0x1FE9}, {0xd5, 0x011F}, {0xd5, 0x0121}, {0xd5, 0x0123}, {0x15, 0x1FEC}, {0xd5, 0x0125}, {0xd5, 0x0127}, // 1fe0 - 1fe7
    {0x6a, 0x1FE0}, {0x6a, 0x1FE1}, {0x6a, 0x1F7A}, {0x6a, 0x1F7B}, {0x6a, 0x1FE5}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1fe8 - 1fef
    {0x00, 0x0000}, {0x00, 0x0000}, {0xd5, 0x0129}, {0xd5, 0x012C}, {0xd5, 0x012F}, {0x00, 0x0000}, {0xd5, 0x0132}, {0xd5, 0x0134}, // 1ff0 - 1ff7
    {0x6a, 0x1F78}, {0x6a, 0x1F79}, {0x6a, 0x1F7C}, {0x6a, 0x1F7D}, {0xec, 0x0137}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 1ff8 - 1fff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2100 - 2107
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2108 - 210f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2110 - 2117
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2118 - 211f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x03C9}, {0x00, 0x0000}, // 2120 - 2127
    {0x00, 0x0000}, {0x00, 0x0000}, {0x6a, 0x006B}, {0x6a, 0x00E5}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2128 - 212f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2130 - 2137
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2138 - 213f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2140 - 2147
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2148 - 214f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2150 - 2157
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2158 - 215f
    {0x68, 0x2170}, {0x68, 0x2171}, {0x68, 0x2172}, {0x68, 0x2173}, {0x68, 0x2174}, {0x68, 0x2175}, {0x68, 0x2176}, {0x68, 0x2177}, // 2160 - 2167
    {0x68, 0x2178}, {0x68, 0x2179}, {0x68, 0x217A}, {0x68, 0x217B}, {0x68, 0x217C}, {0x68, 0x217D}, {0x68, 0x217E}, {0x68, 0x217F}, // 2168 - 216f
    {0x14, 0x2160}, {0x14, 0x2161}, {0x14, 0x2162}, {0x14, 0x2163}, {0x14, 0x2164}, {0x14, 0x2165}, {0x14, 0x2166}, {0x14, 0x2167}, // 2170 - 2177
    {0x14, 0x2168}, {0x14, 0x2169}, {0x14, 0x216A}, {0x14, 0x216B}, {0x14, 0x216C}, {0x14, 0x216D}, {0x14, 0x216E}, {0x14, 0x216F}, // 2178 - 217f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2180 - 2187
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2188 - 218f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2190 - 2197
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2198 - 219f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21a0 - 21a7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21a8 - 21af
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21b0 - 21b7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21b8 - 21bf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21c0 - 21c7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21c8 - 21cf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21d0 - 21d7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21d8 - 21df
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21e0 - 21e7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21e8 - 21ef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21f0 - 21f7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 21f8 - 21ff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2400 - 2407
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2408 - 240f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2410 - 2417
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2418 - 241f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2420 - 2427
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2428 - 242f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2430 - 2437
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2438 - 243f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2440 - 2447
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2448 - 244f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2450 - 2457
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2458 - 245f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2460 - 2467
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2468 - 246f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2470 - 2477
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2478 - 247f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2480 - 2487
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2488 - 248f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2490 - 2497
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2498 - 249f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 24a0 - 24a7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 24a8 - 24af
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x68, 0x24D0}, {0x68, 0x24D1}, // 24b0 - 24b7
    {0x68, 0x24D2}, {0x68, 0x24D3}, {0x68, 0x24D4}, {0x68, 0x24D5}, {0x68, 0x24D6}, {0x68, 0x24D7}, {0x68, 0x24D8}, {0x68, 0x24D9}, // 24b8 - 24bf
    {0x68, 0x24DA}, {0x68, 0x24DB}, {0x68, 0x24DC}, {0x68, 0x24DD}, {0x68, 0x24DE}, {0x68, 0x24DF}, {0x68, 0x24E0}, {0x68, 0x24E1}, // 24c0 - 24c7
    {0x68, 0x24E2}, {0x68, 0x24E3}, {0x68, 0x24E4}, {0x68, 0x24E5}, {0x68, 0x24E6}, {0x68, 0x24E7}, {0x68, 0x24E8}, {0x68, 0x24E9}, // 24c8 - 24cf
    {0x14, 0x24B6}, {0x14, 0x24B7}, {0x14, 0x24B8}, {0x14, 0x24B9}, {0x14, 0x24BA}, {0x14, 0x24BB}, {0x14, 0x24BC}, {0x14, 0x24BD}, // 24d0 - 24d7
    {0x14, 0x24BE}, {0x14, 0x24BF}, {0x14, 0x24C0}, {0x14, 0x24C1}, {0x14, 0x24C2}, {0x14, 0x24C3}, {0x14, 0x24C4}, {0x14, 0x24C5}, // 24d8 - 24df
    {0x14, 0x24C6}, {0x14, 0x24C7}, {0x14, 0x24C8}, {0x14, 0x24C9}, {0x14, 0x24CA}, {0x14, 0x24CB}, {0x14, 0x24CC}, {0x14, 0x24CD}, // 24e0 - 24e7
    {0x14, 0x24CE}, {0x14, 0x24CF}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 24e8 - 24ef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 24f0 - 24f7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 24f8 - 24ff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c00 - 2c07
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c08 - 2c0f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c10 - 2c17
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c18 - 2c1f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c20 - 2c27
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c28 - 2c2f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c30 - 2c37
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c38 - 2c3f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c40 - 2c47
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c48 - 2c4f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c50 - 2c57
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c58 - 2c5f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c60 - 2c67
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c68 - 2c6f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c70 - 2c77
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2c78 - 2c7f
    {0x6a, 0x2c81}, {0x15, 0x2c80}, {0x6a, 0x2c83}, {0x15, 0x2c82}, {0x6a, 0x2c85}, {0x15, 0x2c84}, {0x6a, 0x2c87}, {0x15, 0x2c86}, // 2c80 - 2c87, Coptic
    {0x6a, 0x2c89}, {0x15, 0x2c88}, {0x6a, 0x2c8b}, {0x15, 0x2c8a}, {0x6a, 0x2c8d}, {0x15, 0x2c8c}, {0x6a, 0x2c8f}, {0x15, 0x2c8e}, // 2c88 - 2c8f
    {0x6a, 0x2c91}, {0x15, 0x2c90}, {0x6a, 0x2c93}, {0x15, 0x2c92}, {0x6a, 0x2c95}, {0x15, 0x2c94}, {0x6a, 0x2c97}, {0x15, 0x2c96}, // 2c90 - 2c97
    {0x6a, 0x2c99}, {0x15, 0x2c98}, {0x6a, 0x2c9b}, {0x15, 0x2c9a}, {0x6a, 0x2c9d}, {0x15, 0x2c9c}, {0x6a, 0x2c9f}, {0x15, 0x2c9e}, // 2c98 - 2c9f
    {0x6a, 0x2ca1}, {0x15, 0x2ca0}, {0x6a, 0x2ca3}, {0x15, 0x2ca2}, {0x6a, 0x2ca5}, {0x15, 0x2ca4}, {0x6a, 0x2ca7}, {0x15, 0x2ca6}, // 2ca0 - 2ca7
    {0x6a, 0x2ca9}, {0x15, 0x2ca8}, {0x6a, 0x2cab}, {0x15, 0x2caa}, {0x6a, 0x2cad}, {0x15, 0x2cac}, {0x6a, 0x2caf}, {0x15, 0x2cae}, // 2ca8 - 2caf
    {0x6a, 0x2cb1}, {0x15, 0x2cb0}, {0x6a, 0x2cb3}, {0x15, 0x2cb2}, {0x6a, 0x2cb5}, {0x15, 0x2cb4}, {0x6a, 0x2cb7}, {0x15, 0x2cb6}, // 2cb0 - 2cb7
    {0x6a, 0x2cb9}, {0x15, 0x2cb8}, {0x6a, 0x2cbb}, {0x15, 0x2cba}, {0x6a, 0x2cbd}, {0x15, 0x2cbc}, {0x6a, 0x2cbf}, {0x15, 0x2cbe}, // 2cb8 - 2cbf
    {0x6a, 0x2cc1}, {0x15, 0x2cc0}, {0x6a, 0x2cc3}, {0x15, 0x2cc2}, {0x6a, 0x2cc5}, {0x15, 0x2cc4}, {0x6a, 0x2cc7}, {0x15, 0x2cc6}, // 2cc0 - 2cc7
    {0x6a, 0x2cc9}, {0x15, 0x2cc8}, {0x6a, 0x2ccb}, {0x15, 0x2cca}, {0x6a, 0x2ccd}, {0x15, 0x2ccc}, {0x6a, 0x2ccf}, {0x15, 0x2cce}, // 2cc8 - 2ccf
    {0x6a, 0x2cd1}, {0x15, 0x2cd0}, {0x6a, 0x2cd3}, {0x15, 0x2cd2}, {0x6a, 0x2cd5}, {0x15, 0x2cd4}, {0x6a, 0x2cd7}, {0x15, 0x2cd6}, // 2cd0 - 2cd7
    {0x6a, 0x2cd9}, {0x15, 0x2cd8}, {0x6a, 0x2cdb}, {0x15, 0x2cda}, {0x6a, 0x2cdd}, {0x15, 0x2cdc}, {0x6a, 0x2cdf}, {0x15, 0x2cde}, // 2cd8 - 2cdf
    {0x6a, 0x2ce1}, {0x15, 0x2ce0}, {0x6a, 0x2ce3}, {0x15, 0x2ce2}, {0x6a, 0x2ce5}, {0x15, 0x2ce4}, {0x6a, 0x2ce7}, {0x15, 0x2ce6}, // 2ce0 - 2ce7
    {0x6a, 0x2ce9}, {0x15, 0x2ce8}, {0x6a, 0x2ceb}, {0x15, 0x2cea}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2ce8 - 2cef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2cf0 - 2cf7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // 2cf8 - 2cff

    {0xd5, 0x013A}, {0xd5, 0x013D}, {0xd5, 0x0140}, {0xd5, 0x0143}, {0xd5, 0x0146}, {0xd5, 0x0149}, {0xd5, 0x014C}, {0x00, 0x0000}, // fb00 - fb07
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb08 - fb0f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0xd5, 0x014F}, {0xd5, 0x0152}, {0xd5, 0x0155}, {0xd5, 0x0158}, {0xd5, 0x015B}, // fb10 - fb17
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb18 - fb1f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb20 - fb27
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb28 - fb2f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb30 - fb37
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb38 - fb3f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb40 - fb47
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb48 - fb4f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb50 - fb57
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb58 - fb5f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb60 - fb67
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb68 - fb6f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb70 - fb77
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb78 - fb7f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb80 - fb87
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb88 - fb8f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb90 - fb97
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fb98 - fb9f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fba0 - fba7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fba8 - fbaf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbb0 - fbb7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbb8 - fbbf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbc0 - fbc7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbc8 - fbcf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbd0 - fbd7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbd8 - fbdf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbe0 - fbe7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbe8 - fbef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbf0 - fbf7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fbf8 - fbff

    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff00 - ff07
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff08 - ff0f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff10 - ff17
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff18 - ff1f
    {0x00, 0x0000}, {0x6a, 0xFF41}, {0x6a, 0xFF42}, {0x6a, 0xFF43}, {0x6a, 0xFF44}, {0x6a, 0xFF45}, {0x6a, 0xFF46}, {0x6a, 0xFF47}, // ff20 - ff27
    {0x6a, 0xFF48}, {0x6a, 0xFF49}, {0x6a, 0xFF4A}, {0x6a, 0xFF4B}, {0x6a, 0xFF4C}, {0x6a, 0xFF4D}, {0x6a, 0xFF4E}, {0x6a, 0xFF4F}, // ff28 - ff2f
    {0x6a, 0xFF50}, {0x6a, 0xFF51}, {0x6a, 0xFF52}, {0x6a, 0xFF53}, {0x6a, 0xFF54}, {0x6a, 0xFF55}, {0x6a, 0xFF56}, {0x6a, 0xFF57}, // ff30 - ff37
    {0x6a, 0xFF58}, {0x6a, 0xFF59}, {0x6a, 0xFF5A}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff38 - ff3f
    {0x00, 0x0000}, {0x15, 0xFF21}, {0x15, 0xFF22}, {0x15, 0xFF23}, {0x15, 0xFF24}, {0x15, 0xFF25}, {0x15, 0xFF26}, {0x15, 0xFF27}, // ff40 - ff47
    {0x15, 0xFF28}, {0x15, 0xFF29}, {0x15, 0xFF2A}, {0x15, 0xFF2B}, {0x15, 0xFF2C}, {0x15, 0xFF2D}, {0x15, 0xFF2E}, {0x15, 0xFF2F}, // ff48 - ff4f
    {0x15, 0xFF30}, {0x15, 0xFF31}, {0x15, 0xFF32}, {0x15, 0xFF33}, {0x15, 0xFF34}, {0x15, 0xFF35}, {0x15, 0xFF36}, {0x15, 0xFF37}, // ff50 - ff57
    {0x15, 0xFF38}, {0x15, 0xFF39}, {0x15, 0xFF3A}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff58 - ff5f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff60 - ff67
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff68 - ff6f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff70 - ff77
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff78 - ff7f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff80 - ff87
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff88 - ff8f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff90 - ff97
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ff98 - ff9f
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffa0 - ffa7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffa8 - ffaf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffb0 - ffb7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffb8 - ffbf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffc0 - ffc7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffc8 - ffcf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffd0 - ffd7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffd8 - ffdf
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffe0 - ffe7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // ffe8 - ffef
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fff0 - fff7
    {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, {0x00, 0x0000}, // fff8 - ffff

};


#define MaxCaseMappingExtras 3

static Mapping CaseMappingExtra[] = {
    {0x80, 0, {0x0000, 0x0000, 0x0000}}, // 0x0000 (0 0x0)
    {0x60, 1, {0x0131, 0x0000, 0x0000}}, // 0x0049 (1 0x1)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x0049 (2 0x2)
    {0x60, 1, {0x006A, 0x0000, 0x0000}}, // 0x004a (3 0x3)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x004a (4 0x4)
    {0x15, 1, {0x039C, 0x0000, 0x0000}}, // 0x00b5 (5 0x5)
    {0x60, 1, {0x03BC, 0x0000, 0x0000}}, // 0x00b5 (6 0x6)
    {0x60, 1, {0x00EC, 0x0000, 0x0000}}, // 0x00cc (7 0x7)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x00cc (8 0x8)
    {0x60, 1, {0x00ED, 0x0000, 0x0000}}, // 0x00cd (9 0x9)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x00cd (10 0xa)
    {0x05, 2, {0x0053, 0x0053, 0x0000}}, // 0x00df (11 0xb)
    {0x10, 2, {0x0053, 0x0073, 0x0000}}, // 0x00df (12 0xc)
    {0x40, 2, {0x0073, 0x0073, 0x0000}}, // 0x00df (13 0xd)
    {0x60, 1, {0x0129, 0x0000, 0x0000}}, // 0x0128 (14 0xe)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x0128 (15 0xf)
    {0x60, 1, {0x012F, 0x0000, 0x0000}}, // 0x012e (16 0x10)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x012e (17 0x11)
    {0x60, 1, {0x0069, 0x0000, 0x0000}}, // 0x0130 (18 0x12)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x0130 (19 0x13)
    {0x15, 2, {0x02BC, 0x004E, 0x0000}}, // 0x0149 (20 0x14)
    {0x40, 2, {0x02BC, 0x006E, 0x0000}}, // 0x0149 (21 0x15)
    {0x15, 1, {0x0053, 0x0000, 0x0000}}, // 0x017f (22 0x16)
    {0x60, 1, {0x0073, 0x0000, 0x0000}}, // 0x017f (23 0x17)
    {0x6a, 1, {0x01C6, 0x0000, 0x0000}}, // 0x01c4 (24 0x18)
    {0x10, 1, {0x01C5, 0x0000, 0x0000}}, // 0x01c4 (25 0x19)
    {0x68, 1, {0x01C6, 0x0000, 0x0000}}, // 0x01c5 (26 0x1a)
    {0x04, 1, {0x01C4, 0x0000, 0x0000}}, // 0x01c5 (27 0x1b)
    {0x05, 1, {0x01C4, 0x0000, 0x0000}}, // 0x01c6 (28 0x1c)
    {0x10, 1, {0x01C5, 0x0000, 0x0000}}, // 0x01c6 (29 0x1d)
    {0x6a, 1, {0x01C9, 0x0000, 0x0000}}, // 0x01c7 (30 0x1e)
    {0x10, 1, {0x01C8, 0x0000, 0x0000}}, // 0x01c7 (31 0x1f)
    {0x68, 1, {0x01C9, 0x0000, 0x0000}}, // 0x01c8 (32 0x20)
    {0x04, 1, {0x01C7, 0x0000, 0x0000}}, // 0x01c8 (33 0x21)
    {0x05, 1, {0x01C7, 0x0000, 0x0000}}, // 0x01c9 (34 0x22)
    {0x10, 1, {0x01C8, 0x0000, 0x0000}}, // 0x01c9 (35 0x23)
    {0x6a, 1, {0x01CC, 0x0000, 0x0000}}, // 0x01ca (36 0x24)
    {0x10, 1, {0x01CB, 0x0000, 0x0000}}, // 0x01ca (37 0x25)
    {0x68, 1, {0x01CC, 0x0000, 0x0000}}, // 0x01cb (38 0x26)
    {0x04, 1, {0x01CA, 0x0000, 0x0000}}, // 0x01cb (39 0x27)
    {0x05, 1, {0x01CA, 0x0000, 0x0000}}, // 0x01cc (40 0x28)
    {0x10, 1, {0x01CB, 0x0000, 0x0000}}, // 0x01cc (41 0x29)
    {0x15, 2, {0x004A, 0x030C, 0x0000}}, // 0x01f0 (42 0x2a)
    {0x40, 2, {0x006A, 0x030C, 0x0000}}, // 0x01f0 (43 0x2b)
    {0x6a, 1, {0x01F3, 0x0000, 0x0000}}, // 0x01f1 (44 0x2c)
    {0x10, 1, {0x01F2, 0x0000, 0x0000}}, // 0x01f1 (45 0x2d)
    {0x68, 1, {0x01F3, 0x0000, 0x0000}}, // 0x01f2 (46 0x2e)
    {0x04, 1, {0x01F1, 0x0000, 0x0000}}, // 0x01f2 (47 0x2f)
    {0x05, 1, {0x01F1, 0x0000, 0x0000}}, // 0x01f3 (48 0x30)
    {0x10, 1, {0x01F2, 0x0000, 0x0000}}, // 0x01f3 (49 0x31)
    {0x14, 1, {0x0399, 0x0000, 0x0000}}, // 0x0345 (50 0x32)
    {0x60, 1, {0x03B9, 0x0000, 0x0000}}, // 0x0345 (51 0x33)
    {0x15, 3, {0x0399, 0x0308, 0x0301}}, // 0x0390 (52 0x34)
    {0x40, 3, {0x03B9, 0x0308, 0x0301}}, // 0x0390 (53 0x35)
    {0x60, 1, {0x03C3, 0x0000, 0x0000}}, // 0x03a3 (54 0x36)
    {0x8a, 0, {0x0000, 0x0000, 0x0000}}, // 0x03a3 (55 0x37)
    {0x15, 3, {0x03A5, 0x0308, 0x0301}}, // 0x03b0 (56 0x38)
    {0x40, 3, {0x03C5, 0x0308, 0x0301}}, // 0x03b0 (57 0x39)
    {0x15, 1, {0x03A3, 0x0000, 0x0000}}, // 0x03c2 (58 0x3a)
    {0x60, 1, {0x03C3, 0x0000, 0x0000}}, // 0x03c2 (59 0x3b)
    {0x15, 1, {0x0392, 0x0000, 0x0000}}, // 0x03d0 (60 0x3c)
    {0x60, 1, {0x03B2, 0x0000, 0x0000}}, // 0x03d0 (61 0x3d)
    {0x15, 1, {0x0398, 0x0000, 0x0000}}, // 0x03d1 (62 0x3e)
    {0x60, 1, {0x03B8, 0x0000, 0x0000}}, // 0x03d1 (63 0x3f)
    {0x15, 1, {0x03A6, 0x0000, 0x0000}}, // 0x03d5 (64 0x40)
    {0x60, 1, {0x03C6, 0x0000, 0x0000}}, // 0x03d5 (65 0x41)
    {0x15, 1, {0x03A0, 0x0000, 0x0000}}, // 0x03d6 (66 0x42)
    {0x60, 1, {0x03C0, 0x0000, 0x0000}}, // 0x03d6 (67 0x43)
    {0x15, 1, {0x039A, 0x0000, 0x0000}}, // 0x03f0 (68 0x44)
    {0x60, 1, {0x03BA, 0x0000, 0x0000}}, // 0x03f0 (69 0x45)
    {0x15, 1, {0x03A1, 0x0000, 0x0000}}, // 0x03f1 (70 0x46)
    {0x60, 1, {0x03C1, 0x0000, 0x0000}}, // 0x03f1 (71 0x47)
    {0x15, 1, {0x03A3, 0x0000, 0x0000}}, // 0x03f2 (72 0x48)
    {0x60, 1, {0x03C3, 0x0000, 0x0000}}, // 0x03f2 (73 0x49)
    {0x15, 1, {0x0395, 0x0000, 0x0000}}, // 0x03f5 (74 0x4a)
    {0x60, 1, {0x03B5, 0x0000, 0x0000}}, // 0x03f5 (75 0x4b)
    {0x05, 2, {0x0535, 0x0552, 0x0000}}, // 0x0587 (76 0x4c)
    {0x10, 2, {0x0535, 0x0582, 0x0000}}, // 0x0587 (77 0x4d)
    {0x40, 2, {0x0565, 0x0582, 0x0000}}, // 0x0587 (78 0x4e)
    {0x15, 2, {0x0048, 0x0331, 0x0000}}, // 0x1e96 (79 0x4f)
    {0x40, 2, {0x0068, 0x0331, 0x0000}}, // 0x1e96 (80 0x50)
    {0x15, 2, {0x0054, 0x0308, 0x0000}}, // 0x1e97 (81 0x51)
    {0x40, 2, {0x0074, 0x0308, 0x0000}}, // 0x1e97 (82 0x52)
    {0x15, 2, {0x0057, 0x030A, 0x0000}}, // 0x1e98 (83 0x53)
    {0x40, 2, {0x0077, 0x030A, 0x0000}}, // 0x1e98 (84 0x54)
    {0x15, 2, {0x0059, 0x030A, 0x0000}}, // 0x1e99 (85 0x55)
    {0x40, 2, {0x0079, 0x030A, 0x0000}}, // 0x1e99 (86 0x56)
    {0x15, 2, {0x0041, 0x02BE, 0x0000}}, // 0x1e9a (87 0x57)
    {0x40, 2, {0x0061, 0x02BE, 0x0000}}, // 0x1e9a (88 0x58)
    {0x15, 1, {0x1E60, 0x0000, 0x0000}}, // 0x1e9b (89 0x59)
    {0x60, 1, {0x1E61, 0x0000, 0x0000}}, // 0x1e9b (90 0x5a)
    {0x15, 2, {0x03A5, 0x0313, 0x0000}}, // 0x1f50 (91 0x5b)
    {0x40, 2, {0x03C5, 0x0313, 0x0000}}, // 0x1f50 (92 0x5c)
    {0x15, 3, {0x03A5, 0x0313, 0x0300}}, // 0x1f52 (93 0x5d)
    {0x40, 3, {0x03C5, 0x0313, 0x0300}}, // 0x1f52 (94 0x5e)
    {0x15, 3, {0x03A5, 0x0313, 0x0301}}, // 0x1f54 (95 0x5f)
    {0x40, 3, {0x03C5, 0x0313, 0x0301}}, // 0x1f54 (96 0x60)
    {0x15, 3, {0x03A5, 0x0313, 0x0342}}, // 0x1f56 (97 0x61)
    {0x40, 3, {0x03C5, 0x0313, 0x0342}}, // 0x1f56 (98 0x62)
    {0x05, 2, {0x1F08, 0x0399, 0x0000}}, // 0x1f80 (99 0x63)
    {0x10, 1, {0x1F88, 0x0000, 0x0000}}, // 0x1f80 (100 0x64)
    {0x40, 2, {0x1F00, 0x03B9, 0x0000}}, // 0x1f80 (101 0x65)
    {0x05, 2, {0x1F09, 0x0399, 0x0000}}, // 0x1f81 (102 0x66)
    {0x10, 1, {0x1F89, 0x0000, 0x0000}}, // 0x1f81 (103 0x67)
    {0x40, 2, {0x1F01, 0x03B9, 0x0000}}, // 0x1f81 (104 0x68)
    {0x05, 2, {0x1F0A, 0x0399, 0x0000}}, // 0x1f82 (105 0x69)
    {0x10, 1, {0x1F8A, 0x0000, 0x0000}}, // 0x1f82 (106 0x6a)
    {0x40, 2, {0x1F02, 0x03B9, 0x0000}}, // 0x1f82 (107 0x6b)
    {0x05, 2, {0x1F0B, 0x0399, 0x0000}}, // 0x1f83 (108 0x6c)
    {0x10, 1, {0x1F8B, 0x0000, 0x0000}}, // 0x1f83 (109 0x6d)
    {0x40, 2, {0x1F03, 0x03B9, 0x0000}}, // 0x1f83 (110 0x6e)
    {0x05, 2, {0x1F0C, 0x0399, 0x0000}}, // 0x1f84 (111 0x6f)
    {0x10, 1, {0x1F8C, 0x0000, 0x0000}}, // 0x1f84 (112 0x70)
    {0x40, 2, {0x1F04, 0x03B9, 0x0000}}, // 0x1f84 (113 0x71)
    {0x05, 2, {0x1F0D, 0x0399, 0x0000}}, // 0x1f85 (114 0x72)
    {0x10, 1, {0x1F8D, 0x0000, 0x0000}}, // 0x1f85 (115 0x73)
    {0x40, 2, {0x1F05, 0x03B9, 0x0000}}, // 0x1f85 (116 0x74)
    {0x05, 2, {0x1F0E, 0x0399, 0x0000}}, // 0x1f86 (117 0x75)
    {0x10, 1, {0x1F8E, 0x0000, 0x0000}}, // 0x1f86 (118 0x76)
    {0x40, 2, {0x1F06, 0x03B9, 0x0000}}, // 0x1f86 (119 0x77)
    {0x05, 2, {0x1F0F, 0x0399, 0x0000}}, // 0x1f87 (120 0x78)
    {0x10, 1, {0x1F8F, 0x0000, 0x0000}}, // 0x1f87 (121 0x79)
    {0x40, 2, {0x1F07, 0x03B9, 0x0000}}, // 0x1f87 (122 0x7a)
    {0x28, 1, {0x1F80, 0x0000, 0x0000}}, // 0x1f88 (123 0x7b)
    {0x04, 2, {0x1F08, 0x0399, 0x0000}}, // 0x1f88 (124 0x7c)
    {0x40, 2, {0x1F00, 0x03B9, 0x0000}}, // 0x1f88 (125 0x7d)
    {0x28, 1, {0x1F81, 0x0000, 0x0000}}, // 0x1f89 (126 0x7e)
    {0x04, 2, {0x1F09, 0x0399, 0x0000}}, // 0x1f89 (127 0x7f)
    {0x40, 2, {0x1F01, 0x03B9, 0x0000}}, // 0x1f89 (128 0x80)
    {0x28, 1, {0x1F82, 0x0000, 0x0000}}, // 0x1f8a (129 0x81)
    {0x04, 2, {0x1F0A, 0x0399, 0x0000}}, // 0x1f8a (130 0x82)
    {0x40, 2, {0x1F02, 0x03B9, 0x0000}}, // 0x1f8a (131 0x83)
    {0x28, 1, {0x1F83, 0x0000, 0x0000}}, // 0x1f8b (132 0x84)
    {0x04, 2, {0x1F0B, 0x0399, 0x0000}}, // 0x1f8b (133 0x85)
    {0x40, 2, {0x1F03, 0x03B9, 0x0000}}, // 0x1f8b (134 0x86)
    {0x28, 1, {0x1F84, 0x0000, 0x0000}}, // 0x1f8c (135 0x87)
    {0x04, 2, {0x1F0C, 0x0399, 0x0000}}, // 0x1f8c (136 0x88)
    {0x40, 2, {0x1F04, 0x03B9, 0x0000}}, // 0x1f8c (137 0x89)
    {0x28, 1, {0x1F85, 0x0000, 0x0000}}, // 0x1f8d (138 0x8a)
    {0x04, 2, {0x1F0D, 0x0399, 0x0000}}, // 0x1f8d (139 0x8b)
    {0x40, 2, {0x1F05, 0x03B9, 0x0000}}, // 0x1f8d (140 0x8c)
    {0x28, 1, {0x1F86, 0x0000, 0x0000}}, // 0x1f8e (141 0x8d)
    {0x04, 2, {0x1F0E, 0x0399, 0x0000}}, // 0x1f8e (142 0x8e)
    {0x40, 2, {0x1F06, 0x03B9, 0x0000}}, // 0x1f8e (143 0x8f)
    {0x28, 1, {0x1F87, 0x0000, 0x0000}}, // 0x1f8f (144 0x90)
    {0x04, 2, {0x1F0F, 0x0399, 0x0000}}, // 0x1f8f (145 0x91)
    {0x40, 2, {0x1F07, 0x03B9, 0x0000}}, // 0x1f8f (146 0x92)
    {0x05, 2, {0x1F28, 0x0399, 0x0000}}, // 0x1f90 (147 0x93)
    {0x10, 1, {0x1F98, 0x0000, 0x0000}}, // 0x1f90 (148 0x94)
    {0x40, 2, {0x1F20, 0x03B9, 0x0000}}, // 0x1f90 (149 0x95)
    {0x05, 2, {0x1F29, 0x0399, 0x0000}}, // 0x1f91 (150 0x96)
    {0x10, 1, {0x1F99, 0x0000, 0x0000}}, // 0x1f91 (151 0x97)
    {0x40, 2, {0x1F21, 0x03B9, 0x0000}}, // 0x1f91 (152 0x98)
    {0x05, 2, {0x1F2A, 0x0399, 0x0000}}, // 0x1f92 (153 0x99)
    {0x10, 1, {0x1F9A, 0x0000, 0x0000}}, // 0x1f92 (154 0x9a)
    {0x40, 2, {0x1F22, 0x03B9, 0x0000}}, // 0x1f92 (155 0x9b)
    {0x05, 2, {0x1F2B, 0x0399, 0x0000}}, // 0x1f93 (156 0x9c)
    {0x10, 1, {0x1F9B, 0x0000, 0x0000}}, // 0x1f93 (157 0x9d)
    {0x40, 2, {0x1F23, 0x03B9, 0x0000}}, // 0x1f93 (158 0x9e)
    {0x05, 2, {0x1F2C, 0x0399, 0x0000}}, // 0x1f94 (159 0x9f)
    {0x10, 1, {0x1F9C, 0x0000, 0x0000}}, // 0x1f94 (160 0xa0)
    {0x40, 2, {0x1F24, 0x03B9, 0x0000}}, // 0x1f94 (161 0xa1)
    {0x05, 2, {0x1F2D, 0x0399, 0x0000}}, // 0x1f95 (162 0xa2)
    {0x10, 1, {0x1F9D, 0x0000, 0x0000}}, // 0x1f95 (163 0xa3)
    {0x40, 2, {0x1F25, 0x03B9, 0x0000}}, // 0x1f95 (164 0xa4)
    {0x05, 2, {0x1F2E, 0x0399, 0x0000}}, // 0x1f96 (165 0xa5)
    {0x10, 1, {0x1F9E, 0x0000, 0x0000}}, // 0x1f96 (166 0xa6)
    {0x40, 2, {0x1F26, 0x03B9, 0x0000}}, // 0x1f96 (167 0xa7)
    {0x05, 2, {0x1F2F, 0x0399, 0x0000}}, // 0x1f97 (168 0xa8)
    {0x10, 1, {0x1F9F, 0x0000, 0x0000}}, // 0x1f97 (169 0xa9)
    {0x40, 2, {0x1F27, 0x03B9, 0x0000}}, // 0x1f97 (170 0xaa)
    {0x28, 1, {0x1F90, 0x0000, 0x0000}}, // 0x1f98 (171 0xab)
    {0x04, 2, {0x1F28, 0x0399, 0x0000}}, // 0x1f98 (172 0xac)
    {0x40, 2, {0x1F20, 0x03B9, 0x0000}}, // 0x1f98 (173 0xad)
    {0x28, 1, {0x1F91, 0x0000, 0x0000}}, // 0x1f99 (174 0xae)
    {0x04, 2, {0x1F29, 0x0399, 0x0000}}, // 0x1f99 (175 0xaf)
    {0x40, 2, {0x1F21, 0x03B9, 0x0000}}, // 0x1f99 (176 0xb0)
    {0x28, 1, {0x1F92, 0x0000, 0x0000}}, // 0x1f9a (177 0xb1)
    {0x04, 2, {0x1F2A, 0x0399, 0x0000}}, // 0x1f9a (178 0xb2)
    {0x40, 2, {0x1F22, 0x03B9, 0x0000}}, // 0x1f9a (179 0xb3)
    {0x28, 1, {0x1F93, 0x0000, 0x0000}}, // 0x1f9b (180 0xb4)
    {0x04, 2, {0x1F2B, 0x0399, 0x0000}}, // 0x1f9b (181 0xb5)
    {0x40, 2, {0x1F23, 0x03B9, 0x0000}}, // 0x1f9b (182 0xb6)
    {0x28, 1, {0x1F94, 0x0000, 0x0000}}, // 0x1f9c (183 0xb7)
    {0x04, 2, {0x1F2C, 0x0399, 0x0000}}, // 0x1f9c (184 0xb8)
    {0x40, 2, {0x1F24, 0x03B9, 0x0000}}, // 0x1f9c (185 0xb9)
    {0x28, 1, {0x1F95, 0x0000, 0x0000}}, // 0x1f9d (186 0xba)
    {0x04, 2, {0x1F2D, 0x0399, 0x0000}}, // 0x1f9d (187 0xbb)
    {0x40, 2, {0x1F25, 0x03B9, 0x0000}}, // 0x1f9d (188 0xbc)
    {0x28, 1, {0x1F96, 0x0000, 0x0000}}, // 0x1f9e (189 0xbd)
    {0x04, 2, {0x1F2E, 0x0399, 0x0000}}, // 0x1f9e (190 0xbe)
    {0x40, 2, {0x1F26, 0x03B9, 0x0000}}, // 0x1f9e (191 0xbf)
    {0x28, 1, {0x1F97, 0x0000, 0x0000}}, // 0x1f9f (192 0xc0)
    {0x04, 2, {0x1F2F, 0x0399, 0x0000}}, // 0x1f9f (193 0xc1)
    {0x40, 2, {0x1F27, 0x03B9, 0x0000}}, // 0x1f9f (194 0xc2)
    {0x05, 2, {0x1F68, 0x0399, 0x0000}}, // 0x1fa0 (195 0xc3)
    {0x10, 1, {0x1FA8, 0x0000, 0x0000}}, // 0x1fa0 (196 0xc4)
    {0x40, 2, {0x1F60, 0x03B9, 0x0000}}, // 0x1fa0 (197 0xc5)
    {0x05, 2, {0x1F69, 0x0399, 0x0000}}, // 0x1fa1 (198 0xc6)
    {0x10, 1, {0x1FA9, 0x0000, 0x0000}}, // 0x1fa1 (199 0xc7)
    {0x40, 2, {0x1F61, 0x03B9, 0x0000}}, // 0x1fa1 (200 0xc8)
    {0x05, 2, {0x1F6A, 0x0399, 0x0000}}, // 0x1fa2 (201 0xc9)
    {0x10, 1, {0x1FAA, 0x0000, 0x0000}}, // 0x1fa2 (202 0xca)
    {0x40, 2, {0x1F62, 0x03B9, 0x0000}}, // 0x1fa2 (203 0xcb)
    {0x05, 2, {0x1F6B, 0x0399, 0x0000}}, // 0x1fa3 (204 0xcc)
    {0x10, 1, {0x1FAB, 0x0000, 0x0000}}, // 0x1fa3 (205 0xcd)
    {0x40, 2, {0x1F63, 0x03B9, 0x0000}}, // 0x1fa3 (206 0xce)
    {0x05, 2, {0x1F6C, 0x0399, 0x0000}}, // 0x1fa4 (207 0xcf)
    {0x10, 1, {0x1FAC, 0x0000, 0x0000}}, // 0x1fa4 (208 0xd0)
    {0x40, 2, {0x1F64, 0x03B9, 0x0000}}, // 0x1fa4 (209 0xd1)
    {0x05, 2, {0x1F6D, 0x0399, 0x0000}}, // 0x1fa5 (210 0xd2)
    {0x10, 1, {0x1FAD, 0x0000, 0x0000}}, // 0x1fa5 (211 0xd3)
    {0x40, 2, {0x1F65, 0x03B9, 0x0000}}, // 0x1fa5 (212 0xd4)
    {0x05, 2, {0x1F6E, 0x0399, 0x0000}}, // 0x1fa6 (213 0xd5)
    {0x10, 1, {0x1FAE, 0x0000, 0x0000}}, // 0x1fa6 (214 0xd6)
    {0x40, 2, {0x1F66, 0x03B9, 0x0000}}, // 0x1fa6 (215 0xd7)
    {0x05, 2, {0x1F6F, 0x0399, 0x0000}}, // 0x1fa7 (216 0xd8)
    {0x10, 1, {0x1FAF, 0x0000, 0x0000}}, // 0x1fa7 (217 0xd9)
    {0x40, 2, {0x1F67, 0x03B9, 0x0000}}, // 0x1fa7 (218 0xda)
    {0x28, 1, {0x1FA0, 0x0000, 0x0000}}, // 0x1fa8 (219 0xdb)
    {0x04, 2, {0x1F68, 0x0399, 0x0000}}, // 0x1fa8 (220 0xdc)
    {0x40, 2, {0x1F60, 0x03B9, 0x0000}}, // 0x1fa8 (221 0xdd)
    {0x28, 1, {0x1FA1, 0x0000, 0x0000}}, // 0x1fa9 (222 0xde)
    {0x04, 2, {0x1F69, 0x0399, 0x0000}}, // 0x1fa9 (223 0xdf)
    {0x40, 2, {0x1F61, 0x03B9, 0x0000}}, // 0x1fa9 (224 0xe0)
    {0x28, 1, {0x1FA2, 0x0000, 0x0000}}, // 0x1faa (225 0xe1)
    {0x04, 2, {0x1F6A, 0x0399, 0x0000}}, // 0x1faa (226 0xe2)
    {0x40, 2, {0x1F62, 0x03B9, 0x0000}}, // 0x1faa (227 0xe3)
    {0x28, 1, {0x1FA3, 0x0000, 0x0000}}, // 0x1fab (228 0xe4)
    {0x04, 2, {0x1F6B, 0x0399, 0x0000}}, // 0x1fab (229 0xe5)
    {0x40, 2, {0x1F63, 0x03B9, 0x0000}}, // 0x1fab (230 0xe6)
    {0x28, 1, {0x1FA4, 0x0000, 0x0000}}, // 0x1fac (231 0xe7)
    {0x04, 2, {0x1F6C, 0x0399, 0x0000}}, // 0x1fac (232 0xe8)
    {0x40, 2, {0x1F64, 0x03B9, 0x0000}}, // 0x1fac (233 0xe9)
    {0x28, 1, {0x1FA5, 0x0000, 0x0000}}, // 0x1fad (234 0xea)
    {0x04, 2, {0x1F6D, 0x0399, 0x0000}}, // 0x1fad (235 0xeb)
    {0x40, 2, {0x1F65, 0x03B9, 0x0000}}, // 0x1fad (236 0xec)
    {0x28, 1, {0x1FA6, 0x0000, 0x0000}}, // 0x1fae (237 0xed)
    {0x04, 2, {0x1F6E, 0x0399, 0x0000}}, // 0x1fae (238 0xee)
    {0x40, 2, {0x1F66, 0x03B9, 0x0000}}, // 0x1fae (239 0xef)
    {0x28, 1, {0x1FA7, 0x0000, 0x0000}}, // 0x1faf (240 0xf0)
    {0x04, 2, {0x1F6F, 0x0399, 0x0000}}, // 0x1faf (241 0xf1)
    {0x40, 2, {0x1F67, 0x03B9, 0x0000}}, // 0x1faf (242 0xf2)
    {0x05, 2, {0x1FBA, 0x0399, 0x0000}}, // 0x1fb2 (243 0xf3)
    {0x10, 2, {0x1FBA, 0x0345, 0x0000}}, // 0x1fb2 (244 0xf4)
    {0x40, 2, {0x1F70, 0x03B9, 0x0000}}, // 0x1fb2 (245 0xf5)
    {0x05, 2, {0x0391, 0x0399, 0x0000}}, // 0x1fb3 (246 0xf6)
    {0x10, 1, {0x1FBC, 0x0000, 0x0000}}, // 0x1fb3 (247 0xf7)
    {0x40, 2, {0x03B1, 0x03B9, 0x0000}}, // 0x1fb3 (248 0xf8)
    {0x05, 2, {0x0386, 0x0399, 0x0000}}, // 0x1fb4 (249 0xf9)
    {0x10, 2, {0x0386, 0x0345, 0x0000}}, // 0x1fb4 (250 0xfa)
    {0x40, 2, {0x03AC, 0x03B9, 0x0000}}, // 0x1fb4 (251 0xfb)
    {0x15, 2, {0x0391, 0x0342, 0x0000}}, // 0x1fb6 (252 0xfc)
    {0x40, 2, {0x03B1, 0x0342, 0x0000}}, // 0x1fb6 (253 0xfd)
    {0x05, 3, {0x0391, 0x0342, 0x0399}}, // 0x1fb7 (254 0xfe)
    {0x10, 3, {0x0391, 0x0342, 0x0345}}, // 0x1fb7 (255 0xff)
    {0x40, 3, {0x03B1, 0x0342, 0x03B9}}, // 0x1fb7 (256 0x100)
    {0x28, 1, {0x1FB3, 0x0000, 0x0000}}, // 0x1fbc (257 0x101)
    {0x04, 2, {0x0391, 0x0399, 0x0000}}, // 0x1fbc (258 0x102)
    {0x40, 2, {0x03B1, 0x03B9, 0x0000}}, // 0x1fbc (259 0x103)
    {0x15, 1, {0x0399, 0x0000, 0x0000}}, // 0x1fbe (260 0x104)
    {0x60, 1, {0x03B9, 0x0000, 0x0000}}, // 0x1fbe (261 0x105)
    {0x05, 2, {0x1FCA, 0x0399, 0x0000}}, // 0x1fc2 (262 0x106)
    {0x10, 2, {0x1FCA, 0x0345, 0x0000}}, // 0x1fc2 (263 0x107)
    {0x40, 2, {0x1F74, 0x03B9, 0x0000}}, // 0x1fc2 (264 0x108)
    {0x05, 2, {0x0397, 0x0399, 0x0000}}, // 0x1fc3 (265 0x109)
    {0x10, 1, {0x1FCC, 0x0000, 0x0000}}, // 0x1fc3 (266 0x10a)
    {0x40, 2, {0x03B7, 0x03B9, 0x0000}}, // 0x1fc3 (267 0x10b)
    {0x05, 2, {0x0389, 0x0399, 0x0000}}, // 0x1fc4 (268 0x10c)
    {0x10, 2, {0x0389, 0x0345, 0x0000}}, // 0x1fc4 (269 0x10d)
    {0x40, 2, {0x03AE, 0x03B9, 0x0000}}, // 0x1fc4 (270 0x10e)
    {0x15, 2, {0x0397, 0x0342, 0x0000}}, // 0x1fc6 (271 0x10f)
    {0x40, 2, {0x03B7, 0x0342, 0x0000}}, // 0x1fc6 (272 0x110)
    {0x05, 3, {0x0397, 0x0342, 0x0399}}, // 0x1fc7 (273 0x111)
    {0x10, 3, {0x0397, 0x0342, 0x0345}}, // 0x1fc7 (274 0x112)
    {0x40, 3, {0x03B7, 0x0342, 0x03B9}}, // 0x1fc7 (275 0x113)
    {0x28, 1, {0x1FC3, 0x0000, 0x0000}}, // 0x1fcc (276 0x114)
    {0x04, 2, {0x0397, 0x0399, 0x0000}}, // 0x1fcc (277 0x115)
    {0x40, 2, {0x03B7, 0x03B9, 0x0000}}, // 0x1fcc (278 0x116)
    {0x15, 3, {0x0399, 0x0308, 0x0300}}, // 0x1fd2 (279 0x117)
    {0x40, 3, {0x03B9, 0x0308, 0x0300}}, // 0x1fd2 (280 0x118)
    {0x15, 3, {0x0399, 0x0308, 0x0301}}, // 0x1fd3 (281 0x119)
    {0x40, 3, {0x03B9, 0x0308, 0x0301}}, // 0x1fd3 (282 0x11a)
    {0x15, 2, {0x0399, 0x0342, 0x0000}}, // 0x1fd6 (283 0x11b)
    {0x40, 2, {0x03B9, 0x0342, 0x0000}}, // 0x1fd6 (284 0x11c)
    {0x15, 3, {0x0399, 0x0308, 0x0342}}, // 0x1fd7 (285 0x11d)
    {0x40, 3, {0x03B9, 0x0308, 0x0342}}, // 0x1fd7 (286 0x11e)
    {0x15, 3, {0x03A5, 0x0308, 0x0300}}, // 0x1fe2 (287 0x11f)
    {0x40, 3, {0x03C5, 0x0308, 0x0300}}, // 0x1fe2 (288 0x120)
    {0x15, 3, {0x03A5, 0x0308, 0x0301}}, // 0x1fe3 (289 0x121)
    {0x40, 3, {0x03C5, 0x0308, 0x0301}}, // 0x1fe3 (290 0x122)
    {0x15, 2, {0x03A1, 0x0313, 0x0000}}, // 0x1fe4 (291 0x123)
    {0x40, 2, {0x03C1, 0x0313, 0x0000}}, // 0x1fe4 (292 0x124)
    {0x15, 2, {0x03A5, 0x0342, 0x0000}}, // 0x1fe6 (293 0x125)
    {0x40, 2, {0x03C5, 0x0342, 0x0000}}, // 0x1fe6 (294 0x126)
    {0x15, 3, {0x03A5, 0x0308, 0x0342}}, // 0x1fe7 (295 0x127)
    {0x40, 3, {0x03C5, 0x0308, 0x0342}}, // 0x1fe7 (296 0x128)
    {0x05, 2, {0x1FFA, 0x0399, 0x0000}}, // 0x1ff2 (297 0x129)
    {0x10, 2, {0x1FFA, 0x0345, 0x0000}}, // 0x1ff2 (298 0x12a)
    {0x40, 2, {0x1F7C, 0x03B9, 0x0000}}, // 0x1ff2 (299 0x12b)
    {0x05, 2, {0x03A9, 0x0399, 0x0000}}, // 0x1ff3 (300 0x12c)
    {0x10, 1, {0x1FFC, 0x0000, 0x0000}}, // 0x1ff3 (301 0x12d)
    {0x40, 2, {0x03C9, 0x03B9, 0x0000}}, // 0x1ff3 (302 0x12e)
    {0x05, 2, {0x038F, 0x0399, 0x0000}}, // 0x1ff4 (303 0x12f)
    {0x10, 2, {0x038F, 0x0345, 0x0000}}, // 0x1ff4 (304 0x130)
    {0x40, 2, {0x03CE, 0x03B9, 0x0000}}, // 0x1ff4 (305 0x131)
    {0x15, 2, {0x03A9, 0x0342, 0x0000}}, // 0x1ff6 (306 0x132)
    {0x40, 2, {0x03C9, 0x0342, 0x0000}}, // 0x1ff6 (307 0x133)
    {0x05, 3, {0x03A9, 0x0342, 0x0399}}, // 0x1ff7 (308 0x134)
    {0x10, 3, {0x03A9, 0x0342, 0x0345}}, // 0x1ff7 (309 0x135)
    {0x40, 3, {0x03C9, 0x0342, 0x03B9}}, // 0x1ff7 (310 0x136)
    {0x28, 1, {0x1FF3, 0x0000, 0x0000}}, // 0x1ffc (311 0x137)
    {0x04, 2, {0x03A9, 0x0399, 0x0000}}, // 0x1ffc (312 0x138)
    {0x40, 2, {0x03C9, 0x03B9, 0x0000}}, // 0x1ffc (313 0x139)
    {0x05, 2, {0x0046, 0x0046, 0x0000}}, // 0xfb00 (314 0x13a)
    {0x10, 2, {0x0046, 0x0066, 0x0000}}, // 0xfb00 (315 0x13b)
    {0x40, 2, {0x0066, 0x0066, 0x0000}}, // 0xfb00 (316 0x13c)
    {0x05, 2, {0x0046, 0x0049, 0x0000}}, // 0xfb01 (317 0x13d)
    {0x10, 2, {0x0046, 0x0069, 0x0000}}, // 0xfb01 (318 0x13e)
    {0x40, 2, {0x0066, 0x0069, 0x0000}}, // 0xfb01 (319 0x13f)
    {0x05, 2, {0x0046, 0x004C, 0x0000}}, // 0xfb02 (320 0x140)
    {0x10, 2, {0x0046, 0x006C, 0x0000}}, // 0xfb02 (321 0x141)
    {0x40, 2, {0x0066, 0x006C, 0x0000}}, // 0xfb02 (322 0x142)
    {0x05, 3, {0x0046, 0x0046, 0x0049}}, // 0xfb03 (323 0x143)
    {0x10, 3, {0x0046, 0x0066, 0x0069}}, // 0xfb03 (324 0x144)
    {0x40, 3, {0x0066, 0x0066, 0x0069}}, // 0xfb03 (325 0x145)
    {0x05, 3, {0x0046, 0x0046, 0x004C}}, // 0xfb04 (326 0x146)
    {0x10, 3, {0x0046, 0x0066, 0x006C}}, // 0xfb04 (327 0x147)
    {0x40, 3, {0x0066, 0x0066, 0x006C}}, // 0xfb04 (328 0x148)
    {0x05, 2, {0x0053, 0x0054, 0x0000}}, // 0xfb05 (329 0x149)
    {0x10, 2, {0x0053, 0x0074, 0x0000}}, // 0xfb05 (330 0x14a)
    {0x40, 2, {0x0073, 0x0074, 0x0000}}, // 0xfb05 (331 0x14b)
    {0x05, 2, {0x0053, 0x0054, 0x0000}}, // 0xfb06 (332 0x14c)
    {0x10, 2, {0x0053, 0x0074, 0x0000}}, // 0xfb06 (333 0x14d)
    {0x40, 2, {0x0073, 0x0074, 0x0000}}, // 0xfb06 (334 0x14e)
    {0x05, 2, {0x0544, 0x0546, 0x0000}}, // 0xfb13 (335 0x14f)
    {0x10, 2, {0x0544, 0x0576, 0x0000}}, // 0xfb13 (336 0x150)
    {0x40, 2, {0x0574, 0x0576, 0x0000}}, // 0xfb13 (337 0x151)
    {0x05, 2, {0x0544, 0x0535, 0x0000}}, // 0xfb14 (338 0x152)
    {0x10, 2, {0x0544, 0x0565, 0x0000}}, // 0xfb14 (339 0x153)
    {0x40, 2, {0x0574, 0x0565, 0x0000}}, // 0xfb14 (340 0x154)
    {0x05, 2, {0x0544, 0x053B, 0x0000}}, // 0xfb15 (341 0x155)
    {0x10, 2, {0x0544, 0x056B, 0x0000}}, // 0xfb15 (342 0x156)
    {0x40, 2, {0x0574, 0x056B, 0x0000}}, // 0xfb15 (343 0x157)
    {0x05, 2, {0x054E, 0x0546, 0x0000}}, // 0xfb16 (344 0x158)
    {0x10, 2, {0x054E, 0x0576, 0x0000}}, // 0xfb16 (345 0x159)
    {0x40, 2, {0x057E, 0x0576, 0x0000}}, // 0xfb16 (346 0x15a)
    {0x05, 2, {0x0544, 0x053D, 0x0000}}, // 0xfb17 (347 0x15b)
    {0x10, 2, {0x0544, 0x056D, 0x0000}}, // 0xfb17 (348 0x15c)
    {0x40, 2, {0x0574, 0x056D, 0x0000}}, // 0xfb17 (349 0x15d)
};

/* Following code need special handling
    0x0069, 0x00CC, 0x00CD, 0x0128, 0x012E, 0x0130, 0x0049, 0x004A, 0x0307, 0x03A3,
*/

} } } }

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
