/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;

class Collector {
    Collector() {
    }

    public static void collect(Compiler compiler, Node.Nodes nodes) throws JasperException {
        CollectVisitor collectVisitor = new CollectVisitor();
        nodes.visit(collectVisitor);
        collectVisitor.updatePageInfo(compiler.getPageInfo());
    }

    static class CollectVisitor
    extends Node.Visitor {
        private boolean scriptingElementSeen = false;
        private boolean usebeanSeen = false;
        private boolean includeActionSeen = false;
        private boolean paramActionSeen = false;
        private boolean setPropertySeen = false;
        private boolean hasScriptingVars = false;

        CollectVisitor() {
        }

        @Override
        public void visit(Node.ParamAction paramAction) throws JasperException {
            if (paramAction.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.paramActionSeen = true;
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            if (includeAction.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.includeActionSeen = true;
            this.visitBody(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            if (forwardAction.getPage().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(forwardAction);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            if (setProperty.getValue() != null && setProperty.getValue().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.setPropertySeen = true;
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            if (useBean.getBeanName() != null && useBean.getBeanName().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.usebeanSeen = true;
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            if (plugIn.getHeight() != null && plugIn.getHeight().isExpression()) {
                this.scriptingElementSeen = true;
            }
            if (plugIn.getWidth() != null && plugIn.getWidth().isExpression()) {
                this.scriptingElementSeen = true;
            }
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.checkSeen(customTag.getChildInfo(), customTag);
        }

        private void checkSeen(Node.ChildInfo childInfo, Node node) throws JasperException {
            Node.CustomTag customTag;
            boolean bl = this.scriptingElementSeen;
            this.scriptingElementSeen = false;
            boolean bl2 = this.usebeanSeen;
            this.usebeanSeen = false;
            boolean bl3 = this.includeActionSeen;
            this.includeActionSeen = false;
            boolean bl4 = this.paramActionSeen;
            this.paramActionSeen = false;
            boolean bl5 = this.setPropertySeen;
            this.setPropertySeen = false;
            boolean bl6 = this.hasScriptingVars;
            this.hasScriptingVars = false;
            if (node instanceof Node.CustomTag) {
                customTag = (Node.CustomTag)node;
                Node.JspAttribute[] jspAttributeArray = customTag.getJspAttributes();
                for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                    if (!jspAttributeArray[i].isExpression()) continue;
                    this.scriptingElementSeen = true;
                    break;
                }
            }
            this.visitBody(node);
            if (node instanceof Node.CustomTag && !this.hasScriptingVars) {
                customTag = (Node.CustomTag)node;
                this.hasScriptingVars = customTag.getVariableInfos().length > 0 || customTag.getTagVariableInfos().length > 0;
            }
            childInfo.setScriptless(!this.scriptingElementSeen);
            childInfo.setHasUseBean(this.usebeanSeen);
            childInfo.setHasIncludeAction(this.includeActionSeen);
            childInfo.setHasParamAction(this.paramActionSeen);
            childInfo.setHasSetProperty(this.setPropertySeen);
            childInfo.setHasScriptingVars(this.hasScriptingVars);
            this.scriptingElementSeen = this.scriptingElementSeen || bl;
            this.usebeanSeen = this.usebeanSeen || bl2;
            this.setPropertySeen = this.setPropertySeen || bl5;
            this.includeActionSeen = this.includeActionSeen || bl3;
            this.paramActionSeen = this.paramActionSeen || bl4;
            this.hasScriptingVars = this.hasScriptingVars || bl6;
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            Node.JspAttribute[] jspAttributeArray;
            if (jspElement.getNameAttribute().isExpression()) {
                this.scriptingElementSeen = true;
            }
            for (Node.JspAttribute jspAttribute : jspAttributeArray = jspElement.getJspAttributes()) {
                if (!jspAttribute.isExpression()) continue;
                this.scriptingElementSeen = true;
                break;
            }
            this.visitBody(jspElement);
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.checkSeen(jspBody.getChildInfo(), jspBody);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            this.checkSeen(namedAttribute.getChildInfo(), namedAttribute);
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            this.scriptingElementSeen = true;
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            this.scriptingElementSeen = true;
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            this.scriptingElementSeen = true;
        }

        public void updatePageInfo(PageInfo pageInfo) {
            pageInfo.setScriptless(!this.scriptingElementSeen);
        }
    }
}

