/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroManager;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.Node;
import org.slf4j.Logger;

public class VelocimacroFactory {
    private final RuntimeServices rsvc;
    private Logger log = null;
    private VelocimacroManager vmManager = null;
    private boolean replaceAllowed = false;
    private boolean addNewAllowed = true;
    private boolean templateLocal = false;
    private boolean autoReloadLibrary = false;
    private List<String> macroLibVec = null;
    private Map libModMap;

    public VelocimacroFactory(RuntimeServices rsvc) {
        this.rsvc = rsvc;
        this.libModMap = new HashMap();
        this.vmManager = new VelocimacroManager(rsvc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVelocimacro() {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.log = this.rsvc.getLog("macro");
            this.log.trace("initialization starting.");
            this.setReplacementPermission(true);
            this.vmManager.setNamespaceUsage(false);
            Object libfiles = this.rsvc.getProperty("velocimacro.library.path");
            if (libfiles == null) {
                this.log.debug("\"{}\" is not set. Trying default library: {}", (Object)"velocimacro.library.path", (Object)"velocimacros.vtl");
                if (this.rsvc.getLoaderNameForResource("velocimacros.vtl") != null) {
                    libfiles = "velocimacros.vtl";
                } else {
                    this.log.debug("Default library {} not found. Trying old default library: {}", (Object)"velocimacros.vtl", (Object)"VM_global_library.vm");
                    if (this.rsvc.getLoaderNameForResource("VM_global_library.vm") != null) {
                        libfiles = "VM_global_library.vm";
                    } else {
                        this.log.debug("Old default library {} not found.", (Object)"VM_global_library.vm");
                    }
                }
            }
            if (libfiles != null) {
                this.macroLibVec = new ArrayList<String>();
                if (libfiles instanceof Vector) {
                    this.macroLibVec.addAll((Vector)libfiles);
                } else if (libfiles instanceof String) {
                    this.macroLibVec.add((String)libfiles);
                }
                for (String lib : this.macroLibVec) {
                    if (!StringUtils.isNotEmpty(lib)) continue;
                    this.vmManager.setRegisterFromLib(true);
                    this.log.debug("adding VMs from VM library: {}", (Object)lib);
                    try {
                        Template template = this.rsvc.getTemplate(lib);
                        Twonk twonk = new Twonk();
                        twonk.template = template;
                        twonk.modificationTime = template.getLastModified();
                        this.libModMap.put(lib, twonk);
                    }
                    catch (Exception e) {
                        String msg = "Velocimacro: Error using VM library: " + lib;
                        this.log.error(msg, e);
                        throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
                    }
                    this.log.trace("VM library registration complete.");
                    this.vmManager.setRegisterFromLib(false);
                }
            }
            this.setAddMacroPermission(true);
            if (!this.rsvc.getBoolean("velocimacro.inline.allow", true)) {
                this.setAddMacroPermission(false);
                this.log.debug("allowInline = false: VMs can NOT be defined inline in templates");
            } else {
                this.log.debug("allowInline = true: VMs can be defined inline in templates");
            }
            this.setReplacementPermission(false);
            if (this.rsvc.getBoolean("velocimacro.inline.replace_global", false)) {
                this.setReplacementPermission(true);
                this.log.debug("allowInlineToOverride = true: VMs defined inline may replace previous VM definitions");
            } else {
                this.log.debug("allowInlineToOverride = false: VMs defined inline may NOT replace previous VM definitions");
            }
            this.vmManager.setNamespaceUsage(true);
            this.setTemplateLocalInline(this.rsvc.getBoolean("velocimacro.inline.local_scope", false));
            if (this.getTemplateLocalInline()) {
                this.log.debug("allowInlineLocal = true: VMs defined inline will be local to their defining template only.");
            } else {
                this.log.debug("allowInlineLocal = false: VMs defined inline will be global in scope if allowed.");
            }
            this.vmManager.setTemplateLocalInlineVM(this.getTemplateLocalInline());
            this.setAutoload(this.rsvc.getBoolean("velocimacro.library.autoreload", false));
            if (this.getAutoload()) {
                this.log.debug("autoload on: VM system will automatically reload global library macros");
            } else {
                this.log.debug("autoload off: VM system will not automatically reload global library macros");
            }
            this.log.trace("Velocimacro: initialization complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVelocimacro(String name, Node macroBody, List<Macro.MacroArg> macroArgs, Template definingTemplate) {
        if (name == null || macroBody == null || macroArgs == null || definingTemplate == null) {
            String msg = "VM '" + name + "' addition rejected: ";
            msg = name == null ? msg + "name" : (macroBody == null ? msg + "macroBody" : (macroArgs == null ? msg + "macroArgs" : msg + "sourceTemplate"));
            msg = msg + " argument was null";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (!this.canAddVelocimacro(name, definingTemplate)) {
            return false;
        }
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.vmManager.addVM(name, macroBody, macroArgs, definingTemplate, this.replaceAllowed);
        }
        this.log.debug("added VM {}: source={}", (Object)name, (Object)definingTemplate);
        return true;
    }

    private synchronized boolean canAddVelocimacro(String name, Template definingTemplate) {
        if (this.autoReloadLibrary && this.macroLibVec != null && this.macroLibVec.contains(definingTemplate.getName())) {
            return true;
        }
        if (!this.addNewAllowed) {
            this.log.warn("VM addition rejected: {}: inline VelociMacros not allowed.", (Object)name);
            return false;
        }
        if (!this.templateLocal && !this.replaceAllowed && this.isVelocimacro(name, definingTemplate)) {
            this.log.debug("VM addition rejected: {}: inline not allowed to replace existing VM", (Object)name);
            return false;
        }
        return true;
    }

    public boolean isVelocimacro(String vm, Template template) {
        return this.vmManager.get(vm, null, template) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directive getVelocimacro(String vmName, Template renderingTemplate, Template sourceTemplate) {
        VelocimacroProxy vp = null;
        vp = this.vmManager.get(vmName, renderingTemplate, sourceTemplate);
        if (vp != null && this.autoReloadLibrary) {
            VelocimacroFactory velocimacroFactory = this;
            synchronized (velocimacroFactory) {
                String lib = this.vmManager.getLibraryName(vmName, sourceTemplate);
                if (lib != null) {
                    try {
                        Twonk tw = (Twonk)this.libModMap.get(lib);
                        if (tw != null) {
                            Template template = tw.template;
                            long tt = tw.modificationTime;
                            long ft = template.getResourceLoader().getLastModified(template);
                            if (ft > tt) {
                                this.log.debug("auto-reloading VMs from VM library: {}", (Object)lib);
                                tw.modificationTime = ft;
                                tw.template = template = this.rsvc.getTemplate(lib);
                                tw.modificationTime = template.getLastModified();
                            }
                        }
                    }
                    catch (Exception e) {
                        String msg = "Velocimacro: Error using VM library: " + lib;
                        this.log.error(msg, e);
                        throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
                    }
                    vp = this.vmManager.get(vmName, sourceTemplate, renderingTemplate);
                }
            }
        }
        return vp;
    }

    private void setTemplateLocalInline(boolean b) {
        this.templateLocal = b;
    }

    private boolean getTemplateLocalInline() {
        return this.templateLocal;
    }

    private boolean setAddMacroPermission(boolean addNewAllowed) {
        boolean b = this.addNewAllowed;
        this.addNewAllowed = addNewAllowed;
        return b;
    }

    private boolean setReplacementPermission(boolean arg) {
        boolean b = this.replaceAllowed;
        this.replaceAllowed = arg;
        this.vmManager.setInlineReplacesGlobal(arg);
        return b;
    }

    private void setAutoload(boolean b) {
        this.autoReloadLibrary = b;
    }

    private boolean getAutoload() {
        return this.autoReloadLibrary;
    }

    private static class Twonk {
        public Template template;
        public long modificationTime;

        private Twonk() {
        }
    }
}

