/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.serializer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.common.Anchor;
import org.snakeyaml.engine.v2.emitter.Emitable;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.nodes.AnchorNode;
import org.snakeyaml.engine.v2.nodes.CollectionNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;

public class Serializer {
    private final DumpSettings settings;
    private final Emitable emitable;
    private Set<Node> serializedNodes;
    private Map<Node, Anchor> anchors;

    public Serializer(DumpSettings settings2, Emitable emitable) {
        this.settings = settings2;
        this.emitable = emitable;
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, Anchor>();
    }

    public void serialize(Node node) {
        this.emitable.emit(new DocumentStartEvent(this.settings.isExplicitStart(), this.settings.getYamlDirective(), this.settings.getTagDirective()));
        this.anchorNode(node);
        this.settings.getExplicitRootTag().ifPresent(tag -> node.setTag((Tag)tag));
        this.serializeNode(node, Optional.empty());
        this.emitable.emit(new DocumentEndEvent(this.settings.isExplicitEnd()));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    public void open() {
        this.emitable.emit(new StreamStartEvent());
    }

    public void close() {
        this.emitable.emit(new StreamEndEvent());
    }

    private void anchorNode(Node node) {
        if (node.getNodeType() == NodeType.ANCHOR) {
            node = ((AnchorNode)node).getRealNode();
        }
        if (this.anchors.containsKey(node)) {
            Anchor anchor = this.anchors.get(node);
            if (null == anchor) {
                anchor = this.settings.getAnchorGenerator().nextAnchor(node);
                this.anchors.put(node, anchor);
            }
        } else {
            this.anchors.put(node, null);
            switch (node.getNodeType()) {
                case SEQUENCE: {
                    SequenceNode seqNode = (SequenceNode)node;
                    List<Node> list2 = seqNode.getValue();
                    for (Node item2 : list2) {
                        this.anchorNode(item2);
                    }
                    break;
                }
                case MAPPING: {
                    MappingNode mnode = (MappingNode)node;
                    List<NodeTuple> map2 = mnode.getValue();
                    for (NodeTuple object : map2) {
                        Node key = object.getKeyNode();
                        Node value2 = object.getValueNode();
                        this.anchorNode(key);
                        this.anchorNode(value2);
                    }
                    break;
                }
            }
        }
    }

    private void serializeNode(Node node, Optional<Node> parent) {
        if (node.getNodeType() == NodeType.ANCHOR) {
            node = ((AnchorNode)node).getRealNode();
        }
        Optional<Anchor> tAlias = Optional.ofNullable(this.anchors.get(node));
        if (this.serializedNodes.contains(node)) {
            this.emitable.emit(new AliasEvent(tAlias));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeType()) {
                case SCALAR: {
                    ScalarNode scalarNode = (ScalarNode)node;
                    Tag detectedTag = this.settings.getScalarResolver().resolve(scalarNode.getValue(), true);
                    Tag defaultTag = this.settings.getScalarResolver().resolve(scalarNode.getValue(), false);
                    ImplicitTuple tuple = new ImplicitTuple(node.getTag().equals(detectedTag), node.getTag().equals(defaultTag));
                    ScalarEvent event = new ScalarEvent(tAlias, Optional.of(node.getTag().getValue()), tuple, scalarNode.getValue(), scalarNode.getScalarStyle());
                    this.emitable.emit(event);
                    break;
                }
                case SEQUENCE: {
                    SequenceNode seqNode = (SequenceNode)node;
                    boolean implicitS = node.getTag().equals(Tag.SEQ);
                    this.emitable.emit(new SequenceStartEvent(tAlias, Optional.of(node.getTag().getValue()), implicitS, seqNode.getFlowStyle()));
                    List<Node> list2 = seqNode.getValue();
                    for (Node item2 : list2) {
                        this.serializeNode(item2, Optional.of(node));
                    }
                    this.emitable.emit(new SequenceEndEvent());
                    break;
                }
                default: {
                    boolean implicitM = node.getTag().equals(Tag.MAP);
                    this.emitable.emit(new MappingStartEvent(tAlias, Optional.of(node.getTag().getValue()), implicitM, ((CollectionNode)node).getFlowStyle()));
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> map2 = mappingNode.getValue();
                    for (NodeTuple entry : map2) {
                        Node key = entry.getKeyNode();
                        Node value2 = entry.getValueNode();
                        this.serializeNode(key, Optional.of(mappingNode));
                        this.serializeNode(value2, Optional.of(mappingNode));
                    }
                    this.emitable.emit(new MappingEndEvent());
                }
            }
        }
    }
}

