/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class DynamicSetterAccessor
implements AccessorNode {
    private final Method method;
    private Class targetType;
    public static final Object[] EMPTY = new Object[0];

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        try {
            return this.method.invoke(ctx, DataConversion.convert(value2, this.targetType));
        }
        catch (Exception e) {
            throw new RuntimeException("error binding property", e);
        }
    }

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        return null;
    }

    public DynamicSetterAccessor(Method method) {
        this.method = method;
        this.targetType = method.getParameterTypes()[0];
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        return null;
    }

    @Override
    public AccessorNode getNextNode() {
        return null;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    @Override
    public Class getKnownEgressType() {
        return this.targetType;
    }
}

