'''OpenGL extension NV.blend_minmax_factor

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.blend_minmax_factor to provide a more 
Python-friendly API

Overview (from the spec)
	
	The EXT_blend_minmax extension extended the GL's blending
	functionality to allow the blending equation to be specified by the
	application. That extension introduced the MIN_EXT and MAX_EXT blend
	equations, which caused the result of the blend equation to become
	the minimum or maximum of the source color and destination color,
	respectively.
	
	The MIN_EXT and MAX_EXT blend equations, however, do not include the
	source or destination blend factors in the arguments to the min and
	max functions.  This extension provides two new blend equations that
	produce the minimum or maximum of the products of the source color
	and source factor, and the destination color and destination factor.
	
	This NVIDIA extension has some limitations relative to the
	AMD_blend_minmax_factor extension.  See issues #1, #2, and #3.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/blend_minmax_factor.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.blend_minmax_factor import *
from OpenGL.raw.GLES2.NV.blend_minmax_factor import _EXTENSION_NAME

def glInitBlendMinmaxFactorNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION