'''OpenGL extension APPLE.texture_packed_float

This module customises the behaviour of the 
OpenGL.raw.GLES2.APPLE.texture_packed_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds two new 3-component floating-point texture formats
	that fit within a single 32-bit word called R11F_G11F_B10F and RGB9_E5 
	
	The first RGB format, R11F_G11F_B10F, stores 5 bits of biased exponent 
	per component in the same manner as 16-bit floating-point formats, but 
	rather than 10 mantissa bits, the red, green, and blue components have 
	6, 6, and 5 bits respectively. Each mantissa is assumed to have an 
	implied leading one except in the denorm exponent case.  There is no 
	sign bit so only non-negative values can be represented.  Positive 
	infinity, positivedenorms, and positive NaN values are representable.  
	The value of the fourth component returned by a texture fetch is always
	1.0.
	
	The second RGB format, RGB9_E5, stores a single 5-bit exponent (biased 
	up by 15) and three 9-bit mantissas for each respective component.  
	There is no sign bit so all three components must be non-negative.  
	The fractional mantissas are stored without an implied 1 to the left 
	of the decimal point. Neither infinity nor not-a-number (NaN) are 
	representable in this shared exponent format.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/APPLE/texture_packed_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.APPLE.texture_packed_float import *
from OpenGL.raw.GLES2.APPLE.texture_packed_float import _EXTENSION_NAME

def glInitTexturePackedFloatAPPLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION