/*
   SPDX-FileCopyrightText: 2013-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef MULTIIMAPVACATIONMANAGER_H
#define MULTIIMAPVACATIONMANAGER_H

#include <QObject>
#include <QMap>
#include "util_p.h"
#include "ksieveui_export.h"

class QUrl;

namespace KSieveUi {
class CheckKolabKep14SupportJob;
class VacationCheckJob;
class SieveImapPasswordProvider;
/**
 * @brief The MultiImapVacationManager class
 * @author Laurent Montel <montel@kde.org>
 */
class KSIEVEUI_EXPORT MultiImapVacationManager : public QObject
{
    Q_OBJECT
public:
    explicit MultiImapVacationManager(SieveImapPasswordProvider *passwordProvider, QObject *parent = nullptr);
    ~MultiImapVacationManager();

    void checkVacation();
    QMap<QString, KSieveUi::Util::AccountInfo> serverList() const;
    void checkVacation(const QString &serverName, const QUrl &url);

    bool kep14Support(const QString &serverName) const;
Q_SIGNALS:
    void scriptActive(bool active, const QString &serverName);
    void scriptAvailable(const QString &serverName, const QStringList &sieveCapabilities, const QString &scriptName, const QString &script, bool active);

private Q_SLOTS:
    void slotScriptActive(KSieveUi::VacationCheckJob *job, const QString &scriptName, bool active);
    void slotCheckKep14Ended(KSieveUi::CheckKolabKep14SupportJob *job, bool success);

private:
    Q_DISABLE_COPY(MultiImapVacationManager)
    SieveImapPasswordProvider *const mPasswordProvider;
    int mNumberOfJobs = 0;
    bool mCheckInProgress = false;

    QMap<QString, bool> mKep14Support;      //if the server has KEP:14 support
};
}
#endif // MULTIIMAPVACATIONMANAGER_H
