/**
 * SECTION:tpf-persona
 * @short_description: A persona subclass which represents a single instant messaging contact from Telepathy.
 * 
 * <para>There is a one-to-one correspondence between <link linkend="TpfPersona"><type>TpfPersona</type></link>s and <link linkend="TpContact"><type>TpContact</type></link>s, although at any time the <link linkend="TpfPersona--contact"><type>"contact"</type></link> property of a persona may be <code>null</code> if the contact&apos;s Telepathy connection isn&apos;t available (e.g. due to being offline). In this case, the persona&apos;s properties persist from a local cache.</para>
 */
/**
 * TPF_TYPE_PERSONA:
 * 
 * The type for <link linkend="TpfPersona"><type>TpfPersona</type></link>.
 */
/**
 * tpf_persona_new:
 * @contact: (in): &nbsp;.  <para>the Telepathy contact being represented by the persona </para>
 * @store: (in): &nbsp;.  <para>the persona store to place the persona in </para>
 * 
 * Create a new persona.
 * 
 * <para>Create a new persona for the <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> <code>store</code>, representing the Telepathy contact given by <code>contact</code>.</para>
 */
/**
 * TpfPersona:is-in-contact-list:
 * 
 * Whether the Persona is in the user&apos;s contact list.
 * 
 * <para>This will be true for most <link linkend="FolksPersona"><type>FolksPersona</type></link>s, but may not be true for personas where <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> is true. If it&apos;s false in this case, it means that the persona has been retrieved from the Telepathy connection, but has not been added to the user&apos;s contact list.</para>
 *
 * Since: 0.3.5
 */
/**
 * tpf_persona_get_is_in_contact_list:
 * @self: the <link linkend="TpfPersona"><type>TpfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="TpfPersona--is-in-contact-list"><type>"is-in-contact-list"</type></link> property.
 * 
 * Whether the Persona is in the user&apos;s contact list.
 * 
 * <para>This will be true for most <link linkend="FolksPersona"><type>FolksPersona</type></link>s, but may not be true for personas where <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> is true. If it&apos;s false in this case, it means that the persona has been retrieved from the Telepathy connection, but has not been added to the user&apos;s contact list.</para>
 * 
 * Returns: the value of the <link linkend="TpfPersona--is-in-contact-list"><type>"is-in-contact-list"</type></link> property
 *
 * Since: 0.3.5
 */
/**
 * tpf_persona_set_is_in_contact_list:
 * @self: the <link linkend="TpfPersona"><type>TpfPersona</type></link> instance to modify
 * @value: the new value of the <link linkend="TpfPersona--is-in-contact-list"><type>"is-in-contact-list"</type></link> property
 * 
 * Set the value of the <link linkend="TpfPersona--is-in-contact-list"><type>"is-in-contact-list"</type></link> property to @value.
 * 
 * Whether the Persona is in the user&apos;s contact list.
 * 
 * <para>This will be true for most <link linkend="FolksPersona"><type>FolksPersona</type></link>s, but may not be true for personas where <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> is true. If it&apos;s false in this case, it means that the persona has been retrieved from the Telepathy connection, but has not been added to the user&apos;s contact list.</para>
 *
 * Since: 0.3.5
 */
/**
 * TpfPersona:contact:
 * 
 * The Telepathy contact represented by this persona.
 * 
 * <para>Note that this may be <code>null</code> if the <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> providing this <link linkend="tpf-persona-new"><function>tpf_persona_new()</function></link> isn&apos;t currently available (e.g. due to not being connected to the network). In this case, most other properties of the <link linkend="tpf-persona-new"><function>tpf_persona_new()</function></link> are being retrieved from a cache and may not be current (though there&apos;s no way to tell this).</para>
 */
/**
 * tpf_persona_get_contact:
 * @self: the <link linkend="TpfPersona"><type>TpfPersona</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="TpfPersona--contact"><type>"contact"</type></link> property.
 * 
 * The Telepathy contact represented by this persona.
 * 
 * <para>Note that this may be <code>null</code> if the <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> providing this <link linkend="tpf-persona-new"><function>tpf_persona_new()</function></link> isn&apos;t currently available (e.g. due to not being connected to the network). In this case, most other properties of the <link linkend="tpf-persona-new"><function>tpf_persona_new()</function></link> are being retrieved from a cache and may not be current (though there&apos;s no way to tell this).</para>
 * 
 * Returns: the value of the <link linkend="TpfPersona--contact"><type>"contact"</type></link> property
 */
/**
 * tpf_persona_dup_for_contact:
 * @contact: (in): &nbsp;.  <para>the Telepathy contact of the persona </para>
 * 
 * Look up a <link linkend="TpfPersona"><type>TpfPersona</type></link> by its <link linkend="TpContact"><type>TpContact</type></link>.
 * 
 * <para>If the <link linkend="TpAccount"><type>TpAccount</type></link> for the contact&apos;s <link linkend="TpConnection"><type>TpConnection</type></link> is <code>null</code>, or if a <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> can&apos;t be found for that account, <code>null</code> will be returned. Otherwise, if a <link linkend="TpfPersona"><type>TpfPersona</type></link> already exists for the given contact, that will be returned; if one doesn&apos;t exist a new one will be created and returned. In this case, the <link linkend="TpfPersona"><type>TpfPersona</type></link> will be added to the <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> associated with the account, and will be removed when <code>contact</code> is destroyed.</para>
 * 
 * Returns: <para>the persona associated with the contact, or <code>null</code> </para>
 *
 * Since: 0.6.6
 */
/**
 * TpfPersona:
 * 
 * A persona subclass which represents a single instant messaging contact from Telepathy.
 * 
 * <para>There is a one-to-one correspondence between <link linkend="TpfPersona"><type>TpfPersona</type></link>s and <link linkend="TpContact"><type>TpContact</type></link>s, although at any time the <link linkend="TpfPersona--contact"><type>"contact"</type></link> property of a persona may be <code>null</code> if the contact&apos;s Telepathy connection isn&apos;t available (e.g. due to being offline). In this case, the persona&apos;s properties persist from a local cache.</para>
 */
/**
 * TpfPersonaClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="TPF-TYPE-PERSONA:CAPS"><literal>TPF_TYPE_PERSONA</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
